/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ASN1Set;
import cn.tca.TopBasicCrypto.asn1.ASN1TaggedObject;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.SignedData;
import cn.tca.TopBasicCrypto.asn1.x509.CertificateList;
import cn.tca.TopBasicCrypto.asn1.x509.X509CertificateStructure;
import cn.tca.TopBasicCrypto.jce.provider.X509CRLObject;
import cn.topca.security.sm.PEMUtil;
import cn.topca.security.sm.SM2CertPath;
import cn.topca.security.sm.SMCertificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SMCertificateFactory
extends CertificateFactorySpi {
    private static final long MAX_MEMORY = Runtime.getRuntime().maxMemory();
    private static final PEMUtil PEM_CERT_PARSER = new PEMUtil("CERTIFICATE");
    private static final PEMUtil PEM_CRL_PARSER = new PEMUtil("CRL");
    private ASN1Set sData = null;
    private int sDataObjectCount = 0;
    private InputStream currentStream = null;
    private ASN1Set sCrlData = null;
    private int sCrlDataObjectCount = 0;
    private InputStream currentCrlStream = null;

    private Certificate readDERCertificate(ASN1InputStream dIn) throws IOException, CertificateParsingException {
        ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
        if (seq.size() > 1 && seq.getObjectAt(0) instanceof DERObjectIdentifier && seq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)seq.getObjectAt(1)), (boolean)true)).getCertificates();
            return this.getCertificate();
        }
        return new SMCertificate(X509CertificateStructure.getInstance((Object)seq));
    }

    private Certificate getCertificate() throws CertificateParsingException {
        if (this.sData != null) {
            while (this.sDataObjectCount < this.sData.size()) {
                DEREncodable obj;
                if (!((obj = this.sData.getObjectAt(this.sDataObjectCount++)) instanceof ASN1Sequence)) continue;
                return new SMCertificate(X509CertificateStructure.getInstance((Object)obj));
            }
        }
        return null;
    }

    private Certificate readPEMCertificate(InputStream in) throws IOException, CertificateParsingException {
        ASN1Sequence seq = PEM_CERT_PARSER.readPEMObject(in);
        if (seq != null) {
            return new SMCertificate(X509CertificateStructure.getInstance((Object)seq));
        }
        return null;
    }

    protected CRL createCRL(CertificateList c) throws CRLException {
        return new X509CRLObject(c);
    }

    private CRL readPEMCRL(InputStream in) throws IOException, CRLException {
        ASN1Sequence seq = PEM_CRL_PARSER.readPEMObject(in);
        if (seq != null) {
            return this.createCRL(CertificateList.getInstance((Object)seq));
        }
        return null;
    }

    private CRL readDERCRL(ASN1InputStream aIn) throws IOException, CRLException {
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        if (seq.size() > 1 && seq.getObjectAt(0) instanceof DERObjectIdentifier && seq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sCrlData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)seq.getObjectAt(1)), (boolean)true)).getCRLs();
            return this.getCRL();
        }
        return this.createCRL(CertificateList.getInstance((Object)seq));
    }

    private CRL getCRL() throws CRLException {
        if (this.sCrlData == null || this.sCrlDataObjectCount >= this.sCrlData.size()) {
            return null;
        }
        return this.createCRL(CertificateList.getInstance((Object)this.sCrlData.getObjectAt(this.sCrlDataObjectCount++)));
    }

    public Certificate engineGenerateCertificate(InputStream in) throws CertificateException {
        if (this.currentStream == null) {
            this.currentStream = in;
            this.sData = null;
            this.sDataObjectCount = 0;
        } else if (this.currentStream != in) {
            this.currentStream = in;
            this.sData = null;
            this.sDataObjectCount = 0;
        }
        try {
            if (this.sData != null) {
                if (this.sDataObjectCount != this.sData.size()) {
                    return this.getCertificate();
                }
                this.sData = null;
                this.sDataObjectCount = 0;
                return null;
            }
            int limit = this.getReadLimit(in);
            PushbackInputStream pis = new PushbackInputStream(in);
            int tag = pis.read();
            if (tag == -1) {
                return null;
            }
            pis.unread(tag);
            if (tag != 48) {
                return this.readPEMCertificate(pis);
            }
            return this.readDERCertificate(new ASN1InputStream((InputStream)pis, limit));
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
    }

    public Collection engineGenerateCertificates(InputStream inStream) throws CertificateException {
        Certificate cert;
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        while ((cert = this.engineGenerateCertificate(inStream)) != null) {
            certs.add(cert);
        }
        return certs;
    }

    public CRL engineGenerateCRL(InputStream inStream) throws CRLException {
        if (this.currentCrlStream == null) {
            this.currentCrlStream = inStream;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        } else if (this.currentCrlStream != inStream) {
            this.currentCrlStream = inStream;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        }
        try {
            if (this.sCrlData != null) {
                if (this.sCrlDataObjectCount != this.sCrlData.size()) {
                    return this.getCRL();
                }
                this.sCrlData = null;
                this.sCrlDataObjectCount = 0;
                return null;
            }
            int limit = this.getReadLimit(inStream);
            PushbackInputStream pis = new PushbackInputStream(inStream);
            int tag = pis.read();
            if (tag == -1) {
                return null;
            }
            pis.unread(tag);
            if (tag != 48) {
                return this.readPEMCRL(pis);
            }
            return this.readDERCRL(new ASN1InputStream((InputStream)pis, limit, true));
        }
        catch (CRLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CRLException(e.toString());
        }
    }

    public Collection engineGenerateCRLs(InputStream inStream) throws CRLException {
        CRL crl;
        ArrayList<CRL> crls = new ArrayList<CRL>();
        while ((crl = this.engineGenerateCRL(inStream)) != null) {
            crls.add(crl);
        }
        return crls;
    }

    public Iterator engineGetCertPathEncodings() {
        return SM2CertPath.certPathEncodings.iterator();
    }

    public CertPath engineGenerateCertPath(InputStream inStream) throws CertificateException {
        return this.engineGenerateCertPath(inStream, "PkiPath");
    }

    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        return new SM2CertPath(inStream, encoding);
    }

    public CertPath engineGenerateCertPath(List certificates) throws CertificateException {
        for (Object obj : certificates) {
            if (obj == null || obj instanceof X509Certificate) continue;
            throw new CertificateException("list contains non X509Certificate object while creating CertPath\n" + obj.toString());
        }
        return new SM2CertPath(certificates);
    }

    private int getReadLimit(InputStream in) throws IOException {
        if (in instanceof ByteArrayInputStream) {
            return in.available();
        }
        if (MAX_MEMORY > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)MAX_MEMORY;
    }
}

