/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.util;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DERBMPString;
import cn.tca.TopBasicCrypto.asn1.DERIA5String;
import cn.tca.TopBasicCrypto.asn1.DERPrintableString;
import cn.tca.TopBasicCrypto.asn1.DERT61String;
import cn.tca.TopBasicCrypto.asn1.DERUTF8String;
import cn.tca.TopBasicCrypto.asn1.x500.RDN;
import cn.tca.TopBasicCrypto.asn1.x500.X500Name;
import cn.tca.TopBasicCrypto.asn1.x500.style.BCStyle;
import cn.topca.security.x509.X509Name;

public class BCUtil {
    public static RDN toRDN(X509Name.AttributeTypeAndValue attr) {
        return new RDN(BCUtil.toRDNOID(attr.getType()), BCUtil.toASN1String(attr.getValue(), attr.getAttrValueType()));
    }

    public static ASN1ObjectIdentifier toRDNOID(String type) {
        return BCStyle.INSTANCE.attrNameToOID(type);
    }

    public static ASN1Encodable toASN1String(String value, X509Name.AttributeTypeAndValue.AttributeValueType attrValueType) {
        if (attrValueType == null) {
            attrValueType = X509Name.AttributeTypeAndValue.AttributeValueType.UTF8;
        }
        switch (attrValueType) {
            case PRINTABLE: {
                return new DERPrintableString(value);
            }
            case IA5: {
                return new DERIA5String(value);
            }
            case BMP: {
                return new DERBMPString(value);
            }
            case T61: {
                return new DERT61String(value);
            }
        }
        return new DERUTF8String(value);
    }

    public static X500Name toX500Name(X509Name name) {
        X509Name.AttributeTypeAndValue[] attrs = name.getAttributeTypeAndValues();
        RDN[] rDNs = new RDN[attrs.length];
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                rDNs[i] = BCUtil.toRDN(attrs[i]);
            }
        }
        return new X500Name(rDNs);
    }
}

