/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.x509.extension.logotype;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1Object;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ASN1TaggedObject;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.DERTaggedObject;
import cn.tca.TopBasicCrypto.util.encoders.Base64;
import cn.tca.TopBasicCrypto.x509.extension.X509ExtensionUtil;
import cn.topca.security.x509.extension.logotype.LogotypeData;
import cn.topca.security.x509.extension.logotype.LogotypeDetails;
import cn.topca.security.x509.extension.logotype.LogotypeInfo;
import cn.topca.security.x509.extension.logotype.OtherLogotypeInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class Logotype
extends ASN1Encodable {
    public static final DERObjectIdentifier id_pe_logotype = new DERObjectIdentifier("1.3.6.1.5.5.7.1.12");
    public static final DERObjectIdentifier id_logo = new DERObjectIdentifier("1.3.6.1.5.5.7.20");
    public static final DERObjectIdentifier id_logo_loyalty = new DERObjectIdentifier("1.3.6.1.5.5.7.20.1");
    public static final DERObjectIdentifier id_logo_background = new DERObjectIdentifier("1.3.6.1.5.5.7.20.2");
    ASN1Sequence communityLogos = null;
    ASN1TaggedObject issuerLogo = null;
    ASN1TaggedObject subjectLogo = null;
    ASN1Sequence otherLogos = null;

    public static Logotype getInstance(ASN1Sequence seq) {
        ASN1Sequence communityLogosSeq = null;
        ASN1TaggedObject issuerLogoSeq = null;
        ASN1TaggedObject subjectLogoSeq = null;
        ASN1Sequence otherLogosSeq = null;
        Enumeration e = seq.getObjects();
        block6: while (e.hasMoreElements()) {
            DERTaggedObject o = (DERTaggedObject)e.nextElement();
            DERObject obj = o.getObject();
            switch (o.getTagNo()) {
                case 0: {
                    communityLogosSeq = ASN1Sequence.getInstance((Object)obj);
                    continue block6;
                }
                case 1: {
                    issuerLogoSeq = (ASN1TaggedObject)obj;
                    continue block6;
                }
                case 2: {
                    subjectLogoSeq = (ASN1TaggedObject)obj;
                    continue block6;
                }
                case 3: {
                    otherLogosSeq = ASN1Sequence.getInstance((Object)obj);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("illegal tag");
        }
        LogotypeInfo[] communityLogos = null;
        if (communityLogosSeq != null) {
            Vector<LogotypeInfo> v = new Vector<LogotypeInfo>();
            for (int index = 0; index < communityLogosSeq.size(); ++index) {
                DEREncodable obj = communityLogosSeq.getObjectAt(index);
                ASN1TaggedObject coli = (ASN1TaggedObject)obj;
                LogotypeInfo li = LogotypeInfo.getInstance(coli);
                v.add(li);
            }
            communityLogos = v.toArray(new LogotypeInfo[communityLogosSeq.size()]);
        }
        LogotypeInfo issuerLogo = null;
        if (issuerLogoSeq != null) {
            issuerLogo = LogotypeInfo.getInstance(issuerLogoSeq);
        }
        LogotypeInfo subjectLogo = null;
        if (subjectLogoSeq != null) {
            subjectLogo = LogotypeInfo.getInstance(subjectLogoSeq);
        }
        OtherLogotypeInfo[] otherLogos = null;
        if (otherLogosSeq != null) {
            Vector<OtherLogotypeInfo> v = new Vector<OtherLogotypeInfo>();
            for (int index = 0; index < otherLogosSeq.size(); ++index) {
                DEREncodable obj = otherLogosSeq.getObjectAt(index);
                ASN1Sequence coli = (ASN1Sequence)obj;
                OtherLogotypeInfo li = OtherLogotypeInfo.getInstance(coli);
                v.add(li);
            }
            communityLogos = v.toArray(new LogotypeInfo[otherLogosSeq.size()]);
        }
        return new Logotype(communityLogos, issuerLogo, subjectLogo, otherLogos);
    }

    public static Logotype getInstance(byte[] logotypeBytes) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(logotypeBytes);
        ASN1InputStream aStream = new ASN1InputStream((InputStream)stream);
        ASN1Sequence root = (ASN1Sequence)aStream.readObject();
        Logotype logotype = Logotype.getInstance(root);
        return logotype;
    }

    public Logotype(LogotypeInfo[] communityLogos, LogotypeInfo issuerLogo, LogotypeInfo subjectLogo, OtherLogotypeInfo[] otherLogos) {
        this.communityLogos = communityLogos != null ? new DERSequence((ASN1Encodable[])communityLogos) : null;
        this.issuerLogo = issuerLogo != null ? (ASN1TaggedObject)issuerLogo.toASN1Object() : null;
        this.subjectLogo = subjectLogo != null ? (ASN1TaggedObject)subjectLogo.toASN1Object() : null;
        this.otherLogos = otherLogos != null ? new DERSequence((ASN1Encodable[])otherLogos) : null;
    }

    public LogotypeInfo[] getCommunityLogos() {
        if (this.communityLogos != null) {
            Vector<LogotypeDetails> v = new Vector<LogotypeDetails>();
            for (int i = 0; i < this.communityLogos.size(); ++i) {
                v.add(LogotypeDetails.getInstance(this.communityLogos.getObjectAt(i)));
            }
            LogotypeInfo[] infos = v.toArray(new LogotypeInfo[this.communityLogos.size()]);
            return infos;
        }
        return null;
    }

    public LogotypeInfo getIssuerLogo() {
        if (this.issuerLogo != null) {
            return LogotypeInfo.getInstance(this.issuerLogo);
        }
        return null;
    }

    public String getIssuerLogoURL(String der) throws IOException, CertificateException {
        String url = null;
        X509Certificate relyingPartyCert = Logotype.der2cert(der);
        byte[] fromExtensionValue = relyingPartyCert.getExtensionValue(id_pe_logotype.getId());
        if (fromExtensionValue == null || fromExtensionValue.length == 0) {
            return null;
        }
        ASN1Object extVal = X509ExtensionUtil.fromExtensionValue((byte[])fromExtensionValue);
        Logotype logotype = Logotype.getInstance((ASN1Sequence)extVal);
        LogotypeInfo logotypeInfo = logotype.getIssuerLogo();
        if (logotypeInfo == null) {
            return null;
        }
        if (logotypeInfo.getTagNo() == 0) {
            LogotypeData direct = logotypeInfo.getLogotypeData();
            LogotypeDetails[] images = direct.getImages();
            LogotypeDetails logotypeDetails = images[0];
            String[] uris = logotypeDetails.getLogotypeURI();
            url = uris[0];
        } else if (logotypeInfo.getTagNo() == 1) {
            // empty if block
        }
        return url;
    }

    public LogotypeInfo getSubjectLogo() {
        if (this.subjectLogo != null) {
            return LogotypeInfo.getInstance(this.subjectLogo);
        }
        return null;
    }

    public LogotypeInfo[] getOtherLogos() {
        if (this.otherLogos != null) {
            Vector<LogotypeDetails> v = new Vector<LogotypeDetails>();
            for (int i = 0; i < this.otherLogos.size(); ++i) {
                v.add(LogotypeDetails.getInstance(this.otherLogos.getObjectAt(i)));
            }
            LogotypeInfo[] infos = v.toArray(new LogotypeInfo[this.otherLogos.size()]);
            return infos;
        }
        return null;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.communityLogos != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 0, (DEREncodable)this.communityLogos));
        }
        if (this.issuerLogo != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 1, (DEREncodable)this.issuerLogo));
        }
        if (this.subjectLogo != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 2, (DEREncodable)this.subjectLogo));
        }
        if (this.otherLogos != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 3, (DEREncodable)this.otherLogos));
        }
        return new DERSequence(v);
    }

    public static X509Certificate der2cert(String der) throws CertificateException {
        byte[] certBytes = Base64.decode((String)der);
        ByteArrayInputStream is = new ByteArrayInputStream(certBytes);
        BufferedInputStream bis = new BufferedInputStream(is);
        CertificateFactory cf = null;
        X509Certificate cert = null;
        cf = CertificateFactory.getInstance("X.509");
        cert = (X509Certificate)cf.generateCertificate(bis);
        return cert;
    }
}

