/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.x509.extension.logotype;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.topca.security.x509.extension.logotype.LogotypeDetails;
import cn.topca.security.x509.extension.logotype.LogotypeImageInfo;

public class LogotypeImage
extends ASN1Encodable {
    ASN1Sequence imageDetails = null;
    ASN1Sequence imageInfo = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogotypeImage getInstance(ASN1Sequence sequence) {
        DEREncodable obj;
        DERSequence imageDetails = null;
        ASN1Sequence imageInfo = null;
        if (sequence.size() == 1) {
            obj = sequence.getObjectAt(0);
            if (!(obj instanceof ASN1Sequence)) throw new IllegalArgumentException("first object in sequence must be a sequence, not a: " + obj.getClass().getName());
            imageDetails = (DERSequence)obj;
        } else {
            if (sequence.size() != 2) throw new IllegalArgumentException("size of sequence must be 2 not " + sequence.size());
            obj = sequence.getObjectAt(0);
            if (!(obj instanceof ASN1Sequence)) {
                throw new IllegalArgumentException("first object of two in sequence must be a sequence, not a: " + obj.getClass().getName());
            }
            imageDetails = ASN1Sequence.getInstance((Object)obj);
            obj = sequence.getObjectAt(1);
            if (!(obj instanceof ASN1Sequence)) throw new IllegalArgumentException("second object in sequence must be a sequence, not a: " + obj.getClass().getName());
            imageInfo = ASN1Sequence.getInstance((Object)obj);
        }
        LogotypeDetails logotypeDetails = LogotypeDetails.getInstance(imageDetails);
        LogotypeImageInfo logotypeImageInfo = null;
        if (imageInfo == null) return new LogotypeImage(logotypeDetails, logotypeImageInfo);
        logotypeImageInfo = LogotypeImageInfo.getInstance(imageInfo);
        return new LogotypeImage(logotypeDetails, logotypeImageInfo);
    }

    public LogotypeImage(LogotypeDetails imageDetails, LogotypeImageInfo imageInfo) {
        this.imageDetails = ASN1Sequence.getInstance((Object)imageDetails.toASN1Object());
        if (imageInfo != null) {
            this.imageInfo = ASN1Sequence.getInstance((Object)imageInfo.toASN1Object());
        }
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.imageDetails);
        if (this.imageInfo != null) {
            v.add((DEREncodable)this.imageInfo);
        }
        return new DERSequence(v);
    }
}

