/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.x509.extension.logotype;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERIA5String;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.x509.DigestInfo;
import java.util.Vector;

public class LogotypeReference
extends ASN1Encodable {
    ASN1Sequence refStructHash = null;
    ASN1Sequence refStructURI = null;

    public static LogotypeReference getInstance(ASN1Sequence seq) {
        DigestInfo di;
        int i;
        ASN1Sequence refStructHashSeq = null;
        ASN1Sequence refStructURISeq = null;
        if (seq.size() != 2) {
            throw new IllegalArgumentException("size of sequence must be 2 not " + seq.size());
        }
        refStructHashSeq = ASN1Sequence.getInstance((Object)seq.getObjectAt(0));
        refStructURISeq = ASN1Sequence.getInstance((Object)seq.getObjectAt(1));
        DigestInfo[] refStructHash = null;
        DERIA5String[] refStructURI = null;
        Vector<DigestInfo> v = new Vector<DigestInfo>();
        for (i = 0; i < refStructHashSeq.size(); ++i) {
            di = DigestInfo.getInstance((Object)refStructHashSeq.getObjectAt(i));
            v.add(di);
        }
        refStructHash = v.toArray(new DigestInfo[refStructHashSeq.size()]);
        v = new Vector();
        for (i = 0; i < refStructURISeq.size(); ++i) {
            di = DERIA5String.getInstance((Object)refStructURISeq.getObjectAt(i));
            v.add(di);
        }
        refStructHash = v.toArray(new DigestInfo[refStructURISeq.size()]);
        return new LogotypeReference(refStructHash, refStructURI);
    }

    public ASN1Sequence getRefStructHash() {
        return this.refStructHash;
    }

    public ASN1Sequence getRefStructURI() {
        return this.refStructURI;
    }

    public LogotypeReference(DigestInfo[] refStructHash, DERIA5String[] refStructURI) {
        if (refStructHash.length != refStructURI.length) {
            throw new IllegalArgumentException("LogotypeReference: The sequences refStructHash and refStructURI must have the same size.");
        }
        this.refStructHash = new DERSequence((ASN1Encodable[])refStructHash);
        this.refStructURI = new DERSequence((ASN1Encodable[])refStructURI);
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.refStructHash);
        v.add((DEREncodable)this.refStructURI);
        return new DERSequence(v);
    }
}

