/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.controller;

import com.yaoming.module.security.service.SecurityEditService;
import com.yaoming.module.security.service.SecurityFunctionService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="securityFunctionEditController")
@RequestMapping(value={"/security/function"})
public class SecurityFunctionEditController {
    private Logger logger = LoggerFactory.getLogger(SecurityFunctionEditController.class);
    @Autowired
    private SecurityEditService securityEditService;
    @Autowired
    private SecurityFunctionService securityFunctionService;

    @RequestMapping(value={"/getTreeNode"})
    @ResponseBody
    public Map<String, Object> getTreeNode(@RequestParam(value="functionId", defaultValue="0") long functionId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.getTreeNode(functionId));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/getTree"})
    @ResponseBody
    public Map<String, Object> getTree() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.getTree());
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/getUserTree"})
    @ResponseBody
    public Map<String, Object> getUserTree() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Collection roles = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getAuthorities();
            Object[] rolesArray = roles.toArray();
            String[] roleNames = new String[roles.size()];
            for (int i = 0; i < rolesArray.length; ++i) {
                GrantedAuthority role = (GrantedAuthority)rolesArray[i];
                roleNames[i] = role.getAuthority();
            }
            result.put("data", this.securityFunctionService.getRoleFunctions(roleNames));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/node/save"})
    @ResponseBody
    public Map<String, Object> saveNode(@RequestParam(value="id") long id, @RequestParam(value="idOld") long idOld, @RequestParam(value="parentId") long parentId, @RequestParam(value="name") String name, @RequestParam(value="note") String note) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.saveFunctionNode(id, idOld, parentId, name, note));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/node/delete"})
    @ResponseBody
    public Map<String, Object> deleteNode(@RequestParam(value="id") long id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.deleteFunctionNode(id));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/leaf/save"})
    @ResponseBody
    public Map<String, Object> saveLeaf(@RequestParam(value="id") long id, @RequestParam(value="idOld") long idOld, @RequestParam(value="functionId") long functionId, @RequestParam(value="pattern") String pattern, @RequestParam(value="note") String note) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.saveFunctionLeaf(id, idOld, functionId, pattern, note));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/leaf/delete"})
    @ResponseBody
    public Map<String, Object> deleteLeaf(@RequestParam(value="id") long id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.deleteFunctionLeaf(id));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }
}

