/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.controller;

import com.yaoming.common.util.StringUtil;
import com.yaoming.module.security.service.SecurityEditService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="securityRoleEditController")
@RequestMapping(value={"/security/role"})
public class SecurityRoleEditController {
    @Autowired
    private SecurityEditService securityEditService;

    @RequestMapping(value={"/getlist"})
    @ResponseBody
    public Map<String, Object> getlist() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.getRoleList());
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/function/getlist"})
    @ResponseBody
    public Map<String, Object> getRoleFunctions(@RequestParam(value="roleId") long roleId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.getSelectedFunctions(roleId));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/function/save"})
    @ResponseBody
    public Map<String, Object> roleFuncSave(@RequestParam(value="roleId") long roleId, @RequestParam(value="functionIds") String functionIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.roleFuncSave(roleId, StringUtil.toLongArray((String)functionIds, (String)",")));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/function/add"})
    @ResponseBody
    public Map<String, Object> addRoleFunctions(@RequestParam(value="roleId") long roleId, @RequestParam(value="functionIds") String functionIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.addRoleFunctions(roleId, StringUtil.toLongArray((String)functionIds, (String)",")));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/function/delete"})
    @ResponseBody
    public Map<String, Object> deleteRoleFunctions(@RequestParam(value="roleId") long roleId, @RequestParam(value="functionIds") String functionIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.deleteRoleFunctions(roleId, StringUtil.toLongArray((String)functionIds, (String)",")));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/user/getlist"})
    @ResponseBody
    public Map<String, Object> getUserRoles(@RequestParam(value="userId") long userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.getUserRoleList(userId));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/user/add"})
    @ResponseBody
    public Map<String, Object> addUserRoles(@RequestParam(value="userId") long userId, @RequestParam(value="roleIds") String roleIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.addUserRoles(userId, StringUtil.toLongArray((String)roleIds, (String)",")));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/user/delete"})
    @ResponseBody
    public Map<String, Object> deleteUserRoles(@RequestParam(value="userId") long userId, @RequestParam(value="roleIds") String roleIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.deleteUserRoles(userId, StringUtil.toLongArray((String)roleIds, (String)",")));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public Map<String, Object> save(@RequestParam(value="id") long id, @RequestParam(value="name") String name, @RequestParam(value="note") String note) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.saveRole(id, name, note));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public Map<String, Object> delete(@RequestParam(value="id") long id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", this.securityEditService.deleteRole(id));
            result.put("code", "SUCCESS");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "FAIL");
            result.put("msg", "\u5931\u8d25");
        }
        return result;
    }
}

