/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.dao.repositoryimpl;

import com.yaoming.module.security.dao.SecurityFunctionExtendMapper;
import com.yaoming.module.security.dao.SecurityFunctionResourcePatternExtendMapper;
import com.yaoming.module.security.dao.SecurityGlobalResourcePatternExtendMapper;
import com.yaoming.module.security.dao.base.po.SecurityFunction;
import com.yaoming.module.security.dao.base.po.SecurityFunctionResourcePattern;
import com.yaoming.module.security.dao.base.po.SecurityGlobalResourcePattern;
import com.yaoming.module.security.dao.po.SecurityFunctionExtendPo;
import com.yaoming.module.security.domain.SecurityResource;
import com.yaoming.module.security.domain.impl.DefaultSecurityFunction;
import com.yaoming.module.security.domain.impl.DefaultSecurityResource;
import com.yaoming.module.security.domain.repository.DefaultSecurityLoaderRepository;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DefaultSecurityLoaderRepositoryImpl
implements DefaultSecurityLoaderRepository {
    @Autowired
    private SecurityGlobalResourcePatternExtendMapper globalResourceDao;
    @Autowired
    private SecurityFunctionResourcePatternExtendMapper functionResourceDao;
    @Autowired
    private SecurityFunctionExtendMapper functionDao;

    @Override
    public List<SecurityResource> getAllGlobalResources() {
        ArrayList<SecurityResource> result = new ArrayList<SecurityResource>();
        List<SecurityGlobalResourcePattern> patterns = this.globalResourceDao.selectAll();
        for (SecurityGlobalResourcePattern pattern : patterns) {
            result.add(new DefaultSecurityResource(pattern.getId(), pattern.getPattern(), pattern.getNote(), pattern.getAuthority()));
        }
        return result;
    }

    @Override
    public List<SecurityResource> getAllFunctionResources() {
        ArrayList<SecurityResource> result = new ArrayList<SecurityResource>();
        List<SecurityFunctionResourcePattern> patterns = this.functionResourceDao.selectAllFunctionResources();
        for (SecurityFunctionResourcePattern pattern : patterns) {
            result.add(new DefaultSecurityResource(pattern.getId(), pattern.getPattern(), pattern.getNote()));
        }
        return result;
    }

    @Override
    public List<com.yaoming.module.security.domain.SecurityFunction> getAllFunctions() {
        return this.getDoByPo(this.functionDao.selectAll());
    }

    @Override
    public List<com.yaoming.module.security.domain.SecurityFunction> getFunctionsByParent(long parentId) {
        return this.getDoByPo(this.functionDao.selectByParentId(parentId));
    }

    private com.yaoming.module.security.domain.SecurityFunction getDoByPo(SecurityFunctionExtendPo sf) {
        if (sf == null) {
            return null;
        }
        return new DefaultSecurityFunction((long)sf.getId(), (long)sf.getParentId(), sf.getName(), sf.getUrl(), sf.getIndex(), sf.getNote(), sf.getRoleIds());
    }

    private com.yaoming.module.security.domain.SecurityFunction getDoByPo(SecurityFunction sf) {
        if (sf == null) {
            return null;
        }
        return new DefaultSecurityFunction(sf.getId(), sf.getParentId(), sf.getName(), sf.getUrl(), sf.getIndex(), sf.getNote());
    }

    private List<com.yaoming.module.security.domain.SecurityFunction> getDoByPo(List<SecurityFunctionExtendPo> sfList) {
        ArrayList<com.yaoming.module.security.domain.SecurityFunction> result = new ArrayList<com.yaoming.module.security.domain.SecurityFunction>();
        if (sfList != null) {
            for (SecurityFunctionExtendPo sf : sfList) {
                result.add(this.getDoByPo(sf));
            }
        }
        return result;
    }

    @Override
    public List<com.yaoming.module.security.domain.SecurityFunction> getRoleFunctions(String roleName) {
        return this.getDoByPo(this.functionDao.selectByRoleName(roleName));
    }

    @Override
    public com.yaoming.module.security.domain.SecurityFunction getFunctionById(long id) {
        return this.getDoByPo(this.functionDao.selectByPrimaryKey(id));
    }
}

