/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.dao.repositoryimpl;

import com.yaoming.module.security.dao.SecurityFunctionResourcePatternExtendMapper;
import com.yaoming.module.security.dao.SecurityRoleExtendMapper;
import com.yaoming.module.security.dao.SecurityRoleFunctionExtendMapper;
import com.yaoming.module.security.dao.SecurityRoleUserExtendMapper;
import com.yaoming.module.security.dao.base.po.SecurityFunctionResourcePattern;
import com.yaoming.module.security.dao.base.po.SecurityRole;
import com.yaoming.module.security.dao.base.po.SecurityRoleFunction;
import com.yaoming.module.security.domain.impl.DefaultSecurityRole;
import com.yaoming.module.security.domain.repository.RoleRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RoleRepositoryImpl
implements RoleRepository {
    @Autowired
    private SecurityFunctionResourcePatternExtendMapper functionResourceDao;
    @Autowired
    private SecurityRoleFunctionExtendMapper roleFunctionDao;
    @Autowired
    private SecurityRoleExtendMapper roleDao;
    @Autowired
    private SecurityRoleUserExtendMapper roleUserDao;

    @Override
    public List<com.yaoming.module.security.domain.SecurityRole> getRoleList() {
        ArrayList<com.yaoming.module.security.domain.SecurityRole> result = new ArrayList<com.yaoming.module.security.domain.SecurityRole>();
        List<SecurityRole> patterns = this.roleDao.selectAll();
        for (SecurityRole pattern : patterns) {
            result.add(new DefaultSecurityRole(pattern.getId(), pattern.getName(), pattern.getNote()));
        }
        return result;
    }

    @Override
    public Map<Long, List<com.yaoming.module.security.domain.SecurityRole>> getAllResourceRoles() {
        HashMap<Long, List<com.yaoming.module.security.domain.SecurityRole>> result = new HashMap<Long, List<com.yaoming.module.security.domain.SecurityRole>>();
        List<com.yaoming.module.security.domain.SecurityRole> roleList = this.getRoleList();
        List<SecurityRoleFunction> roleFunctionList = this.roleFunctionDao.selectAll();
        List<SecurityFunctionResourcePattern> resourceList = this.functionResourceDao.selectAllFunctionResources();
        for (SecurityFunctionResourcePattern resource : resourceList) {
            ArrayList<com.yaoming.module.security.domain.SecurityRole> list = new ArrayList<com.yaoming.module.security.domain.SecurityRole>();
            for (SecurityRoleFunction roleFunction : roleFunctionList) {
                if (roleFunction.getFunctionId().longValue() != resource.getFunctionId().longValue()) continue;
                for (com.yaoming.module.security.domain.SecurityRole role : roleList) {
                    if (role.getId() != roleFunction.getRoleId().longValue()) continue;
                    list.add(role);
                }
            }
            result.put(resource.getId(), list);
        }
        return result;
    }

    @Override
    public List<com.yaoming.module.security.domain.SecurityRole> getRolesByResourceId(long resourceId) {
        ArrayList<com.yaoming.module.security.domain.SecurityRole> result = new ArrayList<com.yaoming.module.security.domain.SecurityRole>();
        List<SecurityRole> patterns = this.roleDao.selectByResourceId(resourceId);
        for (SecurityRole pattern : patterns) {
            result.add(new DefaultSecurityRole(pattern.getId(), pattern.getName(), pattern.getNote()));
        }
        return result;
    }

    @Override
    public List<com.yaoming.module.security.domain.SecurityRole> getRolesByUserId(long userId) {
        ArrayList<com.yaoming.module.security.domain.SecurityRole> result = new ArrayList<com.yaoming.module.security.domain.SecurityRole>();
        List<SecurityRole> patterns = this.roleDao.selectByUserId(userId);
        for (SecurityRole pattern : patterns) {
            result.add(new DefaultSecurityRole(pattern.getId(), pattern.getName(), pattern.getNote()));
        }
        return result;
    }

    @Override
    public void save(com.yaoming.module.security.domain.SecurityRole securityRole) {
        this.roleDao.replace(this.getPoByDomain(securityRole));
    }

    @Override
    public void delete(long id) {
        this.roleDao.deleteByPrimaryKey(id);
    }

    @Override
    public List<Long> getRoleFunctions(long roleId) {
        List<SecurityRoleFunction> list = this.roleFunctionDao.selectByRoleId(roleId);
        ArrayList<Long> result = new ArrayList<Long>();
        for (SecurityRoleFunction rf : list) {
            if (rf == null) continue;
            result.add(rf.getFunctionId());
        }
        return result;
    }

    @Override
    public void deleteAllRoleFunctions(long roleId) {
        this.roleFunctionDao.deleteAllRelation(roleId);
    }

    @Override
    public void saveRoleFunction(long roleId, long functionId) {
        this.roleFunctionDao.saveRelation(roleId, functionId);
    }

    @Override
    public void deleteRoleFunction(long roleId, long functionId) {
        this.roleFunctionDao.deleteRelation(roleId, functionId);
    }

    @Override
    public void saveRoleUser(long roleId, long userId) {
        this.roleUserDao.saveRelation(roleId, userId);
    }

    @Override
    public void deleteRoleUser(long roleId, long userId) {
        this.roleUserDao.deleteRelation(roleId, userId);
    }

    @Override
    public void deleteAllUserRoles(long userId) {
        this.roleUserDao.deleteAllRelations(userId);
    }

    @Override
    public void deleteAllRoleUserRelations(long roleId) {
        this.roleUserDao.deleteAllRoleRelations(roleId);
    }

    private SecurityRole getPoByDomain(com.yaoming.module.security.domain.SecurityRole domain) {
        SecurityRole po = new SecurityRole();
        po.setId(domain.getId());
        po.setName(domain.getName());
        po.setNote(domain.getNote());
        return po;
    }
}

