/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.dao.repositoryimpl;

import com.yaoming.module.security.dao.SecurityFunctionExtendMapper;
import com.yaoming.module.security.dao.SecurityFunctionResourcePatternExtendMapper;
import com.yaoming.module.security.dao.base.po.SecurityFunction;
import com.yaoming.module.security.dao.base.po.SecurityFunctionResourcePattern;
import com.yaoming.module.security.dao.po.SecurityFunctionExtendPo;
import com.yaoming.module.security.domain.TreeNode;
import com.yaoming.module.security.domain.repository.TreeNodeRepository;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public class TreeNodeRepositoryImpl
implements TreeNodeRepository {
    @Autowired
    private SecurityFunctionResourcePatternExtendMapper functionResourceDao;
    @Autowired
    private SecurityFunctionExtendMapper functionDao;

    @Override
    public List<TreeNode.FunctionNode> getFunctionNodeList(long functionId) {
        List<SecurityFunctionExtendPo> list = this.functionDao.selectByParentId(functionId);
        ArrayList<TreeNode.FunctionNode> result = new ArrayList<TreeNode.FunctionNode>();
        for (SecurityFunction securityFunction : list) {
            result.add(this.getDomainByPo(securityFunction));
        }
        return result;
    }

    @Override
    public List<TreeNode.FunctionLeaf> getFunctionLeafList(long functionId) {
        List<SecurityFunctionResourcePattern> list = this.functionResourceDao.selectByFunctionId(functionId);
        ArrayList<TreeNode.FunctionLeaf> result = new ArrayList<TreeNode.FunctionLeaf>();
        for (SecurityFunctionResourcePattern sf : list) {
            result.add(this.getDomainByPo(sf));
        }
        return result;
    }

    @Override
    public void saveFunctionNode(long oldId, TreeNode.FunctionNode node) {
        Assert.state((node.getId() > 0L ? 1 : 0) != 0, (String)"\u529f\u80fdID\u5fc5\u987b\u5927\u4e8e0\u3002");
        if (oldId <= 0L) {
            this.functionDao.replace(this.getPoByDomain(node));
        } else {
            this.functionDao.updateByOldId(node.getId(), oldId, node.getParentId(), node.getName(), node.getNote());
        }
    }

    @Override
    public void deleteFunctionNode(long id) {
        this.functionDao.deleteByPrimaryKey(id);
    }

    @Override
    public void saveFunctionLeaf(long oldId, TreeNode.FunctionLeaf leaf) {
        Assert.state((leaf.getId() > 0L ? 1 : 0) != 0, (String)"\u8d44\u6e90ID\u5fc5\u987b\u5927\u4e8e0\u3002");
        if (oldId <= 0L) {
            this.functionResourceDao.replace(this.getPoByDomain(leaf));
        } else {
            this.functionResourceDao.updateByOldId(leaf.getId(), oldId, leaf.getFunctionId(), leaf.getPattern(), leaf.getNote());
        }
    }

    @Override
    public void deleteFunctionLeaf(long id) {
        this.functionResourceDao.deleteByPrimaryKey(id);
    }

    private TreeNode.FunctionNode getDomainByPo(SecurityFunction po) {
        return new TreeNode.FunctionNode(po.getId(), po.getParentId(), po.getName(), po.getName());
    }

    private TreeNode.FunctionLeaf getDomainByPo(SecurityFunctionResourcePattern po) {
        return new TreeNode.FunctionLeaf(po.getId(), po.getFunctionId(), po.getPattern(), po.getNote());
    }

    private SecurityFunction getPoByDomain(TreeNode.FunctionNode domain) {
        SecurityFunction po = new SecurityFunction();
        po.setId(domain.getId());
        po.setName(domain.getName());
        po.setParentId(domain.getParentId());
        po.setNote(domain.getNote());
        return po;
    }

    private SecurityFunctionResourcePattern getPoByDomain(TreeNode.FunctionLeaf domain) {
        SecurityFunctionResourcePattern po = new SecurityFunctionResourcePattern();
        po.setId(domain.getId());
        po.setFunctionId(domain.getFunctionId());
        po.setPattern(domain.getPattern());
        po.setNote(domain.getNote());
        return po;
    }
}

