/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.domain;

import com.yaoming.module.security.domain.impl.DefaultSecurityRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.GrantedAuthority;

public interface SecurityRole
extends GrantedAuthority,
ConfigAttribute {
    public static final Logger logger = LoggerFactory.getLogger(SecurityRole.class);
    public static final String PERMIT_ALL = "permitAll";
    public static final String DENY_ALL = "denyAll";
    public static final DefaultSecurityRole ROLE_PERMITALL = new DefaultSecurityRole("permitAll");
    public static final DefaultSecurityRole ROLE_DENYALL = new DefaultSecurityRole("denyAll");

    public long getId();

    public String getName();

    public String getNote();

    default public String getAuthority() {
        return this.getName();
    }

    default public String getAttribute() {
        return this.getName();
    }

    public static DefaultSecurityRole getRole(String authority) {
        switch (authority) {
            case "permitAll": {
                return ROLE_PERMITALL;
            }
            case "denyAll": {
                return ROLE_DENYALL;
            }
        }
        logger.debug("\u672a\u5b9a\u4e49\u5168\u5c40\u6743\u9650 {}", (Object)authority);
        return null;
    }
}

