/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.domain.impl;

import com.yaoming.module.security.domain.SecurityFunction;
import com.yaoming.module.security.domain.SecurityFunctionTree;
import com.yaoming.module.security.domain.SecurityLoader;
import com.yaoming.module.security.domain.SecurityResource;
import com.yaoming.module.security.domain.SecurityRole;
import com.yaoming.module.security.domain.impl.DefaultSecurityFunctionTree;
import com.yaoming.module.security.domain.repository.DefaultSecurityLoaderRepository;
import com.yaoming.module.security.domain.repository.RoleRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="securityLoader")
public class DefaultSecurityLoader
implements SecurityLoader {
    @Autowired
    private DefaultSecurityLoaderRepository defaultSecurityLoaderRepository;
    @Autowired
    private RoleRepository roleRepository;
    private boolean cacheEnabled = true;
    private List<SecurityResource> globalResourceList;
    private List<SecurityResource> functionResourceList;
    private List<SecurityFunction> functionList;
    private Map<String, List<SecurityFunction>> roleFunctionMap = new HashMap<String, List<SecurityFunction>>();
    private Map<Long, List<SecurityRole>> resourceRoleMap;
    private ReadWriteLock functionResourceListLock = new ReentrantReadWriteLock();
    private ReadWriteLock globalResourceListLock = new ReentrantReadWriteLock();
    private ReadWriteLock resourceRoleMapLock = new ReentrantReadWriteLock();
    private ReadWriteLock roleFunctionMapLock = new ReentrantReadWriteLock();
    private ReadWriteLock functionListLock = new ReentrantReadWriteLock();

    @Override
    public List<SecurityResource> getAllGlobalResources() {
        if (!this.cacheEnabled) {
            return this.defaultSecurityLoaderRepository.getAllGlobalResources();
        }
        if (this.globalResourceList == null) {
            try {
                this.globalResourceListLock.writeLock().lock();
                if (this.globalResourceList == null) {
                    this.globalResourceList = this.defaultSecurityLoaderRepository.getAllGlobalResources();
                }
            }
            finally {
                this.globalResourceListLock.writeLock().unlock();
            }
        }
        return this.globalResourceList;
    }

    @Override
    public List<SecurityResource> getAllFunctionResources() {
        if (!this.cacheEnabled) {
            return this.defaultSecurityLoaderRepository.getAllFunctionResources();
        }
        if (this.functionResourceList == null) {
            try {
                this.functionResourceListLock.writeLock().lock();
                if (this.functionResourceList == null) {
                    this.functionResourceList = this.defaultSecurityLoaderRepository.getAllFunctionResources();
                }
            }
            finally {
                this.functionResourceListLock.writeLock().unlock();
            }
        }
        return this.functionResourceList;
    }

    @Override
    public List<SecurityFunction> getAllFunctions() {
        if (!this.cacheEnabled) {
            return this.defaultSecurityLoaderRepository.getAllFunctions();
        }
        if (this.functionList == null) {
            try {
                this.functionListLock.writeLock().lock();
                if (this.functionList == null) {
                    this.functionList = this.defaultSecurityLoaderRepository.getAllFunctions();
                }
            }
            finally {
                this.functionListLock.writeLock().unlock();
            }
        }
        return this.functionList;
    }

    @Override
    public List<SecurityRole> getRolesByResourceId(long resourceId) {
        if (!this.cacheEnabled) {
            return this.roleRepository.getRolesByResourceId(resourceId);
        }
        this.checkAndLoadResourceRoleMap();
        if (this.resourceRoleMap.containsKey(resourceId)) {
            return this.resourceRoleMap.get(resourceId);
        }
        return new ArrayList<SecurityRole>();
    }

    @Override
    public Set<SecurityRole> getAllRoles() {
        if (!this.cacheEnabled) {
            HashSet<SecurityRole> result = new HashSet<SecurityRole>();
            result.addAll(this.roleRepository.getRoleList());
            return result;
        }
        this.checkAndLoadResourceRoleMap();
        HashSet<SecurityRole> result = new HashSet<SecurityRole>();
        for (List<SecurityRole> list : this.resourceRoleMap.values()) {
            result.addAll(list);
        }
        return result;
    }

    private void checkAndLoadResourceRoleMap() {
        if (this.resourceRoleMap == null) {
            try {
                this.resourceRoleMapLock.writeLock().lock();
                if (this.resourceRoleMap == null) {
                    this.resourceRoleMap = this.roleRepository.getAllResourceRoles();
                }
            }
            finally {
                this.resourceRoleMapLock.writeLock().unlock();
            }
        }
    }

    @Override
    public void globalResourceChange() {
        try {
            this.globalResourceListLock.writeLock().lock();
            this.globalResourceList = null;
        }
        finally {
            this.globalResourceListLock.writeLock().unlock();
        }
    }

    @Override
    public void functionResourceChange() {
        try {
            this.functionListLock.writeLock().lock();
            this.functionResourceListLock.writeLock().lock();
            this.resourceRoleMapLock.writeLock().lock();
            this.functionList = null;
            this.functionResourceList = null;
            this.resourceRoleMap = null;
        }
        finally {
            this.functionListLock.writeLock().unlock();
            this.functionResourceListLock.writeLock().unlock();
            this.resourceRoleMapLock.writeLock().unlock();
        }
    }

    @Override
    public void roleChange() {
        try {
            this.resourceRoleMapLock.writeLock().lock();
            this.resourceRoleMap = null;
        }
        finally {
            this.resourceRoleMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SecurityFunction> getFunctionsByParentId(long parentId) {
        if (!this.cacheEnabled) {
            return this.defaultSecurityLoaderRepository.getFunctionsByParent(parentId);
        }
        ArrayList<SecurityFunction> result = new ArrayList<SecurityFunction>();
        try {
            this.functionListLock.readLock().lock();
            for (SecurityFunction sf : this.getAllFunctions()) {
                if (sf.getParentId() != parentId) continue;
                result.add(sf);
            }
        }
        finally {
            this.functionListLock.readLock().unlock();
        }
        return result;
    }

    @Override
    public List<SecurityFunctionTree> getRoleFunctions(String ... roleNames) {
        ArrayList<SecurityFunctionTree> result = new ArrayList<SecurityFunctionTree>();
        for (String roleName : roleNames) {
            for (SecurityFunction sf : this.getRoleFunctionList(roleName)) {
                this.treeAddFunctionList(result, this.getFunctionListWithParents(sf));
            }
        }
        return result;
    }

    private void treeAddFunctionList(List<SecurityFunctionTree> tree, List<SecurityFunction> list) {
        for (SecurityFunction function : list) {
            boolean flag = false;
            for (SecurityFunctionTree functionTreeNode : tree) {
                if (function.getId() != functionTreeNode.getId()) continue;
                flag = true;
                tree = functionTreeNode.getChildren();
                break;
            }
            if (flag) continue;
            DefaultSecurityFunctionTree functionTreeNode = new DefaultSecurityFunctionTree(function);
            tree.add(functionTreeNode);
            Collections.sort(tree);
            tree = functionTreeNode.getChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SecurityFunction> getRoleFunctionList(String roleName) {
        if (!this.cacheEnabled) {
            return this.defaultSecurityLoaderRepository.getRoleFunctions(roleName);
        }
        try {
            this.roleFunctionMapLock.readLock().lock();
            if (this.roleFunctionMap.containsKey(roleName)) {
                List<SecurityFunction> list = this.roleFunctionMap.get(roleName);
                return list;
            }
        }
        finally {
            this.roleFunctionMapLock.readLock().unlock();
        }
        List<SecurityFunction> list = this.defaultSecurityLoaderRepository.getRoleFunctions(roleName);
        if (list == null) {
            return new ArrayList<SecurityFunction>();
        }
        try {
            this.roleFunctionMapLock.writeLock().lock();
            this.roleFunctionMap.put(roleName, list);
            List<SecurityFunction> list2 = list;
            return list2;
        }
        finally {
            this.roleFunctionMapLock.writeLock().unlock();
        }
    }

    private List<SecurityFunction> getFunctionListWithParents(SecurityFunction sf) {
        ArrayList<SecurityFunction> list = new ArrayList<SecurityFunction>();
        if (sf == null) {
            return list;
        }
        list.add(sf);
        while (sf != null && sf.getParentId() != 0L) {
            if ((sf = this.getFunctionById(sf.getParentId())) == null) continue;
            list.add(0, sf);
        }
        return list;
    }

    private SecurityFunction getFunctionById(long id) {
        if (!this.cacheEnabled) {
            return this.defaultSecurityLoaderRepository.getFunctionById(id);
        }
        for (SecurityFunction function : this.getAllFunctions()) {
            if (function == null || function.getId() != id) continue;
            return function;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        try {
            this.globalResourceListLock.writeLock().lock();
            this.globalResourceList = this.defaultSecurityLoaderRepository.getAllGlobalResources();
        }
        finally {
            this.globalResourceListLock.writeLock().unlock();
        }
        try {
            this.functionListLock.writeLock().lock();
            this.functionList = this.defaultSecurityLoaderRepository.getAllFunctions();
        }
        finally {
            this.functionListLock.writeLock().unlock();
        }
        try {
            this.functionResourceListLock.writeLock().lock();
            this.functionResourceList = this.defaultSecurityLoaderRepository.getAllFunctionResources();
        }
        finally {
            this.functionResourceListLock.writeLock().unlock();
        }
        try {
            this.resourceRoleMapLock.writeLock().lock();
            this.resourceRoleMap = this.roleRepository.getAllResourceRoles();
        }
        finally {
            this.resourceRoleMapLock.writeLock().unlock();
        }
        try {
            this.roleFunctionMapLock.writeLock().lock();
            this.roleFunctionMap = new HashMap<String, List<SecurityFunction>>();
        }
        finally {
            this.roleFunctionMapLock.writeLock().unlock();
        }
    }
}

