/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.service.impl;

import java.util.Collection;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class AccessDecisionManagerImpl
implements AccessDecisionManager {
    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) throws AccessDeniedException, InsufficientAuthenticationException {
        if (attributes != null) {
            for (ConfigAttribute attribute : attributes) {
                String authority;
                if (attribute == null || (authority = attribute.getAttribute()) == null) continue;
                if (this.checkGlobalAuthorities(authority)) {
                    return;
                }
                for (GrantedAuthority grantedAuthority : authentication.getAuthorities()) {
                    if (!authority.equals(grantedAuthority.getAuthority())) continue;
                    return;
                }
            }
        }
        throw new AccessDeniedException("\u6743\u9650\u4e0d\u8db3!");
    }

    private boolean checkGlobalAuthorities(String security) {
        if (security == null) {
            return false;
        }
        switch (security) {
            case "permitAll": {
                return true;
            }
        }
        return false;
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

