/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.service.impl;

import com.yaoming.common.util.StringUtil;
import com.yaoming.module.security.domain.SecurityFunctionTree;
import com.yaoming.module.security.domain.SecurityLoader;
import com.yaoming.module.security.domain.repository.SecuritySqlExecuteRepository;
import com.yaoming.module.security.service.SecurityFunctionService;
import com.yaoming.module.security.service.vo.SecurityTreeNodeVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="defaultFunctionService")
public class DefaultSecurityFunctionServiceImpl
implements SecurityFunctionService {
    private String userTableName;
    private String useridFieldName;
    private String usernameFieldName;
    private String userFunctionAuthoritySql;
    @Autowired
    private SecuritySqlExecuteRepository sqlExecuteRepository;
    @Autowired
    private SecurityLoader securityLoader;

    @Override
    public boolean isUserHasFunctionAuthority(String username, String functionname) {
        String sql = this.getUserFunctionAuthoritySql().replace("#{functionname}", functionname.replaceAll("\\s+", "").replace(",", "','"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("username", username);
        return this.sqlExecuteRepository.execueteSqlResultInt(sql, params) > 0;
    }

    @Override
    public String getUserTableName() {
        if (StringUtil.isEmpty((String)this.userTableName)) {
            this.userTableName = "user";
        }
        return this.userTableName;
    }

    public void setUserTableName(String userTableName) {
        this.userTableName = userTableName;
    }

    @Override
    public String getUseridFieldName() {
        if (StringUtil.isEmpty((String)this.useridFieldName)) {
            this.useridFieldName = "id";
        }
        return this.useridFieldName;
    }

    public void setUseridFieldName(String useridFieldName) {
        this.useridFieldName = useridFieldName;
    }

    @Override
    public String getUsernameFieldName() {
        if (StringUtil.isEmpty((String)this.usernameFieldName)) {
            this.usernameFieldName = "username";
        }
        return this.usernameFieldName;
    }

    public void setUsernameFieldName(String usernameFieldName) {
        this.usernameFieldName = usernameFieldName;
    }

    @Override
    public String getUserFunctionAuthoritySql() {
        if (StringUtil.isEmpty((String)this.userFunctionAuthoritySql)) {
            this.userFunctionAuthoritySql = this.getDefaultUserFunctionAuthoritySql();
        }
        return this.userFunctionAuthoritySql;
    }

    public void setUserFunctionAuthoritySql(String userFunctionAuthoritySql) {
        this.userFunctionAuthoritySql = userFunctionAuthoritySql;
    }

    @Override
    public List<SecurityTreeNodeVO.SecurityFunctionTreeNodeVO> getRoleFunctions(String ... roleNames) {
        ArrayList<SecurityTreeNodeVO.SecurityFunctionTreeNodeVO> result = new ArrayList<SecurityTreeNodeVO.SecurityFunctionTreeNodeVO>();
        List<SecurityFunctionTree> doList = this.securityLoader.getRoleFunctions(roleNames);
        for (SecurityFunctionTree tree : doList) {
            result.add(SecurityTreeNodeVO.SecurityFunctionTreeNodeVO.create(tree));
        }
        return result;
    }
}

