/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.service.impl;

import com.yaoming.common.util.IdGenerator;
import com.yaoming.module.security.domain.SecurityFunction;
import com.yaoming.module.security.domain.SecurityLoader;
import com.yaoming.module.security.domain.SecurityResource;
import com.yaoming.module.security.domain.SecurityRole;
import com.yaoming.module.security.domain.TreeNode;
import com.yaoming.module.security.domain.impl.DefaultSecurityResource;
import com.yaoming.module.security.domain.impl.DefaultSecurityRole;
import com.yaoming.module.security.domain.repository.GlobalResourcePatternRepository;
import com.yaoming.module.security.domain.repository.RoleRepository;
import com.yaoming.module.security.domain.repository.TreeNodeRepository;
import com.yaoming.module.security.service.SecurityEditService;
import com.yaoming.module.security.service.vo.SecurityGlobalResourcePatternVO;
import com.yaoming.module.security.service.vo.SecurityRoleVO;
import com.yaoming.module.security.service.vo.SecurityTreeNodeVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SecurityEditServiceImpl
implements SecurityEditService {
    @Autowired
    private GlobalResourcePatternRepository globalResourcePatternRepository;
    @Autowired
    private TreeNodeRepository treeNodeRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private SecurityLoader securityLoader;

    @Override
    public List<SecurityGlobalResourcePatternVO> getGlobalResourcePatterns() {
        List<SecurityResource> list = this.securityLoader.getAllGlobalResources();
        ArrayList<SecurityGlobalResourcePatternVO> result = new ArrayList<SecurityGlobalResourcePatternVO>();
        for (SecurityResource securityResource : list) {
            result.add(new SecurityGlobalResourcePatternVO(securityResource));
        }
        return result;
    }

    @Override
    public long saveGlobalResourcePattern(long id, long idOld, String pattern, String authority, String note) {
        this.globalResourcePatternRepository.save(idOld, new DefaultSecurityResource(id, pattern, note, authority));
        this.securityLoader.reload();
        return id;
    }

    @Override
    public boolean deleteGlobalResourcePattern(long id) {
        this.globalResourcePatternRepository.delete(id);
        this.securityLoader.reload();
        return true;
    }

    @Override
    public Map<String, List<? extends SecurityTreeNodeVO>> getTreeNode(long functionId) {
        HashMap<String, List<? extends SecurityTreeNodeVO>> result = new HashMap<String, List<? extends SecurityTreeNodeVO>>();
        List<TreeNode.FunctionNode> functionNodeList = this.getFunctionNodeList(functionId);
        ArrayList<SecurityTreeNodeVO.SecurityFunctionTreeNodeVO> nodeList = new ArrayList<SecurityTreeNodeVO.SecurityFunctionTreeNodeVO>();
        for (TreeNode.FunctionNode fn : functionNodeList) {
            nodeList.add(new SecurityTreeNodeVO.SecurityFunctionTreeNodeVO(fn));
        }
        result.put("nodeList", nodeList);
        List<TreeNode.FunctionLeaf> functionLeafList = this.treeNodeRepository.getFunctionLeafList(functionId);
        ArrayList<SecurityTreeNodeVO.SecurityResourcePatternLeafVO> leafList = new ArrayList<SecurityTreeNodeVO.SecurityResourcePatternLeafVO>();
        for (TreeNode.FunctionLeaf fl : functionLeafList) {
            leafList.add(new SecurityTreeNodeVO.SecurityResourcePatternLeafVO(fl));
        }
        result.put("leafList", leafList);
        return result;
    }

    @Override
    public List<SecurityTreeNodeVO.SecurityFunctionTreeNodeVO> getTree() {
        return this.getTree(null);
    }

    private List<SecurityTreeNodeVO.SecurityFunctionTreeNodeVO> getTree(SecurityTreeNodeVO.SecurityFunctionTreeNodeVO parent) {
        ArrayList<SecurityTreeNodeVO.SecurityFunctionTreeNodeVO> result = new ArrayList<SecurityTreeNodeVO.SecurityFunctionTreeNodeVO>();
        List<TreeNode.FunctionNode> functionNodeList = this.getFunctionNodeList(parent == null ? 0L : parent.getId());
        for (TreeNode.FunctionNode fn : functionNodeList) {
            SecurityTreeNodeVO.SecurityFunctionTreeNodeVO functionVo = new SecurityTreeNodeVO.SecurityFunctionTreeNodeVO(fn);
            result.add(functionVo);
            functionVo.addAllChildren(this.getTree(functionVo));
        }
        return result;
    }

    private List<TreeNode.FunctionNode> getFunctionNodeList(long parentId) {
        ArrayList<TreeNode.FunctionNode> result = new ArrayList<TreeNode.FunctionNode>();
        List<SecurityFunction> sfList = this.securityLoader.getFunctionsByParentId(parentId);
        if (sfList != null) {
            for (SecurityFunction sf : sfList) {
                result.add(new TreeNode.FunctionNode(sf.getId(), parentId, sf.getName(), sf.getNote()));
            }
        }
        return result;
    }

    @Override
    public long saveFunctionNode(long id, long idOld, long parentId, String name, String note) {
        this.treeNodeRepository.saveFunctionNode(idOld, new TreeNode.FunctionNode(id, parentId, name, note));
        this.securityLoader.reload();
        return id;
    }

    @Override
    public boolean deleteFunctionNode(long id) {
        this.treeNodeRepository.deleteFunctionNode(id);
        this.securityLoader.reload();
        return true;
    }

    @Override
    public long saveFunctionLeaf(long id, long idOld, long functionId, String pattern, String note) {
        this.treeNodeRepository.saveFunctionLeaf(idOld, new TreeNode.FunctionLeaf(id, functionId, pattern, note));
        this.securityLoader.reload();
        return id;
    }

    @Override
    public boolean deleteFunctionLeaf(long id) {
        this.treeNodeRepository.deleteFunctionLeaf(id);
        this.securityLoader.reload();
        return true;
    }

    @Override
    public List<SecurityRoleVO> getRoleList() {
        List<SecurityRole> list = this.roleRepository.getRoleList();
        ArrayList<SecurityRoleVO> result = new ArrayList<SecurityRoleVO>();
        for (SecurityRole sr : list) {
            result.add(new SecurityRoleVO(sr));
        }
        return result;
    }

    @Override
    public long saveRole(long id, String name, String note) {
        if (id <= 0L) {
            id = IdGenerator.getDefault().nextId();
        }
        this.roleRepository.save(new DefaultSecurityRole(id, name, note));
        this.securityLoader.reload();
        return id;
    }

    @Override
    public boolean deleteRole(long id) {
        this.roleRepository.deleteAllRoleFunctions(id);
        this.roleRepository.deleteAllRoleUserRelations(id);
        this.roleRepository.delete(id);
        this.securityLoader.reload();
        return true;
    }

    @Override
    public List<Long> getSelectedFunctions(long roleId) {
        return this.roleRepository.getRoleFunctions(roleId);
    }

    @Override
    public boolean roleFuncSave(long roleId, long[] functionIds) {
        this.roleRepository.deleteAllRoleFunctions(roleId);
        return this.addRoleFunctions(roleId, functionIds);
    }

    @Override
    public boolean addRoleFunctions(long roleId, long[] functionIds) {
        if (functionIds != null) {
            for (long functionId : functionIds) {
                this.roleRepository.saveRoleFunction(roleId, functionId);
            }
        }
        this.securityLoader.reload();
        return true;
    }

    @Override
    public boolean deleteRoleFunctions(long roleId, long[] functionIds) {
        if (functionIds != null) {
            for (long functionId : functionIds) {
                this.roleRepository.deleteRoleFunction(roleId, functionId);
            }
        }
        this.securityLoader.reload();
        return true;
    }

    @Override
    public List<SecurityRoleVO> getUserRoleList(long userId) {
        List<SecurityRole> list = this.roleRepository.getRolesByUserId(userId);
        ArrayList<SecurityRoleVO> result = new ArrayList<SecurityRoleVO>();
        for (SecurityRole sr : list) {
            result.add(new SecurityRoleVO(sr));
        }
        return result;
    }

    @Override
    public boolean addUserRoles(long userId, long[] roleIds) {
        if (roleIds != null) {
            for (long roleId : roleIds) {
                this.roleRepository.saveRoleUser(roleId, userId);
            }
        }
        this.securityLoader.reload();
        return true;
    }

    @Override
    public boolean deleteUserRoles(long userId, long[] roleIds) {
        if (roleIds != null) {
            for (long roleId : roleIds) {
                this.roleRepository.deleteRoleUser(roleId, userId);
            }
        }
        this.securityLoader.reload();
        return true;
    }

    @Override
    public boolean saveUserRoles(long userId, long[] roleIds) {
        this.deleteAllUserRoles(userId);
        return this.addUserRoles(userId, roleIds);
    }

    @Override
    public void deleteAllUserRoles(long userId) {
        this.roleRepository.deleteAllUserRoles(userId);
        this.securityLoader.reload();
    }
}

