/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.service.impl;

import com.yaoming.module.security.domain.SecurityResource;
import com.yaoming.module.security.domain.SecurityRole;
import com.yaoming.module.security.domain.impl.DefaultSecurityRole;
import com.yaoming.module.security.service.SecurityResourceService;
import com.yaoming.module.security.service.SecurityRoleService;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configurable
public class SecurityMetadataSourceImpl
implements FilterInvocationSecurityMetadataSource {
    @Autowired
    private SecurityRoleService roleService;
    @Autowired
    private SecurityResourceService resourceService;
    private String matcher;

    public void setMatcher(String matcher) {
        this.matcher = matcher;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        HashSet<ConfigAttribute> result = new HashSet<ConfigAttribute>();
        result.addAll(this.roleService.getAllRoles());
        return result;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        HttpServletRequest request = ((FilterInvocation)object).getRequest();
        boolean flag = false;
        HashSet<ConfigAttribute> result = new HashSet<ConfigAttribute>();
        for (SecurityResource securityResource : this.resourceService.getAllFunctionResources()) {
            if (!this.getRequestMatcher(request, securityResource.getPattern()).matches(request)) continue;
            result.addAll(this.roleService.getByResourceId(securityResource.getId()));
            flag = true;
        }
        if (flag && result.isEmpty()) {
            result.add(SecurityRole.ROLE_DENYALL);
            return result;
        }
        for (SecurityResource securityResource : this.resourceService.getAllGlobalResources()) {
            if (!this.getRequestMatcher(request, securityResource.getPattern()).matches(request)) continue;
            DefaultSecurityRole role = SecurityRole.getRole(securityResource.getAuthority());
            if (role == null) {
                result.add(SecurityRole.ROLE_DENYALL);
            } else {
                result.add(role);
            }
            return result;
        }
        result.add(SecurityRole.ROLE_DENYALL);
        return result;
    }

    private RequestMatcher getRequestMatcher(HttpServletRequest request, String uri) {
        AntPathRequestMatcher requestMatcher = null;
        if (this.matcher.toLowerCase().equals("ant")) {
            requestMatcher = new AntPathRequestMatcher(uri);
        }
        if (this.matcher.toLowerCase().equals("regex")) {
            requestMatcher = new RegexRequestMatcher(uri, request.getMethod(), true);
        }
        return requestMatcher;
    }
}

