/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.service.tag;

import com.yaoming.module.security.service.SecurityFunctionService;
import javax.servlet.jsp.tagext.TagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@Configurable
public class SecurityTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private static final String USERNAME = "name";
    @Autowired
    private SecurityFunctionService functionService;
    private Logger logger = LoggerFactory.getLogger(SecurityTag.class);
    private String name;

    public int doStartTag() {
        try {
            String username = this.getUsername();
            if (username == null) {
                this.logger.debug("\u672a\u627e\u5230\u767b\u5f55\u7528\u6237");
                return this.getDefaultBodyAttr();
            }
            if (this.functionService.isUserHasFunctionAuthority(username, this.name)) {
                return 6;
            }
            return 0;
        }
        catch (Exception e) {
            this.logger.debug("\u6743\u9650\u6807\u7b7e\u51fa\u9519", (Throwable)e);
            return this.getDefaultBodyAttr();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getDefaultBodyAttr() {
        switch (this.functionService.getDefaultBodyAttr()) {
            case "SKIP_BODY": {
                return 0;
            }
            case "EVAL_PAGE": {
                return 6;
            }
        }
        return 0;
    }

    private String getUsername() {
        if (SecurityContextHolder.getContext() == null || !(SecurityContextHolder.getContext() instanceof SecurityContext) || SecurityContextHolder.getContext().getAuthentication() == null) {
            return null;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth.getPrincipal() == null) {
            return null;
        }
        try {
            BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)auth);
            return String.valueOf(wrapper.getPropertyValue(USERNAME));
        }
        catch (BeansException e) {
            return null;
        }
    }
}

