/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.module.security.service.vo;

import com.yaoming.module.security.domain.SecurityFunctionTree;
import com.yaoming.module.security.domain.TreeNode;
import java.util.ArrayList;
import java.util.List;

public abstract class SecurityTreeNodeVO {
    private long id;
    private String note;

    public SecurityTreeNodeVO() {
    }

    public SecurityTreeNodeVO(long id, String note) {
        this.id = id;
        this.note = note;
    }

    public long getId() {
        return this.id;
    }

    public String getNote() {
        return this.note;
    }

    public static class SecurityResourcePatternLeafVO
    extends SecurityTreeNodeVO {
        private long functionId;
        private String pattern;

        public SecurityResourcePatternLeafVO(TreeNode.FunctionLeaf functionLeaf) {
            this(functionLeaf.getId(), functionLeaf.getFunctionId(), functionLeaf.getPattern(), functionLeaf.getNote());
        }

        public SecurityResourcePatternLeafVO(long id, long functionId, String pattern, String note) {
            super(id, note);
            this.functionId = functionId;
            this.pattern = pattern;
        }

        public long getFunctionId() {
            return this.functionId;
        }

        public String getPattern() {
            return this.pattern;
        }
    }

    public static class SecurityFunctionTreeNodeVO
    extends SecurityTreeNodeVO {
        private long parentId;
        private String name;
        private String url;
        private int index;
        private List<Long> roleIds;
        private List<SecurityFunctionTreeNodeVO> children;

        public SecurityFunctionTreeNodeVO(TreeNode.FunctionNode functionNode) {
            this(functionNode.getId(), functionNode.getParentId(), functionNode.getName(), functionNode.getNote());
            this.children = new ArrayList<SecurityFunctionTreeNodeVO>();
        }

        public SecurityFunctionTreeNodeVO(long id, long parentId, String name, String note) {
            super(id, note);
            this.parentId = parentId;
            this.name = name;
        }

        public static SecurityFunctionTreeNodeVO create(SecurityFunctionTree tree) {
            if (tree == null) {
                return null;
            }
            SecurityFunctionTreeNodeVO vo = new SecurityFunctionTreeNodeVO(tree.getId(), tree.getParentId(), tree.getName(), tree.getUrl(), tree.getIndex(), tree.getNote(), tree.getRoleIds());
            for (SecurityFunctionTree child : tree.getChildren()) {
                vo.addChildren(SecurityFunctionTreeNodeVO.create(child));
            }
            return vo;
        }

        public SecurityFunctionTreeNodeVO(long id, long parentId, String name, String url, int index, String note, List<Long> roleIds) {
            this(id, parentId, name, note);
            this.url = url;
            this.index = index;
            this.roleIds = roleIds;
            this.children = new ArrayList<SecurityFunctionTreeNodeVO>();
        }

        public long getParentId() {
            return this.parentId;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public int getIndex() {
            return this.index;
        }

        public List<Long> getRoleIds() {
            return this.roleIds;
        }

        public List<SecurityFunctionTreeNodeVO> getChildren() {
            return this.children;
        }

        public void addChildren(SecurityFunctionTreeNodeVO child) {
            this.children.add(child);
        }

        public void addAllChildren(List<SecurityFunctionTreeNodeVO> children) {
            this.children.addAll(children);
        }
    }
}

