/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar;

import com.cunnar.exception.CunnarConfigException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CunnarConfig {
    private static final Logger log = LoggerFactory.getLogger(CunnarConfig.class);
    public static final String APP_KEY = "app.id";
    public static final String APP_SECRET = "app.secret";
    public static final String URL = "url";
    public static final String TIME_OUT = "time_out";
    public static final String SIGN_TYPE = "sign.type";
    private static final String IDLE_CONNECT_MANAGER = "idle.manager";
    private static Properties props = new Properties();

    public static String getValue(String key) {
        String property = props.getProperty(key);
        if (property == null) {
            throw new CunnarConfigException();
        }
        return property;
    }

    public static String getTimeOut() {
        return props.getProperty(TIME_OUT);
    }

    public static String getSignType() {
        String signType = props.getProperty(SIGN_TYPE);
        return signType != null ? signType : "MD5";
    }

    public static boolean isIdleConnectManager() {
        String property = props.getProperty(IDLE_CONNECT_MANAGER);
        if (property == null) {
            return true;
        }
        try {
            return Boolean.valueOf(property);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void updateProperties(String key, String value) {
        if (props == null) {
            props = new Properties();
        }
        props.setProperty(key, value);
    }

    static {
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("cunnar.properties"));
        }
        catch (Exception e) {
            log.warn("load cunnar properties fail,must use CunnarConfig#updateProperties init value.");
        }
    }
}

