/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.module;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.AccessToken;
import com.cunnar.domain.AccountExist;
import com.cunnar.domain.AccountInfo;
import com.cunnar.domain.CommonProperties;
import com.cunnar.domain.UserAuthResult;
import com.cunnar.domain.UserInfo;
import com.cunnar.exception.AccessTokenExpiredException;
import com.cunnar.exception.ErrorResult;
import com.cunnar.exception.ErrorResultException;
import com.cunnar.util.HttpResponseCallBack;
import com.cunnar.util.HttpUtil;
import com.cunnar.util.JsonUtil;
import com.cunnar.util.OpenCloudUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;

public class Account {
    private static final Log log = LogFactory.getLog(Account.class);
    private static final String AUTH_INFO = "/opencloud/api/account/auth/enterprise/chinapay.json";
    private static final String AUTH_AMOUNT = "/opencloud/api/account/auth/enterprise/chinapayamount.json";
    private static final String CHECK_FACE_URL = "/opencloud/api/account/check_face.json";
    private static final String MOLINK_AUTH_INFO_URL = "/opencloud/api/account/auth/enterprise/molinkinfo.json";
    private static final String MOLINK_AUTH_AMOUNT_URL = "/opencloud/api/account/auth/enterprise/molinkamount.json";
    private static final String UNDERLINE_AUTH_URL = "/opencloud/api/account/auth/underline.json";
    public static final int TYPE_USER_ACTIVE = 1;
    public static final int TYPE_USER_DISABLED = 0;

    public static AccountExist isAccountExistByPhone(String phone) throws ErrorResultException {
        return Account.isAccountExist(phone, true, false, false);
    }

    public static AccountExist isAccountExistByEmail(String email) throws ErrorResultException {
        return Account.isAccountExist(email, false, true, false);
    }

    public static AccountExist isAccountExistById(String id) throws ErrorResultException {
        return Account.isAccountExist(id, false, false, true);
    }

    private static AccountExist isAccountExist(String args, boolean isPhone, boolean isEmail, boolean isOutId) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (isPhone) {
            params.put("phone", args);
        }
        if (isEmail) {
            params.put("email", args);
        }
        if (isOutId) {
            params.put("out_id", args);
        }
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/account/exist.json", params, null, new HttpResponseCallBack<AccountExist>(){

            @Override
            public AccountExist doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, AccountExist.class);
            }
        });
    }

    public static String createAccountByPhone(String phone) throws ErrorResultException {
        return Account.createAccount(phone, null, null);
    }

    public static String createAccountByEmail(String email) throws ErrorResultException {
        return Account.createAccount(null, email, null);
    }

    public static String createAccountById(String id) throws ErrorResultException {
        return Account.createAccount(null, null, id);
    }

    public static String getUserIdByPhone(String phone) throws ErrorResultException {
        return Account.getUserId(phone, null, null);
    }

    public static String getUserIdByEmail(String email) throws ErrorResultException {
        return Account.getUserId(null, email, null);
    }

    public static String getUserIdById(String id) throws ErrorResultException {
        return Account.getUserId(null, null, id);
    }

    private static String getUserId(String phone, String email, String id) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("email", email);
        params.put("out_id", id);
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        return HttpUtil.get(url + "/opencloud/api/account/get_key.json", params, null, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUserId();
            }
        });
    }

    private static String createAccount(String phone, String email, String id) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("email", email);
        params.put("out_id", id);
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        return HttpUtil.post(url + "/opencloud/api/account/create.json", params, null, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.getUserId();
            }
        });
    }

    public static String registerAccount(String id, String userName) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("out_id", id);
        params.put("user_name", userName);
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        params.put("sign_type", CunnarConfig.getSignType());
        return HttpUtil.post(url + "/opencloud/api/account/register.json", params, null, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.getUserId();
            }
        });
    }

    public static String changePassword(String userId, String password) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user_id", userId);
        params.put("password", password);
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        params.put("sign_type", CunnarConfig.getSignType());
        return HttpUtil.post(url + "/opencloud/api/account/change_password.json", params, null, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.getName();
            }
        });
    }

    public static String bindPhone(AccessToken accessToken, String phone) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/bind_phone.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.getUserId();
            }
        });
    }

    public static boolean userVerify(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("card", userInfo.getCard());
        params.put("bank", userInfo.getBank());
        params.put("phone", userInfo.getPhone());
        params.put("type", userInfo.getAuthType());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/verify.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    return false;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.isVerify();
            }
        });
    }

    public static UserAuthResult userBankVerify(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("card", userInfo.getCard());
        params.put("bank", userInfo.getBank());
        params.put("phone", userInfo.getPhone());
        params.put("type", userInfo.getAuthType());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/verify.json", params, token, new HttpResponseCallBack<UserAuthResult>(){

            @Override
            public UserAuthResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                UserAuthResult authResult = new UserAuthResult();
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    authResult.setResult(false);
                    return authResult;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                authResult.setResult(properties.isVerify());
                authResult.setMsg(properties.getVerifyMsg());
                authResult.setStatcode(properties.getVerifyStatecode());
                return authResult;
            }
        });
    }

    public static String userFaceVerify(AccessToken accessToken, UserInfo userInfo, String redirectUrl) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("card", userInfo.getCard());
        params.put("type", userInfo.getAuthType());
        params.put("url", redirectUrl);
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/face_verify.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.getVerifyUrl();
            }
        });
    }

    public static boolean enterpriseVerifyCode(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("code", userInfo.getCode());
        params.put("account_name", userInfo.getAccountName());
        params.put("account_no", userInfo.getAccountNo());
        params.put("bank", userInfo.getBank());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/enterprise_verify_code.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    return false;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.isVerifyInfo();
            }
        });
    }

    public static String getCertificationUrl(AccessToken accessToken) {
        return Account.getCertificationUrl(accessToken, null, null);
    }

    public static String getCertificationUrl(AccessToken accessToken, String notifyUrl) {
        return Account.getCertificationUrl(accessToken, notifyUrl, "");
    }

    public static String getCertificationUrl(AccessToken accessToken, String notifyUrl, String extraParam) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (notifyUrl != null) {
            map.put("notify_url", notifyUrl);
            map.put("extra_param", extraParam);
        }
        return OpenCloudUtil.populateViewUrl(accessToken, map, "/opencloud/api/account/certification.html");
    }

    public static UserAuthResult enterpriseBankVerifyCode(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("code", userInfo.getCode());
        params.put("account_name", userInfo.getAccountName());
        params.put("account_no", userInfo.getAccountNo());
        params.put("bank", userInfo.getBank());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/enterprise_verify_code.json", params, token, new HttpResponseCallBack<UserAuthResult>(){

            @Override
            public UserAuthResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                UserAuthResult authResult = new UserAuthResult();
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    authResult.setResult(false);
                    return authResult;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                authResult.setResult(properties.isVerifyInfo());
                authResult.setMsg(properties.getVerifyMsg());
                authResult.setStatcode(properties.getVerifyStatecode());
                return authResult;
            }
        });
    }

    public static boolean enterpriseVerify(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account_name", userInfo.getAccountName());
        params.put("account_no", userInfo.getAccountNo());
        params.put("money", userInfo.getMoney());
        params.put("verify_code", userInfo.getVerifyCode());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/enterprise_verify.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    return false;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.isVerify();
            }
        });
    }

    public static boolean isVerifyPass(AccessToken accessToken) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/verify.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    return false;
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).isVerify();
            }
        });
    }

    public static boolean userCardVerify(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("card", userInfo.getCard());
        params.put("type", userInfo.getAuthType());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/card_verify.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    return false;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.isVerify();
            }
        });
    }

    public static UserAuthResult userCardAuth(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("card", userInfo.getCard());
        params.put("type", userInfo.getAuthType());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/card_verify.json", params, token, new HttpResponseCallBack<UserAuthResult>(){

            @Override
            public UserAuthResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                UserAuthResult authResult = new UserAuthResult();
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    authResult.setResult(false);
                    return authResult;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                authResult.setResult(properties.isVerify());
                authResult.setMsg(properties.getVerifyMsg());
                authResult.setStatcode(properties.getVerifyStatecode());
                return authResult;
            }
        });
    }

    public static AccountInfo createPersonalAccount(String id, String stamp, UserInfo userInfo, boolean isSimple) throws ErrorResultException {
        int authType;
        int n = authType = isSimple ? 2 : 0;
        if (userInfo.isIgnoreCard()) {
            authType = -1;
        }
        return Account.createAccount(id, stamp, userInfo, authType);
    }

    public static AccountInfo createEnterpriseAccount(String id, String stamp, UserInfo userInfo) throws ErrorResultException {
        userInfo.setIgnoreCard(true);
        return Account.createAccount(id, stamp, userInfo, 1);
    }

    private static AccountInfo createAccount(String id, String stamp, UserInfo userInfo, int authType) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("out_id", id);
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("real_name", userInfo.getRealName());
        params.put("card", userInfo.getCard());
        params.put("bank", userInfo.getBank());
        params.put("phone", userInfo.getPhone());
        params.put("auth_type", String.valueOf(authType));
        params.put("stamp", stamp);
        params.put("card_type", userInfo.getCardType());
        params.put("color", "1");
        if (userInfo.isIgnoreCard()) {
            params.put("ignore_card", "1");
        }
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        return HttpUtil.post(url + "/opencloud/api/contract/account.json", params, null, new HttpResponseCallBack<AccountInfo>(){

            @Override
            public AccountInfo doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                AccountInfo accountInfo = new AccountInfo();
                accountInfo.setUserId(properties.getUserId());
                accountInfo.setPermission(true);
                accountInfo.setVerifyResult(properties.isVerify());
                accountInfo.setVerifyMsg(properties.getVerifyMsg());
                accountInfo.setVerifyStatecode(properties.getVerifyStatecode());
                accountInfo.setStampResult(properties.isStamp());
                accountInfo.setCertResult(properties.isCertInstall());
                return accountInfo;
            }
        });
    }

    public static UserAuthResult enterpriseAuthInfo(AccessToken accessToken, UserInfo userInfo) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("key_type", userInfo.getKeyType());
        params.put("key", userInfo.getKey());
        params.put("key_name", userInfo.getKeyName());
        params.put("user_name", userInfo.getUserName());
        params.put("account_no", userInfo.getAccountNo());
        params.put("account_bank", userInfo.getAccountBank());
        params.put("account_prov", userInfo.getAccountProv());
        params.put("account_city", userInfo.getAccountCity());
        HashMap<String, String> token = new HashMap<String, String>(16);
        token.put("Authorization", accessToken.getAuthorization());
        return Account.postRequest(AUTH_INFO, params, token, CunnarConfig.getSignType());
    }

    public static UserAuthResult enterpriseAuthAmount(AccessToken accessToken, Integer amount) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("amount", String.valueOf(amount));
        HashMap<String, String> token = new HashMap<String, String>(16);
        token.put("Authorization", accessToken.getAuthorization());
        return Account.postRequest(AUTH_AMOUNT, params, token, CunnarConfig.getSignType());
    }

    private static UserAuthResult postRequest(String url, Map<String, String> params, Map<String, String> headers, String signType) {
        String clientSecret = CunnarConfig.getValue("app.secret");
        String clientId = CunnarConfig.getValue("app.id");
        String domain = CunnarConfig.getValue("url");
        params.put("app_key", clientId);
        params.put("sign_type", signType);
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        return HttpUtil.post(domain + url, params, headers, new HttpResponseCallBack<UserAuthResult>(){

            @Override
            public UserAuthResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                UserAuthResult authResult = new UserAuthResult();
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    authResult.setResult(false);
                    return authResult;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                authResult.setResult(properties.isVerify());
                authResult.setMsg(properties.getVerifyMsg());
                authResult.setStatcode(properties.getVerifyStatecode());
                return authResult;
            }
        });
    }

    public static UserAuthResult checkFace(AccessToken accessToken, String realName, String card, String faceImg) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("real_name", realName);
        params.put("card", card);
        params.put("face_img", faceImg);
        HashMap<String, String> token = new HashMap<String, String>(16);
        token.put("Authorization", accessToken.getAuthorization());
        return Account.postRequest(CHECK_FACE_URL, params, token, CunnarConfig.getSignType());
    }

    public static UserAuthResult molinkAuthInfo(AccessToken accessToken, UserInfo userInfo) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("key", userInfo.getKey());
        params.put("key_name", userInfo.getKeyName());
        params.put("user_name", userInfo.getUserName());
        params.put("card", userInfo.getCard());
        params.put("account_no", userInfo.getAccountNo());
        params.put("account_name", userInfo.getAccountName());
        params.put("card_place", userInfo.getCardPlace());
        HashMap<String, String> token = new HashMap<String, String>(16);
        token.put("Authorization", accessToken.getAuthorization());
        return Account.postRequest(MOLINK_AUTH_INFO_URL, params, token, CunnarConfig.getSignType());
    }

    public static UserAuthResult molinkAuthAmount(AccessToken accessToken, Integer amount, String verifyCode) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("amount", String.valueOf(amount));
        params.put("verify_code", verifyCode);
        HashMap<String, String> token = new HashMap<String, String>(16);
        token.put("Authorization", accessToken.getAuthorization());
        return Account.postRequest(MOLINK_AUTH_AMOUNT_URL, params, token, CunnarConfig.getSignType());
    }

    private static boolean userManager(String userId, int type) {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("user_id", userId);
        params.put("type", String.valueOf(type));
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.post(url + "/opencloud/api/account/user_manager.json", params, null, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, AccountInfo.class).getUserId() != null;
            }
        });
    }

    public static boolean activeUser(String userId) {
        return Account.userManager(userId, 1);
    }

    public static boolean disabledUser(String userId) {
        return Account.userManager(userId, 0);
    }

    public static Boolean savePersonInfo(AccessToken accessToken, String userName, String card) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        if (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)card)) {
            ErrorResult errorResult = new ErrorResult();
            errorResult.setErrorCode("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(errorResult);
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("user_name", userName);
        params.put("card", card);
        HashMap<String, String> token = new HashMap<String, String>(2);
        token.put("Authorization", accessToken.getAuthorization());
        return Account.postRequest(UNDERLINE_AUTH_URL, params, token, CunnarConfig.getSignType()).isResult();
    }

    public static Boolean saveEnterpriseInfo(AccessToken accessToken, String userName, String card, String orgName, String orgCode) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        if (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)card) || StringUtils.isBlank((CharSequence)orgName) || StringUtils.isBlank((CharSequence)orgCode)) {
            ErrorResult errorResult = new ErrorResult();
            errorResult.setErrorCode("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(errorResult);
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("user_name", userName);
        params.put("card", card);
        params.put("org_name", orgName);
        params.put("org_code", orgCode);
        HashMap<String, String> token = new HashMap<String, String>(2);
        token.put("Authorization", accessToken.getAuthorization());
        return Account.postRequest(UNDERLINE_AUTH_URL, params, token, CunnarConfig.getSignType()).isResult();
    }
}

