/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.module;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.ChainNodeInfo;
import com.cunnar.domain.ChainResult;
import com.cunnar.domain.CommonProperties;
import com.cunnar.domain.FileStream;
import com.cunnar.domain.InputStreamCallBack;
import com.cunnar.exception.ErrorResult;
import com.cunnar.exception.ErrorResultException;
import com.cunnar.util.HttpResponseCallBack;
import com.cunnar.util.HttpUtil;
import com.cunnar.util.JsonUtil;
import com.cunnar.util.OpenCloudUtil;
import com.cunnar.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public class Chain {
    private static final Log log = LogFactory.getLog(Chain.class);
    private static final String CREATE_CHAIN_URL = "/opencloud/api/chain/create.json";
    private static final String FILE_NODE_URL = "/opencloud/api/chain/upload.json";
    private static final String HASH_NODE_URL = "/opencloud/api/chain/upload_hash.json";
    private static final String FINISH_CHAIN_URL = "/opencloud/api/chain/complete.json";
    private static final String GET_NODE_URL = "/opencloud/api/chain/get_nodes.json";
    private static final String CHAIN_MANDATORY_ERROR_CODE = "10240";
    public static final int SHA1 = 1;
    public static final int MD5 = 2;
    public static final int SHA256 = 3;

    public static String createChain(String name, String template) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new ErrorResultException(new ErrorResult("10007", "\u53c2\u6570\u7f3a\u5931"));
        }
        String domain = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("name", name);
        params.put("template", template);
        return HttpUtil.post(domain + CREATE_CHAIN_URL, Chain.buildParam(params), new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, ChainResult.class).getChainId();
            }
        });
    }

    public static Boolean uploadNode(ChainNodeInfo info, InputStream inputStream) {
        if (inputStream == null) {
            throw new ErrorResultException(new ErrorResult("10007", "\u53c2\u6570\u7f3a\u5931"));
        }
        return Chain.upload(info, inputStream, FILE_NODE_URL);
    }

    public static Boolean uploadHashNode(ChainNodeInfo info) {
        return Chain.upload(info, null, HASH_NODE_URL);
    }

    private static Boolean upload(ChainNodeInfo info, InputStream inputStream, String url) {
        if (StringUtil.isBlank(info.getChainId(), info.getDescribe(), info.getHash(), info.getName()) || info.getLength() == null || info.getAlg() == null) {
            throw new ErrorResultException(new ErrorResult("10007", "\u53c2\u6570\u7f3a\u5931"));
        }
        String domain = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>(12);
        params.put("chain_id", info.getChainId());
        params.put("describe", info.getDescribe());
        params.put("name", info.getName());
        params.put("hash", info.getHash());
        params.put("alg", String.valueOf(info.getAlg()));
        params.put("length", String.valueOf(info.getLength()));
        params.put("is_last", String.valueOf(info.getIsLast()));
        try {
            return HttpUtil.post(domain + url, Chain.buildParam(params), null, inputStream, new HttpResponseCallBack<Boolean>(){

                @Override
                public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                    InputStream inputStream = response.getEntity().getContent();
                    return JsonUtil.toObject(inputStream, ChainResult.class).isResult();
                }
            });
        }
        catch (ErrorResultException e) {
            throw new ErrorResultException(Chain.buildChainResult(e.getErrorResult()));
        }
    }

    public static Boolean finishChain(String chainId) {
        if (StringUtils.isBlank((CharSequence)chainId)) {
            throw new ErrorResultException(new ErrorResult("10007", "\u53c2\u6570\u7f3a\u5931"));
        }
        String domain = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("chain_id", chainId);
        try {
            return HttpUtil.post(domain + FINISH_CHAIN_URL, Chain.buildParam(params), new HttpResponseCallBack<Boolean>(){

                @Override
                public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                    InputStream inputStream = response.getEntity().getContent();
                    return JsonUtil.toObject(inputStream, ChainResult.class).isResult();
                }
            });
        }
        catch (ErrorResultException e) {
            throw new ErrorResultException(Chain.buildChainResult(e.getErrorResult()));
        }
    }

    public static ChainResult getNodes(String chainId) {
        if (StringUtils.isBlank((CharSequence)chainId)) {
            throw new ErrorResultException(new ErrorResult("10007", "\u53c2\u6570\u7f3a\u5931"));
        }
        String domain = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("chain_id", chainId);
        return HttpUtil.get(domain + GET_NODE_URL, Chain.buildParam(params), null, new HttpResponseCallBack<ChainResult>(){

            @Override
            public ChainResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, ChainResult.class);
            }
        });
    }

    private static Map<String, String> buildParam(Map<String, String> params) {
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return params;
    }

    private static ErrorResult buildChainResult(ErrorResult result) {
        if (CHAIN_MANDATORY_ERROR_CODE.equals(result.getError())) {
            Map<String, String> map = JsonUtil.stringToMap(result.getErrorCode());
            result.setErrorCode(map.get("msg"));
            result.setErrorExtendInfo(map.get("temp_code"));
        }
        return result;
    }

    public static void downloadChainConfirm(String chainId, InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        Chain.downloadChainFile("/opencloud/api/confirm/download.json", chainId, inputStreamCallBack);
    }

    public static void downloadChainFileZip(String chainId, InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        Chain.downloadChainFile("/opencloud/api/chain/file/download.json", chainId, inputStreamCallBack);
    }

    public static String getChainConfirmExtractCode(String chainId, Boolean needFresh) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("chain_id", chainId);
        params.put("refresh", BooleanUtils.isTrue((Boolean)needFresh) ? "1" : "0");
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/confirm/code.json", params, null, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getExtractCode();
            }
        });
    }

    private static void downloadChainFile(String url, String chainId, final InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        if (StringUtils.isBlank((CharSequence)chainId)) {
            ErrorResult errorResult = new ErrorResult();
            errorResult.setErrorCode("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(errorResult);
        }
        String domain = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>(6);
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("chain_id", chainId);
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HttpUtil.get(domain + url, params, null, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                FileStream fileStream = new FileStream();
                Header header = response.getLastHeader("Content-Disposition");
                fileStream.setName(OpenCloudUtil.translateFileName(header == null ? null : header.getValue()));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }
}

