/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.module;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.AccessToken;
import com.cunnar.domain.CommonProperties;
import com.cunnar.domain.ContractDetails;
import com.cunnar.domain.FileHashInfo;
import com.cunnar.domain.FileInfo;
import com.cunnar.domain.FileQueryParam;
import com.cunnar.domain.FileResult;
import com.cunnar.domain.FileStream;
import com.cunnar.domain.InputStreamCallBack;
import com.cunnar.domain.TrademarkInfo;
import com.cunnar.exception.AccessTokenExpiredException;
import com.cunnar.exception.ErrorResult;
import com.cunnar.exception.ErrorResultException;
import com.cunnar.util.HttpResponseCallBack;
import com.cunnar.util.HttpUtil;
import com.cunnar.util.JsonUtil;
import com.cunnar.util.OpenCloudUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public class File {
    private static final Log log = LogFactory.getLog(File.class);
    private static final String FILE_CHECK_REPORT = "/opencloud/api/file/checkfile.json";

    public static String create(AccessToken accessToken, FileInfo fileInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        File.populateParams(fileInfo, params);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/file/create.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFileId();
            }
        });
    }

    public static String notaryFileCreate(FileInfo fileInfo) {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("app_key", appKey);
        File.populateNotaryParams(fileInfo, params);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.post(url + "/opencloud/api/notary/file/create.json", params, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, FileResult.class).getFileId();
            }
        });
    }

    public static FileResult notaryFileUpload(String fileId, InputStream inputStream, long index) {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("app_key", appKey);
        params.put("file_id", fileId);
        params.put("index", String.valueOf(index));
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.post(url + "/opencloud/api/notary/file/upload.json", params, null, inputStream, new HttpResponseCallBack<FileResult>(){

            @Override
            public FileResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, FileResult.class);
            }
        });
    }

    public static FileResult notaryUploadAgain(String fileId, InputStream inputStream) {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("app_key", appKey);
        params.put("file_id", fileId);
        params.put("index", "-2");
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.post(url + "/opencloud/api/notary/file/upload.json", params, null, inputStream, new HttpResponseCallBack<FileResult>(){

            @Override
            public FileResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, FileResult.class);
            }
        });
    }

    public static FileResult notaryFileLength(String fileId) {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("app_key", appKey);
        params.put("file_id", fileId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/notary/file/length.json", params, null, new HttpResponseCallBack<FileResult>(){

            @Override
            public FileResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, FileResult.class);
            }
        });
    }

    public static boolean notaryCreateConfirmReceipt(String fileId) {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("app_key", appKey);
        params.put("file_id", fileId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.post(url + "/opencloud/api/notary/confirmation/create.json", params, null, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, FileResult.class).isCreateConfirmation();
            }
        });
    }

    public static FileResult createWebpage(AccessToken accessToken, FileInfo fileInfo, InputStream inputStream) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        File.populateParams(fileInfo, params);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/file/webpage/create.json", params, token, inputStream, new HttpResponseCallBack<FileResult>(){

            @Override
            public FileResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, FileResult.class);
            }
        });
    }

    public static FileResult createVoiceFile(AccessToken accessToken, FileInfo fileInfo, InputStream inputStream) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        File.populateParams(fileInfo, params);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/file/voice/create.json", params, token, inputStream, new HttpResponseCallBack<FileResult>(){

            @Override
            public FileResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, FileResult.class);
            }
        });
    }

    private static void populateNotaryParams(FileInfo fileInfo, HashMap<String, String> params) {
        params.put("name", fileInfo.getName());
        params.put("length", String.valueOf(fileInfo.getLength()));
        params.put("hash", fileInfo.getShaHex());
        params.put("data", fileInfo.getData());
        params.put("data_type", fileInfo.getDataType());
        params.put("out_id", fileInfo.getId());
        long fileCreateTime = fileInfo.getFileCreateTime();
        if (fileCreateTime != 0L) {
            params.put("file_create_time", String.valueOf(fileCreateTime));
        }
        if (fileInfo.getComment() != null) {
            params.put("comment", fileInfo.getComment());
        }
    }

    private static void populateParams(FileInfo fileInfo, HashMap<String, String> params) {
        long timeLength;
        long endTime;
        long startTime;
        long loadTime;
        params.put("id", fileInfo.getId());
        params.put("name", fileInfo.getName());
        params.put("length", String.valueOf(fileInfo.getLength()));
        params.put("hash", fileInfo.getShaHex());
        params.put("label", fileInfo.getLabel());
        long fileCreateTime = fileInfo.getFileCreateTime();
        if (fileCreateTime != 0L) {
            params.put("file_create_time", String.valueOf(fileCreateTime));
        }
        if (fileInfo.getComment() != null) {
            params.put("comment", fileInfo.getComment());
        }
        if ((loadTime = fileInfo.getLoadTime()) != 0L) {
            params.put("load_time", String.valueOf(loadTime));
        }
        if (fileInfo.getUrl() != null) {
            params.put("url", fileInfo.getUrl());
        }
        if (fileInfo.getDestIp() != null) {
            params.put("dest_ip", fileInfo.getDestIp());
        }
        if (fileInfo.getSrcIp() != null) {
            params.put("src_ip", fileInfo.getSrcIp());
        }
        if (fileInfo.getTracert() != null) {
            params.put("tracert", fileInfo.getTracert());
        }
        if (fileInfo.getHosts() != null) {
            params.put("hosts", fileInfo.getHosts());
        }
        if (fileInfo.getCaller() != null) {
            params.put("caller", fileInfo.getCaller());
        }
        if (fileInfo.getCalled() != null) {
            params.put("called", fileInfo.getCalled());
        }
        if ((startTime = fileInfo.getStartTime()) != 0L) {
            params.put("start_time", String.valueOf(startTime));
        }
        if ((endTime = fileInfo.getEndTime()) != 0L) {
            params.put("end_time", String.valueOf(endTime));
        }
        if ((timeLength = fileInfo.getTimeLength()) != 0L) {
            params.put("time_length", String.valueOf(timeLength));
        }
        if (fileInfo.getHashType() != 0L) {
            params.put("hash_type", String.valueOf(fileInfo.getHashType()));
        }
        if (fileInfo.getUserName() != null) {
            params.put("user_name", fileInfo.getUserName());
        }
        if (fileInfo.getUploadHash() != null) {
            params.put("is_upload_court", String.valueOf(fileInfo.getUploadHash()));
        }
        if (fileInfo.getNeedConfirm() != null) {
            params.put("need_confirm", fileInfo.getNeedConfirm() != false ? "1" : "0");
        }
    }

    public static String getEvidenceNum(AccessToken accessToken, String fileId) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/evidence_num.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getEvidenceNum();
            }
        });
    }

    public static String createHash(AccessToken accessToken, FileInfo fileInfo) throws ErrorResultException {
        long fileCreateTime;
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", fileInfo.getName());
        params.put("length", String.valueOf(fileInfo.getLength()));
        params.put("hash", fileInfo.getShaHex());
        if (fileInfo.getHashType() != 0L) {
            params.put("type", String.valueOf(fileInfo.getHashType()));
        }
        if (fileInfo.getUserName() != null) {
            params.put("user_name", fileInfo.getUserName());
        }
        if ((fileCreateTime = fileInfo.getFileCreateTime()) != 0L) {
            params.put("file_create_time", String.valueOf(fileCreateTime));
        }
        if (fileInfo.getNeedConfirm() != null) {
            params.put("need_confirm", fileInfo.getNeedConfirm() != false ? "1" : "0");
        }
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/filehash/create.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFileHashId();
            }
        });
    }

    public static String createHash(FileInfo fileInfo) throws ErrorResultException {
        long fileCreateTime;
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", fileInfo.getName());
        params.put("length", String.valueOf(fileInfo.getLength()));
        params.put("hash", fileInfo.getShaHex());
        if (fileInfo.getHashType() != 0L) {
            params.put("type", String.valueOf(fileInfo.getHashType()));
        }
        if ((fileCreateTime = fileInfo.getFileCreateTime()) != 0L) {
            params.put("file_create_time", String.valueOf(fileCreateTime));
        }
        HashMap<String, String> token = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.post(url + "/opencloud/api/filehash/create.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFileHashId();
            }
        });
    }

    public static Boolean existHash(AccessToken accessToken, String hash) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hash", hash);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/filehash/exist.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isHashExist();
            }
        });
    }

    public static Boolean existHash(String hash) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hash", hash);
        HashMap<String, String> token = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/filehash/exist.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isHashExist();
            }
        });
    }

    public static List<FileHashInfo> getFileHash(String hash) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hash", hash);
        HashMap<String, String> token = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.post(url + "/opencloud/api/filehash/query.json", params, token, new HttpResponseCallBack<List<FileHashInfo>>(){

            @Override
            public List<FileHashInfo> doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFileHashInfos();
            }
        });
    }

    public static Boolean deleteFileHash(AccessToken accessToken, String hash) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hash", hash);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/filehash/delete.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isResult();
            }
        });
    }

    public static Boolean deleteFile(AccessToken accessToken, String fileId) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/file/delete.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isResult();
            }
        });
    }

    public static String create(FileInfo fileInfo) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        File.populateParams(fileInfo, params);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.post(url + "/opencloud/api/file/create.json", params, null, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFileId();
            }
        });
    }

    public static String createContract(FileInfo fileInfo) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        File.populateParams(fileInfo, params);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.post(url + "/opencloud/api/contract/create.json", params, null, null, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getContractId();
            }
        });
    }

    public static long uploadStream(AccessToken accessToken, String fileId, long index, InputStream inputStream) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        params.put("index", String.valueOf(index));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.postStream(url + "/opencloud/api/account/file/upload.json", inputStream, params, token, new HttpResponseCallBack<Long>(){

            @Override
            public Long doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUploadLength();
            }
        });
    }

    public static long uploadStream(String fileId, long index, InputStream inputStream) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("file_id", fileId);
        params.put("index", String.valueOf(index));
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.postStream(url + "/opencloud/api/file/upload.json", inputStream, params, null, new HttpResponseCallBack<Long>(){

            @Override
            public Long doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUploadLength();
            }
        });
    }

    public static long uploadContractStream(String contractId, long index, InputStream inputStream) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("contract_id", contractId);
        params.put("index", String.valueOf(index));
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.postStream(url + "/opencloud/api/contract/upload.json", inputStream, params, null, new HttpResponseCallBack<Long>(){

            @Override
            public Long doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUploadLength();
            }
        });
    }

    public static long getFileUploadLength(AccessToken accessToken, String fileId) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/file/length.json", params, token, new HttpResponseCallBack<Long>(){

            @Override
            public Long doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUploadLength();
            }
        });
    }

    public static long getContractUploadLength(String contractId) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("contract_id", contractId);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/contract/length.json", params, null, new HttpResponseCallBack<Long>(){

            @Override
            public Long doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUploadLength();
            }
        });
    }

    public static long getFileUploadLength(String fileId) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("file_id", fileId);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/file/length.json", params, null, new HttpResponseCallBack<Long>(){

            @Override
            public Long doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUploadLength();
            }
        });
    }

    public static FileInfo getFileInfo(AccessToken accessToken, String fileId) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/file/info.json", params, token, new HttpResponseCallBack<FileInfo>(){

            @Override
            public FileInfo doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, FileInfo.class);
            }
        });
    }

    public static FileInfo getFileInfo(String fileId) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("file_id", fileId);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/file/info.json", params, null, new HttpResponseCallBack<FileInfo>(){

            @Override
            public FileInfo doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, FileInfo.class);
            }
        });
    }

    public static List<FileInfo> queryFile(AccessToken accessToken, FileQueryParam param) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("since_id", param.getSinceId());
        params.put("max_id", param.getMaxId());
        params.put("count", String.valueOf(param.getCount()));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/file/query.json", params, token, new HttpResponseCallBack<List<FileInfo>>(){

            @Override
            public List<FileInfo> doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFiles();
            }
        });
    }

    public static List<FileInfo> queryFile(FileQueryParam param) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("since_id", param.getSinceId());
        params.put("max_id", param.getMaxId());
        params.put("count", String.valueOf(param.getCount()));
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/file/query.json", params, null, new HttpResponseCallBack<List<FileInfo>>(){

            @Override
            public List<FileInfo> doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFiles();
            }
        });
    }

    public static void downloadFile(AccessToken accessToken, final String fileId, final InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        HttpUtil.get(url + "/opencloud/api/account/file/download.json", params, token, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                FileStream fileStream = new FileStream();
                fileStream.setFileId(fileId);
                String name = response.getLastHeader("Content-Disposition").getValue();
                fileStream.setName(OpenCloudUtil.translateFileName(name));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setContentRange(response.getLastHeader("Content-Range").getValue());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }

    public static void downloadFile(final String fileId, final InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("file_id", fileId);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HttpUtil.get(url + "/opencloud/api/file/download.json", params, null, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                FileStream fileStream = new FileStream();
                fileStream.setFileId(fileId);
                String name = response.getLastHeader("Content-Disposition").getValue();
                fileStream.setName(name.replaceAll("attachment;filename=", ""));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setContentRange(response.getLastHeader("Content-Range").getValue());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }

    public static void downloadContract(final String contractId, final InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("contract_id", contractId);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HttpUtil.get(url + "/opencloud/api/contract/download.json", params, null, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                FileStream fileStream = new FileStream();
                fileStream.setFileId(contractId);
                String name = response.getLastHeader("Content-Disposition").getValue();
                fileStream.setName(name.replaceAll("attachment;filename=", ""));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setContentRange(response.getLastHeader("Content-Range").getValue());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }

    public static String getFileCertify(AccessToken accessToken) {
        return File.getFileCertify(accessToken, null, -1);
    }

    public static String getFileCertify(AccessToken accessToken, String fileIds, int certifyType) {
        return File.getFileCertify(accessToken, fileIds, certifyType, 1);
    }

    public static String getFileCertify(AccessToken accessToken, String fileIds, int certifyType, String authFileId) {
        return File.getFileCertify(accessToken, fileIds, certifyType, 1, null, null, authFileId);
    }

    public static String getFileCertify(AccessToken accessToken, String fileIds, int certifyType, int accountType) {
        return File.getFileCertify(accessToken, fileIds, certifyType, accountType, null, null);
    }

    public static String getFileCertify(AccessToken accessToken, String fileIds, int certifyType, int accountType, String authFileId) {
        return File.getFileCertify(accessToken, fileIds, certifyType, accountType, null, null, authFileId);
    }

    public static String getFileCertify(AccessToken accessToken, String fileIds, int type, int accountType, String notifyUrl, String extraParam) {
        return File.getFileCertify(accessToken, fileIds, type, accountType, notifyUrl, extraParam, null);
    }

    public static String getFileCertify(AccessToken accessToken, String fileIds, int type, int accountType, String notifyUrl, String extraParam, String authFileId) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (fileIds != null && type != -1) {
            map.put("file_ids", fileIds);
            map.put("type", type);
            if (notifyUrl != null) {
                map.put("notify_url", notifyUrl);
                map.put("extra_param", extraParam);
            }
        }
        if (accountType != 1) {
            map.put("account_type", accountType);
        }
        if (StringUtils.isNotBlank((CharSequence)authFileId)) {
            map.put("extra_file_id", authFileId);
        }
        return OpenCloudUtil.populateViewUrl(accessToken, map, "/opencloud/api/account/hcertify");
    }

    public static String getApplyArbitrationUrl(AccessToken accessToken, String fileIds) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (fileIds != null) {
            map.put("file_ids", fileIds);
        }
        return OpenCloudUtil.populateViewUrl(accessToken, map, "/opencloud/api/account/apply_arbitration");
    }

    public static String getPdfView(AccessToken accessToken, String fileId) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("file_id", fileId);
        return OpenCloudUtil.populateViewUrl(accessToken, map, "/opencloud/api/account/hpdf");
    }

    public static String getContractPdfView(AccessToken accessToken, String contractId) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contract_id", contractId);
        return OpenCloudUtil.populateViewUrl(accessToken, map, "/opencloud/api/account/hcontract");
    }

    public static String getReceiptView(AccessToken accessToken, String fileId) {
        return File.getReceiptView(accessToken, fileId, null);
    }

    public static String getHashReceiptView(AccessToken accessToken, String hash) {
        return File.getReceiptView(accessToken, null, hash);
    }

    private static String getReceiptView(AccessToken accessToken, String fileId, String hash) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)fileId)) {
            map.put("file_id", fileId);
        } else {
            map.put("hash", hash);
        }
        return OpenCloudUtil.populateViewUrl(accessToken, map, "/opencloud/api/account/hreceipt");
    }

    public static void downloadFileReceipt(AccessToken accessToken, String fileId, InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        File.downloadReceipt(accessToken, fileId, null, inputStreamCallBack);
    }

    public static void downloadHashReceipt(AccessToken accessToken, String hash, InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        File.downloadReceipt(accessToken, null, hash, inputStreamCallBack);
    }

    private static void downloadReceipt(AccessToken accessToken, final String fileId, String hash, final InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)fileId)) {
            params.put("file_id", fileId);
        } else {
            params.put("hash", hash);
        }
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        HttpUtil.get(url + "/opencloud/api/account/receipt/download.json", params, token, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                FileStream fileStream = new FileStream();
                if (StringUtils.isNotBlank((CharSequence)fileId)) {
                    fileStream.setFileId(fileId);
                }
                String name = response.getLastHeader("Content-Disposition").getValue();
                fileStream.setName(OpenCloudUtil.translateFileName(name));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setContentRange(response.getLastHeader("Content-Range").getValue());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }

    public static String getContractSignView(AccessToken accessToken, String notifyUrl, String extraParam) {
        return File.getContractSignView(accessToken, null, notifyUrl, extraParam);
    }

    public static String getContractSignView(AccessToken accessToken) {
        return File.getContractSignView(accessToken, null, null, null);
    }

    public static String getContractSignView(AccessToken accessToken, String contractId) {
        return File.getContractSignView(accessToken, contractId, null, null);
    }

    public static String getContractSignView(AccessToken accessToken, String contractId, String notifyUrl, String extraParam) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (StringUtils.isNotBlank((CharSequence)contractId)) {
            map.put("contract_id", contractId);
        }
        if (StringUtils.isNotBlank((CharSequence)notifyUrl)) {
            map.put("notify_url", notifyUrl);
            if (StringUtils.isNotBlank((CharSequence)extraParam)) {
                map.put("extra_param", extraParam);
            }
        }
        return OpenCloudUtil.populateViewUrl(accessToken, map, "/opencloud/api/account/contract/index.html");
    }

    public static String uploadContractStream(AccessToken accessToken, String name, String hash, long length, InputStream inputStream) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", name);
        params.put("length", String.valueOf(length));
        params.put("hash", hash);
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.postStream(url + "/opencloud/api/account/contract/upload.json", inputStream, params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult errorResult = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)("call interface failure , result is " + errorResult));
                    }
                    throw new ErrorResultException(errorResult);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getContractId();
            }
        });
    }

    public static Boolean contractPigeonhole(String contractId) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("contract_id", contractId);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.post(url + "/opencloud/api/account/contract/pigeonhole.json", params, null, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isResult();
            }
        });
    }

    public static ContractDetails getContractDetails(String contractId) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("contract_id", contractId);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/account/contract/details.json", params, null, new HttpResponseCallBack<ContractDetails>(){

            @Override
            public ContractDetails doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, ContractDetails.class);
            }
        });
    }

    public static void downloadContract(AccessToken accessToken, String contractId, final InputStreamCallBack inputStreamCallBack) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        if (StringUtils.isBlank((CharSequence)contractId)) {
            ErrorResult errorResult = new ErrorResult();
            errorResult.setErrorCode("10007");
            errorResult.setError("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(errorResult);
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>(6);
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("contract_id", contractId);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HashMap<String, String> token = new HashMap<String, String>(2);
        token.put("Authorization", accessToken.getAuthorization());
        HttpUtil.get(url + "/opencloud/api/account/contract/download.json", params, token, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                FileStream fileStream = new FileStream();
                Header header = response.getLastHeader("Content-Disposition");
                fileStream.setName(OpenCloudUtil.translateFileName(header == null ? null : header.getValue()));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }

    public static void downloadCheckFileReport(InputStream inputStream, String fileCode, long fileLength, final InputStreamCallBack inputStreamCallBack) {
        ErrorResult result = new ErrorResult();
        if (StringUtils.isBlank((CharSequence)fileCode)) {
            result.setErrorCode("10007");
            result.setError("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(result);
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        String domain = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("file_code", fileCode);
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("Content-Length", String.valueOf(fileLength));
        try {
            HttpUtil.postStream(domain + FILE_CHECK_REPORT, inputStream, params, headers, new HttpResponseCallBack<Object>(){

                @Override
                public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                    HttpEntity entity = response.getEntity();
                    InputStream inputStream = entity.getContent();
                    FileStream fileStream = new FileStream();
                    Header header = response.getLastHeader("Content-Disposition");
                    fileStream.setName(OpenCloudUtil.translateFileName(header == null ? null : header.getValue()));
                    fileStream.setContentLength(entity.getContentLength());
                    fileStream.setInputStream(inputStream);
                    inputStreamCallBack.doInputStream(fileStream);
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error((Object)"\u67e5\u9a8c\u5931\u8d25", (Throwable)e);
            result.setErrorCode("10201");
            result.setError("\u4e0a\u4f20\u6587\u4ef6\u6d41\u5931\u8d25");
            throw new ErrorResultException(result);
        }
    }

    public static String getFileNotary(AccessToken accessToken, String fileId) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        if (StringUtils.isNotBlank((CharSequence)fileId)) {
            param.put("file_id", fileId);
        }
        return OpenCloudUtil.populateViewUrl(accessToken, param, "/opencloud/api/usernotary/applynotary.html");
    }

    public static String getFileNotary(AccessToken accessToken) {
        return File.getFileNotary(accessToken, null);
    }

    public static void downloadConfirm(AccessToken accessToken, String fileId, InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        if (StringUtils.isBlank((CharSequence)fileId)) {
            ErrorResult errorResult = new ErrorResult();
            errorResult.setErrorCode("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(errorResult);
        }
        File.downloadConfirm(accessToken, fileId, null, inputStreamCallBack);
    }

    public static String getFileConfirmExtractCode(AccessToken accessToken, String fileId, Boolean needFresh) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        if (StringUtils.isBlank((CharSequence)fileId)) {
            ErrorResult errorResult = new ErrorResult();
            errorResult.setErrorCode("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(errorResult);
        }
        return File.getConfirmExtractCode(accessToken, fileId, null, needFresh);
    }

    public static void downloadHashConfirm(AccessToken accessToken, String fileHashId, InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        if (StringUtils.isBlank((CharSequence)fileHashId)) {
            ErrorResult errorResult = new ErrorResult();
            errorResult.setErrorCode("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(errorResult);
        }
        File.downloadConfirm(accessToken, null, fileHashId, inputStreamCallBack);
    }

    public static String getHashConfirmExtractCode(AccessToken accessToken, String fileHashId, Boolean needFresh) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        if (StringUtils.isBlank((CharSequence)fileHashId)) {
            ErrorResult errorResult = new ErrorResult();
            errorResult.setErrorCode("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(errorResult);
        }
        return File.getConfirmExtractCode(accessToken, null, fileHashId, needFresh);
    }

    private static void downloadConfirm(AccessToken accessToken, String fileId, String fileHashId, final InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>(6);
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("file_id", fileId);
        params.put("file_hash_id", fileHashId);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HashMap<String, String> token = new HashMap<String, String>(2);
        token.put("Authorization", accessToken.getAuthorization());
        HttpUtil.get(url + "/opencloud/api/account/confirm/download.json", params, token, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                FileStream fileStream = new FileStream();
                Header header = response.getLastHeader("Content-Disposition");
                fileStream.setName(OpenCloudUtil.translateFileName(header == null ? null : header.getValue()));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }

    private static String getConfirmExtractCode(AccessToken accessToken, String fileId, String fileHashId, Boolean needFresh) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("file_id", fileId);
        params.put("file_hash_id", fileHashId);
        params.put("refresh", BooleanUtils.isTrue((Boolean)needFresh) ? "1" : "0");
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HashMap<String, String> token = new HashMap<String, String>(2);
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/confirm/code.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getExtractCode();
            }
        });
    }

    public static String personApplyTrademark(AccessToken accessToken, String fileId, TrademarkInfo info) throws ErrorResultException {
        return File.applyTrademark(accessToken, fileId, info, false);
    }

    public static String enterpriseApplyTrademark(AccessToken accessToken, String fileId, TrademarkInfo info) throws ErrorResultException {
        if (StringUtils.isBlank((CharSequence)info.getOrgName()) || StringUtils.isBlank((CharSequence)info.getOrgCode())) {
            ErrorResult errorResult = new ErrorResult();
            errorResult.setErrorCode("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(errorResult);
        }
        return File.applyTrademark(accessToken, fileId, info, true);
    }

    private static String applyTrademark(AccessToken accessToken, String fileId, TrademarkInfo info, Boolean isEnterprise) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        if (StringUtils.isBlank((CharSequence)info.getUserName()) || StringUtils.isBlank((CharSequence)info.getUserCard()) || StringUtils.isBlank((CharSequence)fileId) || StringUtils.isBlank((CharSequence)info.getAcceptName()) || StringUtils.isBlank((CharSequence)info.getAcceptCode()) || StringUtils.isBlank((CharSequence)info.getTrademarkName()) || StringUtils.isBlank((CharSequence)info.getTrademarkType()) || StringUtils.isBlank((CharSequence)info.getTrademarkCode()) || StringUtils.isBlank((CharSequence)info.getVideoUrl()) || info.getTrademarkStatus() == null) {
            ErrorResult errorResult = new ErrorResult();
            errorResult.setErrorCode("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(errorResult);
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("apply_no", info.getApplyNo());
        params.put("file_id", fileId);
        params.put("org_name", info.getOrgName());
        params.put("org_code", info.getOrgCode());
        params.put("user_name", info.getUserName());
        params.put("user_card", info.getUserCard());
        params.put("sent_type", info.getSentType());
        params.put("sent_address", info.getSentAddress());
        params.put("sent_email", info.getSentAddress());
        params.put("accept_name", info.getAcceptName());
        params.put("accept_code", info.getAcceptCode());
        params.put("trademark_code", info.getTrademarkCode());
        params.put("trademark_type", info.getTrademarkType());
        params.put("trademark_name", info.getTrademarkName());
        params.put("trademark_status", info.getTrademarkStatus() == null ? "0" : String.valueOf(info.getTrademarkStatus()));
        params.put("trademark_apply_time", info.getTrademarkApplyTime() == null ? "0" : String.valueOf(info.getTrademarkApplyTime()));
        params.put("video_url", info.getVideoUrl());
        params.put("number", String.valueOf(info.getNumber() == null ? 0 : info.getNumber()));
        params.put("user_type", isEnterprise != false ? "0" : "1");
        params.put("accept_user_type", BooleanUtils.isTrue((Boolean)info.getAcceptIsEnterprise()) ? "0" : "1");
        params.put("phone", info.getPhone());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HashMap<String, String> token = new HashMap<String, String>(2);
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/usernotary/trademark/create.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getApplyNo();
            }
        });
    }

    public static String getTrademarkListUrl(AccessToken accessToken) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        return File.getTrademarkApplyUrl(accessToken, null, null, null);
    }

    public static String getTrademarkApplyUrl(AccessToken accessToken, String applyNo) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        return File.getTrademarkApplyUrl(accessToken, applyNo, null, null);
    }

    public static String getTrademarkApplyUrl(AccessToken accessToken, String applyNo, String notifyUrl, String extraParam) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        if (StringUtils.isNotBlank((CharSequence)applyNo)) {
            param.put("apply_no", applyNo);
        }
        if (StringUtils.isNotBlank((CharSequence)notifyUrl)) {
            param.put("notify_url", applyNo);
            if (StringUtils.isNotBlank((CharSequence)extraParam)) {
                param.put("extra_param", applyNo);
            }
        }
        return OpenCloudUtil.populateViewUrl(accessToken, param, "/opencloud/api/usernotary/applytrademark.html");
    }

    public static Boolean trademarkFileUpload(AccessToken accessToken, String applyNo, long length, int type, String hash, InputStream inputStream) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        ErrorResult errorResult = new ErrorResult();
        if (StringUtils.isBlank((CharSequence)applyNo) || StringUtils.isBlank((CharSequence)hash)) {
            errorResult.setErrorCode("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(errorResult);
        }
        if (length <= 0L) {
            errorResult.setErrorCode("\u53c2\u6570\u9519\u8bef");
            throw new ErrorResultException(errorResult);
        }
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("app_key", appKey);
        params.put("apply_no", applyNo);
        params.put("length", String.valueOf(length));
        params.put("type", String.valueOf(type));
        params.put("hash", hash);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HashMap<String, String> token = new HashMap<String, String>(2);
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/usernotary/trademark/file/upload.json", params, token, inputStream, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isResult();
            }
        });
    }

    public static void notarizationDownload(AccessToken accessToken, String applyNo, final InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            ErrorResult errorResult = new ErrorResult();
            errorResult.setErrorCode("\u53c2\u6570\u7f3a\u5931");
            throw new ErrorResultException(errorResult);
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>(6);
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("apply_no", applyNo);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HashMap<String, String> token = new HashMap<String, String>(2);
        token.put("Authorization", accessToken.getAuthorization());
        HttpUtil.get(url + "/opencloud/api/usernotary/trademark/notarization/download.json", params, token, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                FileStream fileStream = new FileStream();
                Header header = response.getLastHeader("Content-Disposition");
                fileStream.setName(OpenCloudUtil.translateFileName(header == null ? null : header.getValue()));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }

    public static void downloadEvidence(AccessToken accessToken, final String fileId, final InputStreamCallBack inputStreamCallBack) {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        HttpUtil.get(url + "/opencloud/api/account/file/download_evidence_zip.json", params, token, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                FileStream fileStream = new FileStream();
                fileStream.setFileId(fileId);
                String name = response.getLastHeader("Content-Disposition").getValue();
                name = OpenCloudUtil.translateFileName(name);
                fileStream.setName(URLDecoder.decode(name, "UTF-8"));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }
}

