/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.module;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.CommonProperties;
import com.cunnar.exception.ErrorResultException;
import com.cunnar.util.HttpResponseCallBack;
import com.cunnar.util.HttpUtil;
import com.cunnar.util.JsonUtil;
import com.cunnar.util.OpenCloudUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;

public class Identification {
    private static final Log log = LogFactory.getLog(Identification.class);

    public static long uploadStream(String name, String md5, long length, long index, InputStream inputStream) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("name", name);
        params.put("hash", md5);
        params.put("length", String.valueOf(length));
        params.put("index", String.valueOf(index));
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.postStream(url + "/opencloud/api/identification/file/upload.json", inputStream, params, null, new HttpResponseCallBack<Long>(){

            @Override
            public Long doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUploadLength();
            }
        });
    }

    public static long getFileUploadLength(String md5) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("hash", md5);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/identification/file/length.json", params, null, new HttpResponseCallBack<Long>(){

            @Override
            public Long doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUploadLength();
            }
        });
    }
}

