/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.module;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.AccessToken;
import com.cunnar.exception.ErrorResultException;
import com.cunnar.util.HttpResponseCallBack;
import com.cunnar.util.HttpUtil;
import com.cunnar.util.JsonUtil;
import com.cunnar.util.OpenCloudUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;

public class Oauth {
    private static final Log log = LogFactory.getLog(Oauth.class);
    private static final String SCOPE_SUPER = "SUPER";

    public static String getAuthorizeUri(String redirectUri, String state) {
        return Oauth.getAuthorizeUri(redirectUri, state, null);
    }

    public static String getSuperAuthorizeUri(String redirectUri, String state) {
        return Oauth.getAuthorizeUri(redirectUri, state, SCOPE_SUPER);
    }

    private static String getAuthorizeUri(String redirectUri, String state, String scope) {
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        try {
            URIBuilder builder = new URIBuilder(url + "/opencloud/api/oauth2/authorize");
            builder.addParameter("app_key", clientId);
            builder.addParameter("redirect_uri", redirectUri);
            if (state != null) {
                builder.addParameter("state", state);
            }
            if (StringUtils.isNotBlank((CharSequence)scope)) {
                builder.addParameter("scope", scope);
            }
            URI uri = builder.build();
            return uri.toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static AccessToken getAccessToken(String userId) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user_id", userId);
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        return HttpUtil.get(url + "/opencloud/api/account/access_token.json", params, null, new HttpResponseCallBack<AccessToken>(){

            @Override
            public AccessToken doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, AccessToken.class);
            }
        });
    }

    public static AccessToken getAccessToken(String code, String redirectUri) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", redirectUri);
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/oauth2/access_token.json", params, null, new HttpResponseCallBack<AccessToken>(){

            @Override
            public AccessToken doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, AccessToken.class);
            }
        });
    }
}

