/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.module;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.AccessToken;
import com.cunnar.domain.CommonProperties;
import com.cunnar.exception.AccessTokenExpiredException;
import com.cunnar.exception.ErrorResultException;
import com.cunnar.util.HttpResponseCallBack;
import com.cunnar.util.HttpUtil;
import com.cunnar.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;

public class Sms {
    private static final Log log = LogFactory.getLog(Sms.class);

    public static int sent(AccessToken accessToken, String phone, String key) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("key", key);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/sms/sent.json", params, token, new HttpResponseCallBack<Integer>(){

            @Override
            public Integer doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getSmsSeq();
            }
        });
    }

    public static int cunnarSent(AccessToken accessToken, String phone, String key) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("key", key);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/sms/cunnar_sent.json", params, token, new HttpResponseCallBack<Integer>(){

            @Override
            public Integer doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getSmsSeq();
            }
        });
    }

    public static String confirm(AccessToken accessToken, String phone, String code, int seq) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("sms_code", code);
        params.put("sms_seq", String.valueOf(seq));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/sms/confirm.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFileId();
            }
        });
    }

    public static String cunnarConfirm(AccessToken accessToken, String phone, String code, int seq) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("sms_code", code);
        params.put("sms_seq", String.valueOf(seq));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/sms/cunnar_confirm.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFileId();
            }
        });
    }
}

