/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.module;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.AccessToken;
import com.cunnar.domain.CommonProperties;
import com.cunnar.domain.FileStream;
import com.cunnar.domain.InputStreamCallBack;
import com.cunnar.domain.StampInfo;
import com.cunnar.domain.UserInfo;
import com.cunnar.exception.AccessTokenExpiredException;
import com.cunnar.exception.ErrorResult;
import com.cunnar.exception.ErrorResultException;
import com.cunnar.util.HttpResponseCallBack;
import com.cunnar.util.HttpUtil;
import com.cunnar.util.JsonUtil;
import com.cunnar.util.OpenCloudUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public class Stamp {
    private static final Log log = LogFactory.getLog(Stamp.class);

    public static boolean create(AccessToken accessToken, UserInfo userInfo, int type) throws ErrorResultException {
        return Stamp.create(accessToken, userInfo, null, type, 0);
    }

    public static boolean create(AccessToken accessToken, UserInfo userInfo, int type, int color) throws ErrorResultException {
        return Stamp.create(accessToken, userInfo, null, type, color);
    }

    public static boolean create(AccessToken accessToken, UserInfo userInfo, String stamp) throws ErrorResultException {
        return Stamp.create(accessToken, userInfo, stamp, 0, 0);
    }

    private static boolean create(AccessToken accessToken, UserInfo userInfo, String stamp, int type, int color) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", String.valueOf(type));
        params.put("stamp", stamp);
        params.put("card", userInfo.getCard());
        params.put("card_type", userInfo.getCardType());
        params.put("real_name", userInfo.getRealName());
        params.put("photo", userInfo.getPhoto());
        params.put("photo_front", userInfo.getPhotoFront());
        params.put("photo_reverse", userInfo.getPhotoReverse());
        params.put("color", String.valueOf(color));
        if (userInfo.isIgnoreCard()) {
            params.put("ignore_card", "1");
        }
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/stamp.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isStamp();
            }
        });
    }

    public static boolean exist(AccessToken accessToken) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/stamp.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isStamp();
            }
        });
    }

    public static void downloadStamp(AccessToken accessToken, final InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        HttpUtil.get(url + "/opencloud/api/account/stamp/download.json", null, token, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                FileStream fileStream = new FileStream();
                String name = response.getLastHeader("Content-Disposition").getValue();
                fileStream.setName(OpenCloudUtil.translateFileName(name));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setContentRange(response.getLastHeader("Content-Range").getValue());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }

    public static Boolean incrementItursCert(AccessToken accessToken) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/cert/itrus.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isCertInstall();
            }
        });
    }

    public static Boolean applyCunnarCert(AccessToken accessToken) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/cert/cunnar.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isCertInstall();
            }
        });
    }

    public static void incrementItursCert(String realName, String card, String secret, final InputStreamCallBack inputStreamCallBack) {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("real_name", realName);
        params.put("card", card);
        params.put("secret", secret);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HttpUtil.get(url + "/opencloud/api/cert/itrus.json", params, null, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                FileStream fileStream = new FileStream();
                String name = response.getLastHeader("Content-Disposition").getValue();
                fileStream.setName(OpenCloudUtil.translateFileName(name));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setContentRange(response.getLastHeader("Content-Range").getValue());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }

    public static boolean existCert(AccessToken accessToken) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/cert/itrus.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isCert();
            }
        });
    }

    public static String getCertStatus(AccessToken accessToken) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/cert/status.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getCertStatus();
            }
        });
    }

    public static List<StampInfo> createFile(String fileId, List<StampInfo> info) {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("file_id", fileId);
        StringBuilder builder = new StringBuilder();
        for (StampInfo stampInfo : info) {
            builder.append(stampInfo.getUserId()).append(",").append(stampInfo.getX()).append(",").append(stampInfo.getY()).append(",").append(stampInfo.getPage()).append(",").append(stampInfo.getWidth()).append(",").append(stampInfo.getHeight()).append("|");
        }
        if (builder.length() != 0) {
            builder.delete(builder.length() - 1, builder.length());
            params.put("param", builder.toString());
        }
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.post(url + "/opencloud/api/file/stamp.json", params, null, new HttpResponseCallBack<List<StampInfo>>(){

            @Override
            public List<StampInfo> doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getStamps();
            }
        });
    }

    public static List<StampInfo> createContractFile(String contractId, int status, List<StampInfo> info) {
        return Stamp.createContractFile(contractId, status, info, false);
    }

    public static List<StampInfo> createPrivateContractFile(String contractId, int status, List<StampInfo> info) {
        return Stamp.createContractFile(contractId, status, info, false, false);
    }

    public static List<StampInfo> createContractFile(String contractId, int status, List<StampInfo> info, boolean uploadCourt) {
        return Stamp.createContractFile(contractId, status, info, false, uploadCourt);
    }

    public static List<StampInfo> createContractFile(String contractId, int status, List<StampInfo> info, boolean isPrivate, boolean uploadCourt) {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("sign_type", CunnarConfig.getSignType());
        params.put("contract_id", contractId);
        params.put("status", String.valueOf(status));
        if (uploadCourt) {
            params.put("is_upload_court", String.valueOf(uploadCourt));
        }
        StringBuilder builder = new StringBuilder();
        for (StampInfo stampInfo : info) {
            builder.append(stampInfo.getUserId()).append(",").append(stampInfo.getX()).append(",").append(stampInfo.getY()).append(",").append(stampInfo.getPage()).append(",").append(stampInfo.getWidth()).append(",").append(stampInfo.getHeight()).append("|");
        }
        if (builder.length() != 0) {
            builder.delete(builder.length() - 1, builder.length());
            params.put("param", builder.toString());
        }
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        url = isPrivate ? url + "/opencloud/api/contract/private/stamp.json" : url + "/opencloud/api/contract/stamp.json";
        return HttpUtil.post(url, params, null, new HttpResponseCallBack<List<StampInfo>>(){

            @Override
            public List<StampInfo> doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).getStamps();
            }
        });
    }
}

