/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.module;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.AccessToken;
import com.cunnar.domain.CommonProperties;
import com.cunnar.domain.WebPageInfo;
import com.cunnar.exception.AccessTokenExpiredException;
import com.cunnar.exception.ErrorResultException;
import com.cunnar.util.HttpResponseCallBack;
import com.cunnar.util.HttpUtil;
import com.cunnar.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;

public class WebPage {
    private static final Log log = LogFactory.getLog(WebPage.class);

    public static boolean create(AccessToken accessToken, WebPageInfo info) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("url", info.getUrl());
        params.put("notify_url", info.getNotifyUrl());
        if (info.getUserName() != null) {
            params.put("user_name", info.getUserName());
        }
        if (info.getCookie() != null) {
            params.put("cookie", info.getCookie());
        }
        if (info.getBrowser() != 0) {
            params.put("browser", String.valueOf(info.getBrowser()));
        }
        if (info.getExtraParam() != null) {
            params.put("extra_param", info.getExtraParam());
        }
        if (info.getPreview() != 0) {
            params.put("preview", String.valueOf(info.getPreview()));
        }
        if (info.getUploadCourt() != null) {
            params.put("is_upload_court", String.valueOf(info.getUploadCourt()));
        }
        if (info.getNeedConfirm() != null) {
            params.put("need_confirm", info.getNeedConfirm() != false ? "1" : "0");
        }
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/webpage.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isWebpage();
            }
        });
    }

    public static boolean save(AccessToken accessToken, String fileId) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/webpage_save.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                return JsonUtil.toObject(inputStream, CommonProperties.class).isResult();
            }
        });
    }
}

