/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.util;

import com.cunnar.CunnarConfig;
import com.cunnar.exception.ErrorResult;
import com.cunnar.exception.ErrorResultException;
import com.cunnar.util.HttpResponseCallBack;
import com.cunnar.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final HttpClient CLIENT;
    private static final String CONTENT_LENGTH = "Content-Length";

    private static int getTimeoutValue() {
        int timeout = 60000;
        String value = CunnarConfig.getTimeOut();
        if (value != null) {
            timeout = Integer.valueOf(value);
        }
        return timeout;
    }

    public static <T> T post(String url, Map<String, String> params, HttpResponseCallBack<T> httpResponseCallBack) {
        return HttpUtil.post(url, params, null, httpResponseCallBack);
    }

    public static <T> T post(String url, Map<String, String> params, Map<String, String> headers, HttpResponseCallBack<T> httpResponseCallBack) {
        return HttpUtil.post(url, params, headers, null, httpResponseCallBack);
    }

    public static <T> T post(String url, Map<String, String> params, Map<String, String> headers, InputStream inputStream, HttpResponseCallBack<T> httpResponseCallBack) {
        HttpPost post = new HttpPost(url);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                post.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (inputStream != null) {
            if (params != null) {
                URIBuilder builder = null;
                try {
                    builder = new URIBuilder(url);
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        builder.addParameter(entry.getKey(), entry.getValue());
                    }
                    URI uRI = builder.build();
                    post.setURI(uRI);
                }
                catch (URISyntaxException uRISyntaxException) {
                    log.error("http post url error", (Throwable)uRISyntaxException);
                    return null;
                }
            }
            post.removeHeaders(CONTENT_LENGTH);
            post.setEntity((HttpEntity)new InputStreamEntity(inputStream, NumberUtils.toLong(headers != null ? headers.get(CONTENT_LENGTH) : null, (long)-1L)));
        } else if (params != null) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                list.add(pair);
            }
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(list, Charset.forName("UTF-8"));
            post.setEntity((HttpEntity)urlEncodedFormEntity);
        }
        return HttpUtil.execute(httpResponseCallBack, (HttpRequestBase)post);
    }

    public static <T> T postStream(String url, InputStream inputStream, Map<String, String> params, Map<String, String> headers, HttpResponseCallBack<T> httpResponseCallBack) {
        return HttpUtil.post(url, params, headers, inputStream, httpResponseCallBack);
    }

    public static <T> T get(String url, HttpResponseCallBack<T> httpResponseCallBack) {
        return HttpUtil.get(url, null, null, httpResponseCallBack);
    }

    public static <T> T get(String url, Map<String, String> params, Map<String, String> headers, HttpResponseCallBack<T> httpResponseCallBack) {
        HttpGet get = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    builder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            URI uri = builder.build();
            get = new HttpGet(uri);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    get.addHeader(entry.getKey(), entry.getValue());
                }
            }
            return HttpUtil.execute(httpResponseCallBack, (HttpRequestBase)get);
        }
        catch (URISyntaxException e) {
            log.error("http get url error", (Throwable)e);
            return null;
        }
    }

    private static <T> T execute(HttpResponseCallBack<T> httpResponseCallBack, HttpRequestBase base) {
        HttpResponse httpResponse = null;
        try {
            httpResponse = CLIENT.execute((HttpUriRequest)base);
            if (httpResponse != null) {
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    if (statusCode == 400) {
                        InputStream inputStream = httpResponse.getEntity().getContent();
                        ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                        if (log.isErrorEnabled()) {
                            log.error(result.toString());
                        }
                        throw new ErrorResultException(result);
                    }
                    log.error("request fail,http status code is {}", (Object)statusCode);
                    throw new ErrorResultException();
                }
                T t = httpResponseCallBack.doResponse(httpResponse);
                return t;
            }
        }
        catch (IOException e) {
            log.error("http post error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (httpResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
            if (base != null) {
                base.releaseConnection();
            }
        }
        return null;
    }

    static {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build());
        connectionManager.setMaxTotal(20000);
        connectionManager.setDefaultMaxPerRoute(2000);
        int timeoutValue = HttpUtil.getTimeoutValue();
        HttpClientBuilder builder = HttpClientBuilder.create();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeoutValue).setConnectTimeout(timeoutValue).build();
        builder.setDefaultRequestConfig(requestConfig);
        builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        builder.disableAutomaticRetries().evictIdleConnections(Long.valueOf(2L), TimeUnit.MINUTES).evictExpiredConnections();
        CLIENT = builder.build();
    }
}

