/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String fromObject(Object object) {
        if (null == object) {
            return "";
        }
        StringWriter w = new StringWriter();
        try {
            OBJECT_MAPPER.writeValue((Writer)w, object);
        }
        catch (IOException e) {
            return null;
        }
        return w.toString();
    }

    public static Map<String, String> stringToMap(String json) {
        if (json == null) {
            return null;
        }
        try {
            TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
            return (Map)OBJECT_MAPPER.readValue(json, (TypeReference)typeRef);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static <T> T toObject(InputStream inputStream, Class<T> tClass) {
        if (inputStream == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(inputStream, tClass);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static <T> List<T> toList(InputStream inputStream, Class<T> tClass) {
        if (inputStream == null) {
            return null;
        }
        try {
            TypeFactory factory = OBJECT_MAPPER.getTypeFactory();
            CollectionType type = factory.constructCollectionType(List.class, tClass);
            List list = (List)OBJECT_MAPPER.readValue(inputStream, (JavaType)type);
            return list == null ? Collections.emptyList() : list;
        }
        catch (IOException e) {
            return null;
        }
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

