/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.util;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.AccessToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class OpenCloudUtil {
    public static String buildSign(Map<String, ? extends Object> param, String clientSecret) {
        String signType = (String)param.get("sign_type");
        String sign = null;
        sign = "SHA-1".equalsIgnoreCase(signType) ? DigestUtils.sha1Hex((String)(OpenCloudUtil.createLinkString(param) + clientSecret)) : ("SHA-256".equalsIgnoreCase(signType) ? DigestUtils.sha256Hex((String)(OpenCloudUtil.createLinkString(param) + clientSecret)) : DigestUtils.md5Hex((String)(OpenCloudUtil.createLinkString(param) + clientSecret)));
        return sign;
    }

    public static String createLinkString(Map<String, ? extends Object> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            String value;
            String key = (String)keys.get(i);
            Object o = params.get(key);
            if (o == null || (value = o.toString()) == null || value.trim().equals("") || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) continue;
            builder.append(key).append("=").append(value);
            builder.append("&");
        }
        int length = builder.length();
        builder.delete(length - 1, length);
        return builder.toString();
    }

    public static boolean validSign(Map<String, Object> map, String secret, String sign) {
        return OpenCloudUtil.buildSign(map, secret).equalsIgnoreCase(sign);
    }

    public static String translateFileName(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        return name.replaceAll("attachment;filename=|\"|;", "");
    }

    public static String populateViewUrl(AccessToken accessToken, Map<String, Object> param, String prefix) {
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        StringBuilder builder = new StringBuilder(CunnarConfig.getValue("url"));
        String token = accessToken.getAccessToken();
        builder.append(prefix).append("?access_token=").append(token);
        long time = System.currentTimeMillis();
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            builder.append("&").append(key).append("=").append(value);
            params.put(key, value.toString());
        }
        builder.append("&t=").append(time);
        builder.append("&app_key=").append(appKey);
        String signType = CunnarConfig.getSignType();
        builder.append("&sign_type=").append(signType);
        params.put("t", String.valueOf(time));
        params.put("access_token", token);
        params.put("app_key", appKey);
        params.put("sign_type", signType);
        builder.append("&sign=").append(OpenCloudUtil.buildSign(params, appSecret));
        return builder.toString();
    }
}

