/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.jsp.taglib;

import com.fusioncharts.helper.ChartDataFormat;
import com.fusioncharts.helper.FCParameters;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class ChartTag
extends BodyTagSupport {
    private static final long serialVersionUID = 2L;
    protected String chartId = "";
    protected String swfFilename = null;
    protected String chartData = null;
    protected String chartDataUrl = null;
    protected String dataFormat = null;
    protected Boolean silentUpdate = null;
    protected String xmlData = null;
    protected String xmlUrl = null;
    protected String jsonData = null;
    protected String jsonUrl = null;
    protected String width = null;
    protected String height = null;
    protected Boolean debugMode = null;
    protected Boolean registerWithJS = null;
    protected String windowMode = null;
    protected String bgColor = null;
    protected String scaleMode = null;
    protected String lang = null;
    protected String detectFlashVersion = null;
    protected String autoInstallRedirect = null;
    protected String _bodyContentString = null;
    protected String renderer = null;
    protected String renderAt = null;
    protected Object options = null;
    protected String _dataSource = null;

    private int boolToNum(Boolean bool) {
        int num = 0;
        if (bool.booleanValue()) {
            num = 1;
        }
        return num;
    }

    public int doAfterBody() {
        BodyContent bc = super.getBodyContent();
        if (this.xmlData == null && this.bodyContent != null) {
            String body = bc.getString();
            this.setBodyContentString(body);
        }
        if (this.bodyContent != null) {
            this.bodyContent.clearBody();
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            JspWriter writer = this.pageContext.getOut();
            Boolean debugModeBool = this.getDebugMode();
            Boolean registerWithJSBool = this.getRegisterWithJS();
            int debugModeInt = 0;
            int regWithJSInt = 0;
            if (debugModeBool != null && !debugModeBool.equals("")) {
                debugModeInt = this.boolToNum(debugModeBool);
            }
            if (registerWithJSBool != null && !registerWithJSBool.equals("")) {
                regWithJSInt = this.boolToNum(registerWithJSBool);
            }
            if (this.getBodyContentString() != null && !this.getBodyContentString().trim().equals("")) {
                this.setDataSource(this._bodyContentString);
            } else if (this.xmlData != null && !this.xmlData.equals("")) {
                this.setDataSource(this.xmlData);
                this.setDataFormat(ChartDataFormat.XML.toString());
            } else if (this.xmlUrl != null && !this.xmlUrl.equals("")) {
                this.setDataSource(this.xmlUrl);
                this.setDataFormat(ChartDataFormat.XMLURL.toString());
            } else if (this.jsonData != null && !this.jsonData.equals("")) {
                this.setDataSource(this.jsonData);
                this.setDataFormat(ChartDataFormat.JSON.toString());
            } else if (this.jsonUrl != null && !this.jsonUrl.equals("")) {
                this.setDataSource(this.jsonUrl);
                this.setDataFormat(ChartDataFormat.JSONURL.toString());
            } else if (this.chartData != null && !this.chartData.equals("")) {
                this.setDataSource(this.chartData);
            } else if (this.chartDataUrl != null && !this.chartDataUrl.equals("")) {
                this.setDataSource(this.chartDataUrl);
            }
            FCParameters fcParams = new FCParameters(this.swfFilename, this.chartId, this.width, this.height, "" + debugModeInt, "" + regWithJSInt, this.windowMode, this.bgColor, this.scaleMode, this.lang, this.detectFlashVersion, this.autoInstallRedirect, this._dataSource, this.dataFormat, this.renderer, this.renderAt);
            String paramsInJSON = fcParams.toJSON();
            writer.write("\t\t\tvar chart_" + this.chartId + " = new FusionCharts(" + paramsInJSON + ").render();");
            writer.write("\n");
            writer.write("\t\t");
            writer.write("</script>");
            writer.write("\n");
            writer.write("\t\t<!--END Script Block for Chart " + this.chartId + "-->\n");
        }
        catch (Exception ex) {
            throw new JspTagException("ChartTag: " + ex.getMessage());
        }
        this.releaseNonReusableAttributes();
        return 0;
    }

    public int doStartTag() throws JspException {
        this.init();
        this.validateTag();
        try {
            JspWriter writer = this.pageContext.getOut();
            writer.write("\t\t<!-- START Script Block for Chart " + this.chartId + "-->\n");
            writer.write("\t\t");
            writer.write("<div id='" + this.chartId + "Div' align='center'>");
            writer.write("\n");
            writer.write("\t\t\tChart.\n");
            writer.write("\t\t");
            writer.write("</div>");
            writer.write("\n");
            writer.write("\t\t");
            writer.write("<script type='text/javascript'>");
            writer.write("\n");
            if (this.renderAt == null || this.renderAt.equals("")) {
                this.renderAt = String.valueOf(this.chartId) + "Div";
            }
        }
        catch (Exception ex) {
            throw new JspTagException("ChartTag: " + ex.getMessage());
        }
        return 2;
    }

    public String getAutoInstallRedirect() {
        return this.autoInstallRedirect;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public String getBodyContentString() {
        return this._bodyContentString;
    }

    public String getChartData() {
        return this.chartData;
    }

    public String getChartDataUrl() {
        return this.chartDataUrl;
    }

    public String getChartId() {
        return this.chartId;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public Boolean getDebugMode() {
        return this.debugMode;
    }

    public String getDetectFlashVersion() {
        return this.detectFlashVersion;
    }

    public String getHeight() {
        return this.height;
    }

    public String getJsonData() {
        return this.jsonData;
    }

    public String getJsonUrl() {
        return this.jsonUrl;
    }

    public String getLang() {
        return this.lang;
    }

    public Object getOptions() {
        return this.options;
    }

    public Boolean getRegisterWithJS() {
        return this.registerWithJS;
    }

    public String getRenderAt() {
        return this.renderAt;
    }

    public String getRenderer() {
        return this.renderer;
    }

    public String getScaleMode() {
        return this.scaleMode;
    }

    public Boolean getSilentUpdate() {
        return this.silentUpdate;
    }

    public String getSwfFilename() {
        return this.swfFilename;
    }

    public String getWidth() {
        return this.width;
    }

    public String getWindowMode() {
        return this.windowMode;
    }

    public String getXmlData() {
        return this.xmlData;
    }

    public String getXmlUrl() {
        return this.xmlUrl;
    }

    private void init() {
        this._dataSource = null;
        this._bodyContentString = null;
    }

    public void release() {
        super.release();
        this.releaseAttributes();
    }

    private void releaseAttributes() {
        this.releaseMandatoryAttributes();
        this.releaseOptionalAttributes();
        this.releaseNonReusableAttributes();
    }

    private void releaseMandatoryAttributes() {
        this.chartId = null;
        this.swfFilename = null;
        this.width = null;
        this.height = null;
    }

    private void releaseNonReusableAttributes() {
        this.renderAt = null;
    }

    private void releaseOptionalAttributes() {
        this.chartData = null;
        this.chartDataUrl = null;
        this.dataFormat = null;
        this.xmlData = null;
        this.xmlUrl = null;
        this.jsonData = null;
        this.jsonUrl = null;
        this.debugMode = null;
        this.registerWithJS = null;
        this.windowMode = null;
        this.bgColor = null;
        this.scaleMode = null;
        this.lang = null;
        this.detectFlashVersion = null;
        this.autoInstallRedirect = null;
        this.renderer = null;
        this._bodyContentString = null;
        this.bodyContent = null;
        this._dataSource = null;
        this.options = null;
        this.silentUpdate = null;
    }

    public void setAutoInstallRedirect(String autoInstallRedirect) {
        this.autoInstallRedirect = autoInstallRedirect;
    }

    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public void setBodyContent(BodyContent bc) {
        super.setBodyContent(bc);
    }

    public void setBodyContentString(String bodyContentString) {
        this._bodyContentString = bodyContentString;
    }

    public void setChartData(String chartData) {
        this.chartData = chartData;
    }

    public void setChartDataUrl(String chartDataUrl) {
        this.chartDataUrl = chartDataUrl;
    }

    public void setChartId(String chartId) {
        this.chartId = chartId;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setDataSource(String dataSource) {
        this._dataSource = dataSource;
    }

    public void setDebugMode(Boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setDetectFlashVersion(String detectFlashVersion) {
        this.detectFlashVersion = detectFlashVersion;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setJsonData(String jsonData) {
        this.jsonData = jsonData;
    }

    public void setJsonUrl(String jsonUrl) {
        this.jsonUrl = jsonUrl;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setOptions(Object options) {
        this.options = options;
    }

    public void setRegisterWithJS(Boolean registerWithJS) {
        this.registerWithJS = registerWithJS;
    }

    public void setRenderAt(String renderAt) {
        this.renderAt = renderAt;
    }

    public void setRenderer(String renderer) {
        this.renderer = renderer;
    }

    public void setScaleMode(String scaleMode) {
        this.scaleMode = scaleMode;
    }

    public void setSilentUpdate(Boolean silentUpdate) {
        this.silentUpdate = silentUpdate;
    }

    public void setSwfFilename(String swfFilename) {
        this.swfFilename = swfFilename;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setWindowMode(String mode) {
        this.windowMode = mode;
    }

    public void setXmlData(String xmlData) {
        this.xmlData = xmlData;
    }

    public void setXmlUrl(String xmlUrl) {
        this.xmlUrl = xmlUrl;
    }

    private void validateTag() throws JspException {
        if (this.getChartData() == null && this.getChartDataUrl() == null && this.getDataFormat() == null && this.getJsonUrl() == null && this.getJsonData() == null && this.getXmlUrl() == null && this.getXmlData() == null) {
            throw new JspException("Please provide either xmlData, xmlURL, jsonData or jsonURL as attribute. If providing the xml or json as body of the tag, then please include the value for dataFormat attribute");
        }
        if ((this.getChartData() != null || this.getChartDataUrl() != null) && this.getDataFormat() == null) {
            throw new JspException("Please include the value for dataFormat attribute while using chartData or chartDataURL attributes");
        }
        if (this.getDataFormat() != null) {
            try {
                ChartDataFormat.exists((String)this.getDataFormat().toLowerCase());
            }
            catch (IllegalArgumentException iae) {
                throw new JspException("Please specify a valid value for the attribute dataFormat.The currently supported values are xml,xml-url, json and json-url.");
            }
        }
    }
}

