/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http;

import com.gexin.rp.sdk.exceptions.RequestException;
import com.gexin.rp.sdk.http.GtHttpProxy;
import com.gexin.rp.sdk.http.client.GtHttpClient;
import com.gexin.rp.sdk.http.utils.GTConfig;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpManager {
    private static Logger logger = Logger.getLogger(HttpManager.class.getName());
    private GtHttpClient client;

    public HttpManager() {
        this.init(GTConfig.getHttpConnectionTimeOut(), GTConfig.getHttpSoTimeOut(), GTConfig.getHttpTryCount());
    }

    private void init(int connectionTimeOut, int soTimeOut, int maxHttpTryTime) {
        this.client = new GtHttpClient(connectionTimeOut, soTimeOut, maxHttpTryTime);
    }

    public Map<String, Object> httpPostJSON(String url, Map<String, Object> data, boolean gzip) {
        Map<String, Object> response = null;
        try {
            response = this.client.executePostJson(url, data, gzip, gzip);
            return response;
        }
        catch (Exception e) {
            throw new RequestException((String)data.get("requestId"), "httpPost:[" + url + "] [" + data + " ] [ " + response + "]:", e);
        }
    }

    public static SSLContext getTrustAllSSLContext() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[1];
        CustomTrustManager trust = new CustomTrustManager();
        trustAllCerts[0] = trust;
        String algorithm = GTConfig.getSslTlsVersion();
        String[] algorithms = new String[]{"TLS", "SSL"};
        if (algorithm != null) {
            algorithms = algorithm.split(",");
        }
        SSLContext sc = null;
        for (String version : algorithms) {
            try {
                sc = SSLContext.getInstance(version);
                break;
            }
            catch (NoSuchAlgorithmException e) {
                logger.log(Level.WARNING, "no provider for " + version, e);
            }
        }
        if (sc == null) {
            throw new RuntimeException("fail to get SSLContext for " + Arrays.asList(algorithms));
        }
        sc.init(null, trustAllCerts, null);
        return sc;
    }

    public void setProxy(GtHttpProxy proxy) {
        this.client.setProxy(proxy);
    }

    static class CustomTrustManager
    implements TrustManager,
    X509TrustManager {
        CustomTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

