/*
 * Decompiled with CFR 0.152.
 */
package com.yaoming.common.util;

import java.util.concurrent.locks.ReentrantLock;

public class IdGenerator {
    private static final long twepoch = 1404741526058L;
    private static final long idBits = 5L;
    private static final long groupIdBits = 5L;
    private static final long sequenceBits = 12L;
    private static final long maxId = 31L;
    private static final long maxGroupId = 31L;
    private static final long sequenceMask = 4095L;
    private static final long idShift = 12L;
    private static final long groupIdShift = 17L;
    private static final long timestampLeftShift = 22L;
    private static long lastTimestamp = -1L;
    private ReentrantLock lock = new ReentrantLock();
    private long sequence = 0L;
    private final long databaseId;
    private final long dbGroupId;
    private static ThreadLocal<IdGenerator> defaultIdGenerator = new ThreadLocal();

    public static IdGenerator getDefault() {
        if (defaultIdGenerator.get() == null) {
            defaultIdGenerator.set(new IdGenerator(Thread.currentThread().getId() % 31L, Thread.currentThread().getId() % 31L));
        }
        return defaultIdGenerator.get();
    }

    public IdGenerator(long groupId, long id) {
        if (id > 31L || id < 0L) {
            throw new IllegalArgumentException("Id\u4e0d\u80fd\u5927\u4e8e%d\u6216\u5c0f\u4e8e0");
        }
        if (groupId > 31L || groupId < 0L) {
            throw new IllegalArgumentException("\u96c6\u7fa4Id\u4e0d\u80fd\u5927\u4e8e%d\u6216\u5c0f\u4e8e0");
        }
        this.databaseId = id;
        this.dbGroupId = groupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextId() {
        this.lock.lock();
        try {
            long nextId;
            long timestamp = this.timeGen();
            if (timestamp < lastTimestamp) {
                throw new RuntimeException("\u7cfb\u7edf\u65f6\u95f4\u5012\u9000 " + (lastTimestamp - timestamp) + "\u6beb\u79d2\uff0c\u4e0d\u5141\u8bb8\u751f\u6210id\u3002");
            }
            if (lastTimestamp == timestamp) {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    timestamp = this.toNextMillis(lastTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            lastTimestamp = timestamp;
            long l = nextId = timestamp - 1404741526058L << 22 | this.dbGroupId << 17 | this.databaseId << 12 | this.sequence;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private long toNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

