/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.matcher;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronException;
import cn.hutool.cron.pattern.matcher.AlwaysTrueValueMatcher;
import cn.hutool.cron.pattern.matcher.BoolArrayValueMatcher;
import cn.hutool.cron.pattern.matcher.DayOfMonthValueMatcher;
import cn.hutool.cron.pattern.matcher.ValueMatcher;
import cn.hutool.cron.pattern.matcher.YearValueMatcher;
import cn.hutool.cron.pattern.parser.DayOfMonthValueParser;
import cn.hutool.cron.pattern.parser.ValueParser;
import cn.hutool.cron.pattern.parser.YearValueParser;
import java.util.ArrayList;
import java.util.List;

public class ValueMatcherBuilder {
    public static ValueMatcher build(String value, ValueParser parser) {
        if (1 == value.length() && ("*".equals(value) || "?".equals(value))) {
            return new AlwaysTrueValueMatcher();
        }
        List<Integer> values = ValueMatcherBuilder.parseArray(value, parser);
        if (values.size() == 0) {
            throw new CronException("Invalid field: [{}]", value);
        }
        if (parser instanceof DayOfMonthValueParser) {
            return new DayOfMonthValueMatcher(values);
        }
        if (parser instanceof YearValueParser) {
            return new YearValueMatcher(values);
        }
        return new BoolArrayValueMatcher(values);
    }

    private static List<Integer> parseArray(String value, ValueParser parser) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        List<String> parts = StrUtil.split((CharSequence)value, ',');
        for (String part : parts) {
            CollectionUtil.addAllIfNotContains(values, ValueMatcherBuilder.parseStep(part, parser));
        }
        return values;
    }

    private static List<Integer> parseStep(String value, ValueParser parser) {
        List<String> parts = StrUtil.split((CharSequence)value, '/');
        int size = parts.size();
        if (size == 1) {
            return ValueMatcherBuilder.parseRange(value, parser);
        }
        if (size == 2) {
            List<Integer> rangeValues = ValueMatcherBuilder.parseRange(parts.get(0), parser);
            int step = parser.parse(parts.get(1));
            if (step < 1) {
                throw new CronException("Non positive divisor for field: [{}]", value);
            }
            ArrayList<Integer> values2 = new ArrayList<Integer>();
            for (int i = 0; i < rangeValues.size(); i += step) {
                values2.add(rangeValues.get(i));
            }
            return values2;
        }
        throw new CronException("Invalid syntax of field: [{}]", value);
    }

    private static List<Integer> parseRange(String value, ValueParser parser) {
        if (value.length() == 1 && value.equals("*")) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (int i = parser.getMin(); i <= parser.getMax(); ++i) {
                values.add(i);
            }
            return values;
        }
        List<String> parts = StrUtil.split((CharSequence)value, '-');
        int size = parts.size();
        ArrayList<Integer> values = new ArrayList<Integer>();
        if (size == 1) {
            values.add(parser.parse(value));
            return values;
        }
        if (size == 2) {
            int v2;
            int v1 = parser.parse(parts.get(0));
            if (v1 < (v2 = parser.parse(parts.get(1)))) {
                NumberUtil.appendRange(v1, v2, values);
            } else if (v1 > v2) {
                NumberUtil.appendRange(v1, parser.getMax(), values);
                NumberUtil.appendRange(parser.getMin(), v2, values);
            } else {
                values.add(v1);
            }
        } else {
            throw new CronException("Invalid syntax of field: [{}]", value);
        }
        return values;
    }
}

