/*
 * Decompiled with CFR 0.152.
 */
package cn.teaey.apns4j;

import cn.teaey.apns4j.protocol.ApnsPayload;
import cn.teaey.apns4j.protocol.InvalidDeviceTokenException;
import cn.teaey.apns4j.protocol.Protocal;
import java.nio.ByteBuffer;

public class ApnsHelper {
    private static final int HEADER_LENGTH = 45;

    public static final byte[] toRequestBytes(byte[] deviceTokenBytes, ApnsPayload apnsPayload) {
        byte[] payloadBytes = apnsPayload.toJsonBytes();
        ByteBuffer buffer = ByteBuffer.allocate(45 + payloadBytes.length);
        buffer.put((byte)1);
        buffer.putInt(apnsPayload.getIdentifier());
        buffer.putInt(apnsPayload.getExpiry());
        buffer.putShort((short)32);
        buffer.put(deviceTokenBytes);
        buffer.putShort((short)payloadBytes.length);
        buffer.put(payloadBytes);
        return buffer.array();
    }

    public static final byte[] toRequestBytes(byte[] deviceTokenBytes, String payloadJsonString, int identifier, int expiry) {
        byte[] payloadBytes = payloadJsonString.getBytes(Protocal.DEF_CHARSET);
        ByteBuffer buffer = ByteBuffer.allocate(45 + payloadBytes.length);
        buffer.put((byte)1);
        buffer.putInt(identifier);
        buffer.putInt(expiry);
        buffer.putShort((short)32);
        buffer.put(deviceTokenBytes);
        buffer.putShort((short)payloadBytes.length);
        buffer.put(payloadBytes);
        return buffer.array();
    }

    public static final String toHexString(byte[] bytes) {
        StringBuilder ret = new StringBuilder(64);
        for (int n : bytes) {
            String hexStr = Integer.toHexString(n >= 0 ? n : 256 + n);
            if (hexStr.length() == 1) {
                ret.append("0");
            }
            ret.append(hexStr);
        }
        return ret.toString();
    }

    public static final byte[] toByteArray(String deviceToken) {
        byte[] deviceTokenAsBytes = new byte[deviceToken.length() / 2];
        deviceToken = deviceToken.toUpperCase();
        int j = 0;
        try {
            for (int i = 0; i < deviceToken.length(); i += 2) {
                String t = deviceToken.substring(i, i + 2);
                deviceTokenAsBytes[j++] = (byte)Integer.parseInt(t, 16);
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidDeviceTokenException(e.getMessage());
        }
        return deviceTokenAsBytes;
    }

    public static final void checkDeviceToken(Object deviceToken) {
        if (deviceToken instanceof String && ((String)deviceToken).length() != 64) {
            throw new InvalidDeviceTokenException("device token string must [64] length not [" + ((String)deviceToken).length() + "]");
        }
        if (deviceToken instanceof byte[] && ((byte[])deviceToken).length != 32) {
            throw new InvalidDeviceTokenException("device token bytes must [32] length not [" + ((byte[])deviceToken).length + "]");
        }
    }

    public static final void checkNullThrowException(Object target, String name) {
        if (null == target) {
            throw new NullPointerException(name == null ? "" : name);
        }
    }
}

