/*
 * Decompiled with CFR 0.152.
 */
package cn.teaey.apns4j.network;

import cn.teaey.apns4j.ApnsException;
import cn.teaey.apns4j.ApnsHelper;
import cn.teaey.apns4j.network.Channel;
import cn.teaey.apns4j.network.SecuritySocketFactory;
import cn.teaey.apns4j.network.async.ApnsFuture;
import cn.teaey.apns4j.network.async.PayloadSender;
import cn.teaey.apns4j.protocol.ApnsPayload;
import cn.teaey.apns4j.protocol.ErrorResp;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSocket;

public class ApnsChannel
implements Channel,
PayloadSender<ApnsPayload> {
    public static final int DEFAULT_TRY_TIMES = 3;
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final int id;
    private final SecuritySocketFactory socketFactory;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private SSLSocket socket;
    private InputStream in;
    private OutputStream out;
    private int tryTimes;

    public ApnsChannel(SecuritySocketFactory socketFactory) {
        this(socketFactory, 3);
    }

    public ApnsChannel(SecuritySocketFactory socketFactory, int tryTimes) {
        this.socketFactory = socketFactory;
        this.tryTimes = tryTimes;
        this.id = COUNTER.incrementAndGet();
    }

    private void flush() throws IOException {
        this.checkClosed();
        this.out().flush();
    }

    public ApnsFuture send(byte[] deviceTokenBytes, ApnsPayload apnsPayload, int tryTimes) {
        this.checkClosed();
        if (tryTimes < 1) {
            tryTimes = 1;
        }
        ApnsHelper.checkDeviceToken(deviceTokenBytes);
        String jsonString = apnsPayload.toJsonString();
        byte[] binaryData = ApnsHelper.toRequestBytes(deviceTokenBytes, jsonString, apnsPayload.getIdentifier(), apnsPayload.getExpiry());
        for (int i = 1; i <= tryTimes; ++i) {
            try {
                this.socket();
                this.out().write(binaryData);
                this.flush();
                break;
            }
            catch (IOException e) {
                try {
                    this._close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (i != tryTimes) continue;
                throw new ApnsException(e);
            }
        }
        return null;
    }

    @Override
    public ApnsFuture send(byte[] deviceTokenBytes, ApnsPayload apnsPayload) {
        this.checkClosed();
        return this.send(deviceTokenBytes, apnsPayload, this.tryTimes);
    }

    public ApnsFuture send(String deviceTokenString, ApnsPayload apnsPayload, int tryTimes) {
        this.checkClosed();
        return this.send(ApnsHelper.toByteArray(deviceTokenString), apnsPayload, tryTimes);
    }

    @Override
    public ApnsFuture send(String deviceTokenString, ApnsPayload apnsPayload) {
        this.checkClosed();
        return this.send(ApnsHelper.toByteArray(deviceTokenString), apnsPayload);
    }

    public ErrorResp recvErrorResp() {
        this.checkClosed();
        try {
            if (null == this.in()) {
                return null;
            }
            if (this.in().available() > 0) {
                byte[] data = new byte[6];
                this.recv(data);
                return new ErrorResp(data);
            }
            return null;
        }
        catch (IOException e) {
            throw new ApnsException(e);
        }
        catch (ApnsException e) {
            throw e;
        }
    }

    private void _close() throws IOException {
        if (null != this.socket) {
            try {
                this.socket.close();
            }
            finally {
                this.in = null;
                this.out = null;
                this.socket = null;
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this.closed.compareAndSet(false, true)) {
                this._close();
            }
        }
        catch (IOException e) {
            throw new ApnsException(e);
        }
    }

    private void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Channel closed, get a new channel from channel factory");
        }
    }

    @Override
    public void send(byte[] data) {
        this.checkClosed();
        try {
            this.out().write(data);
        }
        catch (IOException e) {
            try {
                this._close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ApnsException(e);
        }
    }

    @Override
    public int recv(byte[] data) {
        this.checkClosed();
        try {
            return this.in().read(data);
        }
        catch (IOException e) {
            try {
                this._close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ApnsException(e);
        }
    }

    protected void socket() throws IOException {
        this.checkClosed();
        if (null != this.socket && null != this.in && null != this.out && !this.socket.isClosed()) {
            return;
        }
        this._close();
        this.socket = this.socketFactory.createSocket();
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
    }

    protected OutputStream out() {
        return this.out;
    }

    protected InputStream in() {
        return this.in;
    }

    public int getId() {
        return this.id;
    }
}

