/*
 * Decompiled with CFR 0.152.
 */
package cn.teaey.apns4j.network;

import cn.teaey.apns4j.ApnsException;
import cn.teaey.apns4j.keystore.InvalidKeyStoreException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class SecuritySocketFactory {
    private static final String ALGORITHM = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "sunx509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
    private static final String PROTOCOL = "TLS";
    private final String host;
    private final int port;
    private final KeyStore keyStore;
    private final String keyStorePwd;
    private final SSLSocketFactory sslSocketFactory;
    private final TrustManager[] trustManagers = new TrustManager[]{new ServerTrustingTrustManager()};

    public SecuritySocketFactory(String host, int port, KeyStore keyStore, String keyStorePwd) {
        if (host == null) {
            throw new NullPointerException("host");
        }
        if (keyStore == null) {
            throw new NullPointerException("keystore");
        }
        if (keyStorePwd == null) {
            throw new NullPointerException("keyStorePwd");
        }
        this.host = host;
        this.port = port;
        this.keyStore = keyStore;
        this.keyStorePwd = keyStorePwd;
        this.sslSocketFactory = this.createSSLSocketFactoryWithTrustManagers(this.trustManagers);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePwd() {
        return this.keyStorePwd;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    protected SSLSocketFactory createSSLSocketFactoryWithTrustManagers(TrustManager[] trustManagers) {
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(ALGORITHM);
            kmf.init(this.keyStore, this.keyStorePwd.toCharArray());
            SSLContext sslc = SSLContext.getInstance(PROTOCOL);
            sslc.init(kmf.getKeyManagers(), trustManagers, null);
            return sslc.getSocketFactory();
        }
        catch (Exception e) {
            throw new ApnsException(new InvalidKeyStoreException(e));
        }
    }

    public SSLSocket createSocket() throws IOException {
        return (SSLSocket)this.sslSocketFactory.createSocket(this.host, this.port);
    }

    private class ServerTrustingTrustManager
    implements X509TrustManager {
        private ServerTrustingTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException("not trusted");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

