/*
 * Decompiled with CFR 0.152.
 */
package cn.teaey.apns4j.protocol;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ListMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    Entry[] table;
    int size;

    public ListMap() {
        this.table = new Entry[16];
    }

    public ListMap(int initialCapacity) {
        this.table = new Entry[initialCapacity];
    }

    private Entry remove(int index) {
        this.rangeCheck(index);
        Entry oldValue = this.table[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.table, index + 1, this.table, index, numMoved);
        }
        this.table[--this.size] = null;
        return oldValue;
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    private Entry index(int index) {
        this.rangeCheck(index);
        return this.table[index];
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return null;
    }

    private abstract class ListIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        int index;

        ListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index != ListMap.this.size() - 1;
        }

        @Override
        public Map.Entry<K, V> next() {
            return ListMap.this.index(++this.index);
        }

        @Override
        public void remove() {
            ListMap.this.remove(this.index);
        }
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return "[" + this.getKey() + ":" + this.getValue() + "]";
        }
    }
}

