/*
 * Decompiled with CFR 0.152.
 */
package cn.teaey.apns4j.network;

import cn.teaey.apns4j.ApnsException;
import cn.teaey.apns4j.ApnsHelper;
import cn.teaey.apns4j.network.Channel;
import cn.teaey.apns4j.network.SecuritySocketFactory;
import cn.teaey.apns4j.network.async.ApnsFuture;
import cn.teaey.apns4j.network.async.PayloadSender;
import cn.teaey.apns4j.protocol.ApnsPayload;
import cn.teaey.apns4j.protocol.ErrorResp;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSocket;

public class ApnsChannel
implements Channel,
PayloadSender<ApnsPayload> {
    public static final int DEFAULT_TRY_TIMES = 3;
    private static final int CACHE_SIZE = 2000;
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final int id;
    private final SecuritySocketFactory socketFactory;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile SSLSocket socket;
    private volatile InputStream in;
    private volatile OutputStream out;
    private final int tryTimes;
    private volatile LRUCache<Integer, CacheWapper> payloadCache = new LRUCache(2000);

    public ApnsChannel(SecuritySocketFactory socketFactory) {
        this(socketFactory, 3);
    }

    public ApnsChannel(SecuritySocketFactory socketFactory, int tryTimes) {
        this._detectSocket();
        this.socketFactory = socketFactory;
        this.tryTimes = tryTimes;
        this.id = COUNTER.incrementAndGet();
    }

    private void flush() throws IOException {
        this.checkClosed();
        this.out().flush();
    }

    public ApnsFuture send(byte[] deviceTokenBytes, ApnsPayload apnsPayload, int tryTimes, boolean resent) {
        this.checkClosed();
        if (tryTimes < 1) {
            tryTimes = 1;
        }
        int payloadId = ApnsHelper.IDENTIFIER.incrementAndGet();
        ApnsHelper.checkDeviceToken(deviceTokenBytes);
        String jsonString = apnsPayload.toJsonString();
        byte[] binaryData = ApnsHelper.toRequestBytes(deviceTokenBytes, jsonString, payloadId, apnsPayload.getExpiry());
        for (int i = 1; i <= tryTimes; ++i) {
            try {
                this.socket();
                this.out().write(binaryData);
                this.flush();
                break;
            }
            catch (IOException e) {
                try {
                    this._close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (i != tryTimes) continue;
                throw new ApnsException(e);
            }
        }
        if (!resent) {
            this.payloadCache.put(payloadId, new CacheWapper(payloadId, deviceTokenBytes, apnsPayload));
        }
        return null;
    }

    @Override
    public ApnsFuture send(byte[] deviceTokenBytes, ApnsPayload apnsPayload) {
        this.checkClosed();
        return this.send(deviceTokenBytes, apnsPayload, this.tryTimes, false);
    }

    public ApnsFuture send(String deviceTokenString, ApnsPayload apnsPayload, int tryTimes) {
        this.checkClosed();
        return this.send(ApnsHelper.toByteArray(deviceTokenString), apnsPayload, tryTimes, false);
    }

    @Override
    public ApnsFuture send(String deviceTokenString, ApnsPayload apnsPayload) {
        this.checkClosed();
        return this.send(ApnsHelper.toByteArray(deviceTokenString), apnsPayload);
    }

    public ErrorResp recvErrorResp() {
        this.checkClosed();
        try {
            if (null == this.in()) {
                return null;
            }
            byte[] data = new byte[6];
            this.recv(data);
            this._close();
            return new ErrorResp(data);
        }
        catch (ApnsException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ApnsException(e);
        }
    }

    private void _close() throws IOException {
        if (null != this.socket) {
            try {
                this.socket.close();
            }
            finally {
                this.in = null;
                this.out = null;
                this.socket = null;
            }
        }
    }

    private void _detectSocket() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                block2: while (!ApnsChannel.this.closed.get()) {
                    try {
                        ErrorResp errorResp = ApnsChannel.this.recvErrorResp();
                        if (null == errorResp) {
                            Thread.sleep(1000L);
                            continue;
                        }
                        LRUCache cache = ApnsChannel.this.payloadCache;
                        ApnsChannel.this.payloadCache = new LRUCache(2000);
                        for (CacheWapper cacheWapper : cache.values()) {
                            if (cacheWapper.getId() <= errorResp.getIdentifier()) continue;
                            if (ApnsChannel.this.closed.get()) continue block2;
                            ApnsChannel.this.send(cacheWapper.getDeviceToken(), cacheWapper.getApnsPayload(), 1, true);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }, "Apns4j-Channel-Detector-" + this.id);
        t.start();
    }

    @Override
    public void close() {
        try {
            if (this.closed.compareAndSet(false, true)) {
                this._close();
            }
        }
        catch (IOException e) {
            throw new ApnsException(e);
        }
    }

    private void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Channel closed, get a new channel from channel factory");
        }
    }

    @Override
    public void send(byte[] data) {
        this.checkClosed();
        try {
            this.out().write(data);
        }
        catch (IOException e) {
            try {
                this._close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ApnsException(e);
        }
    }

    @Override
    public int recv(byte[] data) {
        this.checkClosed();
        try {
            return this.in().read(data);
        }
        catch (IOException e) {
            try {
                this._close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ApnsException(e);
        }
    }

    protected void socket() throws IOException {
        this.checkClosed();
        if (null != this.socket && null != this.in && null != this.out && !this.socket.isClosed()) {
            return;
        }
        this._close();
        this.socket = this.socketFactory.createSocket();
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
    }

    protected OutputStream out() {
        return this.out;
    }

    protected InputStream in() {
        return this.in;
    }

    public int getId() {
        return this.id;
    }

    private class CacheWapper {
        private final int id;
        private final byte[] deviceToken;
        private final ApnsPayload apnsPayload;

        private CacheWapper(int id, byte[] deviceToken, ApnsPayload apnsPayload) {
            this.id = id;
            this.deviceToken = deviceToken;
            this.apnsPayload = apnsPayload;
        }

        public int getId() {
            return this.id;
        }

        public byte[] getDeviceToken() {
            return this.deviceToken;
        }

        public ApnsPayload getApnsPayload() {
            return this.apnsPayload;
        }
    }

    private class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int capacity;

        public LRUCache(int cacheSize) {
            super((int)Math.ceil((double)cacheSize / 0.75) + 1, 0.75f, true);
            this.capacity = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.capacity;
        }
    }
}

