/*
 * Decompiled with CFR 0.152.
 */
package cn.teaey.apns4j.protocol;

import cn.teaey.apns4j.protocol.Payload;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApnsPayload
extends Payload {
    private static final String ATTR_APS = "aps";
    private static final String ATTR_ALERT = "alert";
    private static final String ATTR_BADGE = "badge";
    private static final String ATTR_SOUND = "sound";
    private static final String ATTR_ALERT_BODY = "body";
    private static final String ATTR_ALERT_TITLE = "title";
    private static final String ATTR_ALERT_ACTION_LOC_KEY = "action-loc-key";
    private static final String ATTR_ALERT_TITLE_LOC_KEY = "title-loc-key";
    private static final String ATTR_ALERT_TITLE_LOC_ARGS = "title-loc-args";
    private static final String ATTR_ALERT_LOC_KEY = "loc-key";
    private static final String ATTR_ALERT_LOC_ARGS = "loc-args";
    private static final String ATTR_ALERT_LAUNCH_IMAGE = "launch-image";
    private static final String ATTR_CONTENT_AVAILABLE = "content-available";
    private final Map<String, Object> apsDict = new HashMap<String, Object>();

    public ApnsPayload() {
        this.addDictionary(ATTR_APS, this.apsDict);
    }

    public ApnsPayload alert(String msg) {
        this.apsDict.put(ATTR_ALERT, msg);
        return this;
    }

    public ApnsPayload badge(int num) {
        this.apsDict.put(ATTR_BADGE, num);
        return this;
    }

    public ApnsPayload sound(String sound) {
        this.apsDict.put(ATTR_SOUND, sound);
        return this;
    }

    public ApnsPayload alertBody(String body) {
        this.ensureAlertMap().put(ATTR_ALERT_BODY, body);
        return this;
    }

    public ApnsPayload alertTitle(String title) {
        this.ensureAlertMap().put(ATTR_ALERT_TITLE, title);
        return this;
    }

    public ApnsPayload alertTitleLocKey(String titleLocKey) {
        this.ensureAlertMap().put(ATTR_ALERT_TITLE_LOC_KEY, titleLocKey);
        return this;
    }

    public ApnsPayload alertTitleLocArgs(String titleLocArgs) {
        this.ensureAlertMap().put(ATTR_ALERT_TITLE_LOC_ARGS, titleLocArgs);
        return this;
    }

    public ApnsPayload alertActionLocKey(String actionLocKey) {
        this.ensureAlertMap().put(ATTR_ALERT_ACTION_LOC_KEY, actionLocKey);
        return this;
    }

    public ApnsPayload alertLocKey(String locKey) {
        this.ensureAlertMap().put(ATTR_ALERT_LOC_KEY, locKey);
        return this;
    }

    public ApnsPayload alertLocArgs(List args) {
        this.ensureAlertMap().put(ATTR_ALERT_LOC_ARGS, args);
        return this;
    }

    public ApnsPayload launchImage(String args) {
        this.ensureAlertMap().put(ATTR_ALERT_LAUNCH_IMAGE, args);
        return this;
    }

    private Map<String, Object> ensureAlertMap() {
        HashMap ret = this.apsDict.get(ATTR_ALERT);
        if (null == ret || ret instanceof String) {
            ret = new HashMap();
            this.apsDict.put(ATTR_ALERT, ret);
        }
        return ret;
    }

    public ApnsPayload silent() {
        this.addDictionary(ATTR_CONTENT_AVAILABLE, 1);
        return this;
    }

    public ApnsPayload extend(String k, Object v) {
        this.apsDict.put(k, v);
        return this;
    }
}

