/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGOrderBy;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGArrayExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGBoxExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGCidrExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGCircleExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGDateField;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGExtractExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGInetExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGIntervalExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGLineSegmentsExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGMacAddrExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGPointExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGPolygonExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGTypeCastExpr;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGLexer;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class PGExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER"};

    public PGExprParser(String sql) {
        this(new PGLexer(sql));
        this.lexer.nextToken();
        this.dbType = "postgresql";
    }

    public PGExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.dbType = "postgresql";
    }

    @Override
    public PGOrderBy parseOrderBy() {
        if (this.lexer.token() == Token.ORDER) {
            PGOrderBy orderBy = new PGOrderBy();
            this.lexer.nextToken();
            if (this.identifierEquals("SIBLINGS")) {
                this.lexer.nextToken();
                orderBy.setSibings(true);
            }
            this.accept(Token.BY);
            orderBy.addItem(this.parseSelectOrderByItem());
            while (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                orderBy.addItem(this.parseSelectOrderByItem());
            }
            return orderBy;
        }
        return null;
    }

    @Override
    public SQLExpr primary() {
        if (this.lexer.token() == Token.ARRAY) {
            this.lexer.nextToken();
            PGArrayExpr array = new PGArrayExpr();
            this.accept(Token.LBRACKET);
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        if (this.lexer.token() == Token.POUND) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LBRACE) {
                this.lexer.nextToken();
                String varName = this.lexer.stringVal();
                this.lexer.nextToken();
                this.accept(Token.RBRACE);
                SQLVariantRefExpr expr = new SQLVariantRefExpr("#{" + varName + "}");
                return this.primaryRest(expr);
            }
            SQLExpr value = this.primary();
            SQLUnaryExpr expr = new SQLUnaryExpr(SQLUnaryOperator.Pound, value);
            return this.primaryRest(expr);
        }
        return super.primary();
    }

    @Override
    protected SQLExpr parseInterval() {
        this.accept(Token.INTERVAL);
        PGIntervalExpr intervalExpr = new PGIntervalExpr();
        if (this.lexer.token() != Token.LITERAL_CHARS) {
            return new SQLIdentifierExpr("INTERVAL");
        }
        intervalExpr.setValue(new SQLCharExpr(this.lexer.stringVal()));
        this.lexer.nextToken();
        return intervalExpr;
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.token() == Token.COLONCOLON) {
            this.lexer.nextToken();
            SQLDataType dataType = this.parseDataType();
            PGTypeCastExpr castExpr = new PGTypeCastExpr();
            castExpr.setExpr(expr);
            castExpr.setDataType(dataType);
            return this.primaryRest(castExpr);
        }
        if (expr.getClass() == SQLIdentifierExpr.class) {
            String ident = ((SQLIdentifierExpr)expr).getName();
            if ("TIMESTAMP".equalsIgnoreCase(ident)) {
                if (this.lexer.token() != Token.LITERAL_ALIAS && this.lexer.token() != Token.LITERAL_CHARS && this.lexer.token() != Token.WITH) {
                    return new SQLIdentifierExpr("TIMESTAMP");
                }
                SQLTimestampExpr timestamp = new SQLTimestampExpr();
                if (this.lexer.token() == Token.WITH) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("TIME");
                    this.acceptIdentifier("ZONE");
                    timestamp.setWithTimeZone(true);
                }
                String literal = this.lexer.stringVal();
                timestamp.setLiteral(literal);
                this.accept(Token.LITERAL_CHARS);
                if (this.identifierEquals("AT")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("TIME");
                    this.acceptIdentifier("ZONE");
                    String timezone = this.lexer.stringVal();
                    timestamp.setTimeZone(timezone);
                    this.accept(Token.LITERAL_CHARS);
                }
                return this.primaryRest(timestamp);
            }
            if ("EXTRACT".equalsIgnoreCase(ident)) {
                this.accept(Token.LPAREN);
                PGExtractExpr extract = new PGExtractExpr();
                String fieldName = this.lexer.stringVal();
                PGDateField field = PGDateField.valueOf(fieldName.toUpperCase());
                this.lexer.nextToken();
                extract.setField(field);
                this.accept(Token.FROM);
                SQLExpr source = this.expr();
                extract.setSource(source);
                this.accept(Token.RPAREN);
                return this.primaryRest(extract);
            }
            if ("POINT".equalsIgnoreCase(ident)) {
                SQLExpr value = this.primary();
                PGPointExpr point = new PGPointExpr();
                point.setValue(value);
                return this.primaryRest(point);
            }
            if ("BOX".equalsIgnoreCase(ident)) {
                SQLExpr value = this.primary();
                PGBoxExpr box = new PGBoxExpr();
                box.setValue(value);
                return this.primaryRest(box);
            }
            if ("macaddr".equalsIgnoreCase(ident)) {
                SQLExpr value = this.primary();
                PGMacAddrExpr macaddr = new PGMacAddrExpr();
                macaddr.setValue(value);
                return this.primaryRest(macaddr);
            }
            if ("inet".equalsIgnoreCase(ident)) {
                SQLExpr value = this.primary();
                PGInetExpr inet = new PGInetExpr();
                inet.setValue(value);
                return this.primaryRest(inet);
            }
            if ("cidr".equalsIgnoreCase(ident)) {
                SQLExpr value = this.primary();
                PGCidrExpr cidr = new PGCidrExpr();
                cidr.setValue(value);
                return this.primaryRest(cidr);
            }
            if ("polygon".equalsIgnoreCase(ident)) {
                SQLExpr value = this.primary();
                PGPolygonExpr polygon = new PGPolygonExpr();
                polygon.setValue(value);
                return this.primaryRest(polygon);
            }
            if ("circle".equalsIgnoreCase(ident)) {
                SQLExpr value = this.primary();
                PGCircleExpr circle = new PGCircleExpr();
                circle.setValue(value);
                return this.primaryRest(circle);
            }
            if ("lseg".equalsIgnoreCase(ident)) {
                SQLExpr value = this.primary();
                PGLineSegmentsExpr lseg = new PGLineSegmentsExpr();
                lseg.setValue(value);
                return this.primaryRest(lseg);
            }
            if (ident.equalsIgnoreCase("b") && this.lexer.token() == Token.LITERAL_CHARS) {
                String charValue = this.lexer.stringVal();
                this.lexer.nextToken();
                expr = new SQLBinaryExpr(charValue);
                return this.primaryRest(expr);
            }
        }
        return super.primaryRest(expr);
    }
}

