/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.graphql;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.DefaultKeyset;
import com.blazebit.persistence.DefaultKeysetPage;
import com.blazebit.persistence.Keyset;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.integration.graphql.DefaultFetchMapping;
import com.blazebit.persistence.integration.graphql.GraphQLCursor;
import com.blazebit.persistence.integration.graphql.GraphQLCursorObjectInputStream;
import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.ViewType;
import graphql.relay.Connection;
import graphql.relay.ConnectionCursor;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultConnectionCursor;
import graphql.relay.DefaultEdge;
import graphql.relay.DefaultPageInfo;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLImplementingType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.SelectedField;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class GraphQLEntityViewSupport {
    public static final String PAGE_SIZE_NAME = "first";
    public static final String RELAY_LAST_NAME = "last";
    public static final String OFFSET_NAME = "offset";
    public static final String BEFORE_CURSOR_NAME = "before";
    public static final String AFTER_CURSOR_NAME = "after";
    public static final String EDGES_NAME = "edges";
    public static final String EDGE_NODE_NAME = "node";
    public static final String EDGE_CURSOR_NAME = "cursor";
    public static final String TOTAL_COUNT_NAME = "totalCount";
    private static final Set<String> META_FIELDS = new HashSet<String>(Arrays.asList("__typename"));
    private final Map<String, ManagedViewType<?>> typeNameToViewType;
    private final Map<String, Map<String, String>> typeNameToFieldMapping;
    private final Map<String, Set<DefaultFetchMapping>> typeNameToDefaultFetchMappings;
    private final Set<String> serializableBasicTypes;
    private final ConcurrentMap<TypeRootCacheKey, GraphQLUnmodifiedType> typeReferenceCache = new ConcurrentHashMap<TypeRootCacheKey, GraphQLUnmodifiedType>();
    private final ConcurrentMap<String, String[]> selectedFieldCache = new ConcurrentHashMap<String, String[]>();
    private final String pageSizeName;
    private final String offsetName;
    private final String beforeCursorName;
    private final String afterCursorName;
    private final String totalCountName;
    private final String pageElementsName;
    private final String pageElementObjectName;
    private final String elementCursorName;

    GraphQLEntityViewSupport() {
        this(null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Deprecated
    public GraphQLEntityViewSupport(Map<String, ManagedViewType<?>> typeNameToViewType, Set<String> serializableBasicTypes) {
        this(typeNameToViewType, Collections.emptyMap(), Collections.emptyMap(), serializableBasicTypes, PAGE_SIZE_NAME, OFFSET_NAME, BEFORE_CURSOR_NAME, AFTER_CURSOR_NAME, TOTAL_COUNT_NAME, EDGES_NAME, EDGE_NODE_NAME, EDGE_CURSOR_NAME);
    }

    @Deprecated
    public GraphQLEntityViewSupport(Map<String, ManagedViewType<?>> typeNameToViewType, Map<String, Map<String, String>> typeNameToFieldMapping, Set<String> serializableBasicTypes) {
        this(typeNameToViewType, typeNameToFieldMapping, Collections.emptyMap(), serializableBasicTypes, PAGE_SIZE_NAME, OFFSET_NAME, BEFORE_CURSOR_NAME, AFTER_CURSOR_NAME, TOTAL_COUNT_NAME, EDGES_NAME, EDGE_NODE_NAME, EDGE_CURSOR_NAME);
    }

    public GraphQLEntityViewSupport(Map<String, ManagedViewType<?>> typeNameToViewType, Map<String, Map<String, String>> typeNameToFieldMapping, Map<String, Set<DefaultFetchMapping>> typeNameToDefaultFetchMappings, Set<String> serializableBasicTypes) {
        this(typeNameToViewType, typeNameToFieldMapping, typeNameToDefaultFetchMappings, serializableBasicTypes, PAGE_SIZE_NAME, OFFSET_NAME, BEFORE_CURSOR_NAME, AFTER_CURSOR_NAME, TOTAL_COUNT_NAME, EDGES_NAME, EDGE_NODE_NAME, EDGE_CURSOR_NAME);
    }

    @Deprecated
    public GraphQLEntityViewSupport(Map<String, ManagedViewType<?>> typeNameToViewType, Set<String> serializableBasicTypes, String pageSizeName, String offsetName, String beforeCursorName, String afterCursorName, String totalCountName, String pageElementsName, String pageElementObjectName, String elementCursorName) {
        this(typeNameToViewType, Collections.emptyMap(), Collections.emptyMap(), serializableBasicTypes, pageSizeName, offsetName, beforeCursorName, afterCursorName, totalCountName, pageElementsName, pageElementObjectName, elementCursorName);
    }

    @Deprecated
    public GraphQLEntityViewSupport(Map<String, ManagedViewType<?>> typeNameToViewType, Map<String, Map<String, String>> typeNameToFieldMapping, Set<String> serializableBasicTypes, String pageSizeName, String offsetName, String beforeCursorName, String afterCursorName, String totalCountName, String pageElementsName, String pageElementObjectName, String elementCursorName) {
        this(typeNameToViewType, typeNameToFieldMapping, Collections.emptyMap(), serializableBasicTypes, pageSizeName, offsetName, beforeCursorName, afterCursorName, totalCountName, pageElementsName, pageElementObjectName, elementCursorName);
    }

    public GraphQLEntityViewSupport(Map<String, ManagedViewType<?>> typeNameToViewType, Map<String, Map<String, String>> typeNameToFieldMapping, Map<String, Set<DefaultFetchMapping>> typeNameToDefaultFetchMappings, Set<String> serializableBasicTypes, String pageSizeName, String offsetName, String beforeCursorName, String afterCursorName, String totalCountName, String pageElementsName, String pageElementObjectName, String elementCursorName) {
        this.pageSizeName = pageSizeName;
        this.offsetName = offsetName;
        this.beforeCursorName = beforeCursorName;
        this.afterCursorName = afterCursorName;
        this.totalCountName = totalCountName;
        this.pageElementsName = pageElementsName;
        this.typeNameToViewType = typeNameToViewType;
        this.typeNameToFieldMapping = typeNameToFieldMapping;
        this.typeNameToDefaultFetchMappings = typeNameToDefaultFetchMappings;
        this.serializableBasicTypes = serializableBasicTypes;
        this.pageElementObjectName = pageElementObjectName;
        this.elementCursorName = elementCursorName;
    }

    public <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> createPaginatedSetting(DataFetchingEnvironment dataFetchingEnvironment) {
        return this.createPaginatedSetting(dataFetchingEnvironment, this.pageElementsName);
    }

    public <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> createPaginatedSetting(DataFetchingEnvironment dataFetchingEnvironment, Integer first, Integer last, Integer offset, String beforeCursor, String afterCursor) {
        return this.createPaginatedSetting(dataFetchingEnvironment, this.pageElementsName, first, last, offset, beforeCursor, afterCursor);
    }

    public <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> createPaginatedSetting(DataFetchingEnvironment dataFetchingEnvironment, String elementRoot) {
        String objectRoot = this.pageElementObjectName == null || this.pageElementObjectName.isEmpty() ? elementRoot : (elementRoot == null || elementRoot.isEmpty() ? this.pageElementObjectName : elementRoot + "/" + this.pageElementObjectName);
        String typeName = this.getElementTypeName(dataFetchingEnvironment, objectRoot);
        ManagedViewType<?> entityViewClass = this.typeNameToViewType.get(typeName);
        if (entityViewClass == null) {
            throw new IllegalArgumentException("No entity view type is registered for the name: " + typeName);
        }
        return this.createPaginatedSetting(entityViewClass.getJavaType(), dataFetchingEnvironment, elementRoot);
    }

    public <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> createPaginatedSetting(DataFetchingEnvironment dataFetchingEnvironment, String elementRoot, Integer first, Integer last, Integer offset, String beforeCursor, String afterCursor) {
        String objectRoot = this.pageElementObjectName == null || this.pageElementObjectName.isEmpty() ? elementRoot : (elementRoot == null || elementRoot.isEmpty() ? this.pageElementObjectName : elementRoot + "/" + this.pageElementObjectName);
        String typeName = this.getElementTypeName(dataFetchingEnvironment, objectRoot);
        ManagedViewType<?> entityViewClass = this.typeNameToViewType.get(typeName);
        if (entityViewClass == null) {
            throw new IllegalArgumentException("No entity view type is registered for the name: " + typeName);
        }
        return this.createPaginatedSetting(entityViewClass.getJavaType(), dataFetchingEnvironment, elementRoot, this.extractKeysetPage(first, last, beforeCursor, afterCursor), first, last, offset);
    }

    public <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> createPaginatedSetting(Class<T> entityViewClass, DataFetchingEnvironment dataFetchingEnvironment) {
        return this.createPaginatedSetting(entityViewClass, dataFetchingEnvironment, this.pageElementsName);
    }

    public <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> createPaginatedSetting(Class<T> entityViewClass, DataFetchingEnvironment dataFetchingEnvironment, String elementRoot) {
        KeysetPage keysetPage = this.extractKeysetPage(dataFetchingEnvironment);
        Integer pageSize = null;
        Integer offset = null;
        Integer last = null;
        if (keysetPage != null) {
            pageSize = (Integer)dataFetchingEnvironment.getArgument(this.pageSizeName);
            offset = (Integer)dataFetchingEnvironment.getArgument(this.offsetName);
            if (offset == null && keysetPage.getLowest() != null && keysetPage.getHighest() != null) {
                offset = keysetPage.getFirstResult() + keysetPage.getMaxResults();
            }
            last = (Integer)dataFetchingEnvironment.getArgument(RELAY_LAST_NAME);
        }
        return this.createPaginatedSetting(entityViewClass, dataFetchingEnvironment, elementRoot, keysetPage, pageSize, last, offset);
    }

    public <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> createPaginatedSetting(Class<T> entityViewClass, DataFetchingEnvironment dataFetchingEnvironment, String elementRoot, KeysetPage keysetPage, Integer first, Integer last, Integer offset) {
        String objectRoot = this.pageElementObjectName == null || this.pageElementObjectName.isEmpty() ? elementRoot : (elementRoot == null || elementRoot.isEmpty() ? this.pageElementObjectName : elementRoot + "/" + this.pageElementObjectName);
        EntityViewSetting<T, CriteriaBuilder<T>> setting = this.createSetting(entityViewClass, dataFetchingEnvironment, objectRoot, keysetPage, first, last, offset);
        if (!dataFetchingEnvironment.getSelectionSet().contains(this.totalCountName)) {
            setting.setProperty("com.blazebit.persistence.view.pagination.disable_count_query", (Object)Boolean.TRUE);
        }
        if (this.elementCursorName != null && !this.elementCursorName.isEmpty()) {
            String elementCursorPath = elementRoot == null || elementRoot.isEmpty() ? this.elementCursorName : elementRoot + "/" + this.elementCursorName;
            if (dataFetchingEnvironment.getSelectionSet().contains(elementCursorPath)) {
                setting.setProperty("com.blazebit.persistence.view.pagination.extract_all_keysets", (Object)Boolean.TRUE);
            }
        }
        return setting;
    }

    public <T> EntityViewSetting<T, CriteriaBuilder<T>> createSetting(DataFetchingEnvironment dataFetchingEnvironment) {
        return this.createSetting(dataFetchingEnvironment, "");
    }

    public <T> EntityViewSetting<T, CriteriaBuilder<T>> createSetting(DataFetchingEnvironment dataFetchingEnvironment, String elementRoot) {
        String typeName = this.getElementTypeName(dataFetchingEnvironment, elementRoot);
        ManagedViewType<?> entityViewClass = this.typeNameToViewType.get(typeName);
        if (entityViewClass == null) {
            throw new IllegalArgumentException("No entity view type is registered for the name: " + typeName);
        }
        return this.createSetting(entityViewClass.getJavaType(), dataFetchingEnvironment, elementRoot);
    }

    public String getElementTypeName(DataFetchingEnvironment dataFetchingEnvironment, String elementRoot) {
        return this.getElementType(dataFetchingEnvironment, elementRoot).getName();
    }

    public GraphQLUnmodifiedType getElementType(DataFetchingEnvironment dataFetchingEnvironment, String elementRoot) {
        String[] parts;
        GraphQLUnmodifiedType type = GraphQLTypeUtil.unwrapAll((GraphQLType)dataFetchingEnvironment.getFieldDefinition().getType());
        TypeRootCacheKey cacheKey = new TypeRootCacheKey((GraphQLType)type, elementRoot);
        GraphQLUnmodifiedType cachedType = (GraphQLUnmodifiedType)this.typeReferenceCache.get(cacheKey);
        if (cachedType != null) {
            return cachedType;
        }
        for (String part : parts = elementRoot.isEmpty() ? new String[]{} : elementRoot.split("/")) {
            if (type instanceof GraphQLFieldsContainer) {
                if (part.length() <= 0) continue;
                type = GraphQLTypeUtil.unwrapAll((GraphQLType)((GraphQLFieldsContainer)type).getFieldDefinition(part).getType());
                continue;
            }
            throw new IllegalArgumentException("The element root part '" + part + "' wasn't found on type: " + type);
        }
        this.typeReferenceCache.putIfAbsent(cacheKey, type);
        return type;
    }

    public <T> EntityViewSetting<T, CriteriaBuilder<T>> createSetting(Class<T> entityViewClass, DataFetchingEnvironment dataFetchingEnvironment) {
        return this.createSetting(entityViewClass, dataFetchingEnvironment, "");
    }

    public <T> EntityViewSetting<T, CriteriaBuilder<T>> createSetting(Class<T> entityViewClass, DataFetchingEnvironment dataFetchingEnvironment, String elementRoot) {
        KeysetPage keysetPage = this.extractKeysetPage(dataFetchingEnvironment);
        Integer pageSize = null;
        Integer offset = null;
        Integer last = null;
        if (keysetPage != null) {
            pageSize = (Integer)dataFetchingEnvironment.getArgument(this.pageSizeName);
            offset = (Integer)dataFetchingEnvironment.getArgument(this.offsetName);
            if (offset == null && keysetPage.getLowest() != null && keysetPage.getHighest() != null) {
                offset = keysetPage.getFirstResult() + keysetPage.getMaxResults();
            }
            last = (Integer)dataFetchingEnvironment.getArgument(RELAY_LAST_NAME);
        }
        return this.createSetting(entityViewClass, dataFetchingEnvironment, elementRoot, keysetPage, pageSize, last, offset);
    }

    public <T> EntityViewSetting<T, CriteriaBuilder<T>> createSetting(Class<T> entityViewClass, DataFetchingEnvironment dataFetchingEnvironment, String elementRoot, KeysetPage keysetPage, Integer first, Integer last, Integer offset) {
        EntityViewSetting setting;
        boolean forceUseKeyset = false;
        if (keysetPage == null) {
            int pageSize;
            if (first == null) {
                pageSize = Integer.MAX_VALUE;
            } else {
                if (first < 0) {
                    throw new RuntimeException("Illegal negative " + this.pageSizeName + " parameter: " + first);
                }
                pageSize = first;
            }
            setting = pageSize == Integer.MAX_VALUE && offset == null ? EntityViewSetting.create(entityViewClass) : EntityViewSetting.create(entityViewClass, (int)(offset == null ? 0 : offset), (int)pageSize);
        } else {
            int pageSize;
            if (first == null) {
                pageSize = Integer.MAX_VALUE;
            } else {
                if (first < 0) {
                    throw new RuntimeException("Illegal negative " + this.pageSizeName + " parameter: " + first);
                }
                pageSize = first;
            }
            if (last != null) {
                if (last < 0) {
                    throw new RuntimeException("Illegal negative last parameter: " + last);
                }
                if (Integer.MAX_VALUE == pageSize) {
                    pageSize = last;
                    if (offset == null) {
                        forceUseKeyset = true;
                    }
                } else {
                    if (offset == null) {
                        offset = first - last;
                        pageSize = last;
                    } else {
                        offset = offset + (first - last);
                        pageSize = last;
                    }
                    if (offset < 0) {
                        offset = 0;
                    }
                    if (keysetPage.getLowest() != null || keysetPage.getHighest() != null) {
                        forceUseKeyset = true;
                    }
                }
            } else if (offset == null) {
                forceUseKeyset = true;
            } else if (offset < 0) {
                throw new RuntimeException("Illegal negative " + this.offsetName + " parameter: " + offset);
            }
            setting = EntityViewSetting.create(entityViewClass, (int)(offset == null ? 0 : offset), (int)pageSize);
            setting.withKeysetPage(keysetPage);
        }
        if (forceUseKeyset) {
            setting.setProperty("com.blazebit.persistence.view.pagination.force_use_keyset", (Object)true);
        }
        this.applyFetches(dataFetchingEnvironment, setting, elementRoot);
        return setting;
    }

    public KeysetPage extractKeysetPage(DataFetchingEnvironment dataFetchingEnvironment) {
        Integer pageSize = (Integer)dataFetchingEnvironment.getArgument(this.pageSizeName);
        Integer last = (Integer)dataFetchingEnvironment.getArgument(RELAY_LAST_NAME);
        String beforeCursor = (String)dataFetchingEnvironment.getArgument(this.beforeCursorName);
        String afterCursor = (String)dataFetchingEnvironment.getArgument(this.afterCursorName);
        return this.extractKeysetPage(pageSize, last, beforeCursor, afterCursor);
    }

    public KeysetPage extractKeysetPage(Integer first, Integer last, String beforeCursor, String afterCursor) {
        DefaultKeysetPage keysetPage;
        if (first == null && last == null && beforeCursor == null && afterCursor == null) {
            return null;
        }
        if (beforeCursor != null) {
            if (afterCursor != null) {
                throw new RuntimeException("Can't provide both beforeCursor and afterCursor!");
            }
            GraphQLCursor cursor = this.deserialize(beforeCursor);
            keysetPage = new DefaultKeysetPage(cursor.getOffset(), cursor.getPageSize(), (Keyset)new DefaultKeyset(cursor.getTuple()), null);
        } else if (afterCursor != null) {
            if (last != null) {
                keysetPage = new DefaultKeysetPage(0, last.intValue(), (Keyset)new DefaultKeyset(null), null);
            } else {
                GraphQLCursor cursor = this.deserialize(afterCursor);
                keysetPage = new DefaultKeysetPage(cursor.getOffset(), cursor.getPageSize(), null, (Keyset)new DefaultKeyset(cursor.getTuple()));
            }
        } else {
            keysetPage = first != null ? new DefaultKeysetPage(0, first.intValue(), null, null) : new DefaultKeysetPage(0, last.intValue(), (Keyset)new DefaultKeyset(null), null);
        }
        return keysetPage;
    }

    public void applyFetches(DataFetchingEnvironment dataFetchingEnvironment, EntityViewSetting<?, ?> setting) {
        this.applyFetches(dataFetchingEnvironment, setting, "");
    }

    public void applyFetches(DataFetchingEnvironment dataFetchingEnvironment, EntityViewSetting<?, ?> setting, String elementRoot) {
        DataFetchingFieldSelectionSet selectionSet = dataFetchingEnvironment.getSelectionSet();
        GraphQLSchema graphQLSchema = dataFetchingEnvironment.getGraphQLSchema();
        block0: for (SelectedField field : selectionSet.getFields()) {
            String fqFieldName = field.getFullyQualifiedName();
            String[] resolvedFetches = (String[])this.selectedFieldCache.get(fqFieldName);
            if (resolvedFetches != null) {
                for (String resolvedFetch : resolvedFetches) {
                    setting.fetch(resolvedFetch);
                }
                continue;
            }
            if (!GraphQLTypeUtil.isLeaf((GraphQLType)field.getType()) || !field.getQualifiedName().startsWith(elementRoot)) continue;
            String[] fieldParts = fqFieldName.split("/");
            String[] elementRootParts = elementRoot.isEmpty() ? new String[]{} : elementRoot.split("/");
            String fetch = "";
            String currentTypeName = this.getElementTypeName(dataFetchingEnvironment, elementRoot);
            GraphQLNamedType currentType = (GraphQLNamedType)graphQLSchema.getType(currentTypeName);
            Set<DefaultFetchMapping> defaultFetchMappings = this.typeNameToDefaultFetchMappings.get(currentTypeName);
            HashSet<String> fetches = null;
            block2: for (int i = 0; i < fieldParts.length; ++i) {
                Map<String, String> fieldMappings;
                String[] fieldPartComponents = fieldParts[i].split("\\.");
                String typeName = fieldPartComponents[0];
                String fieldName = fieldPartComponents[1];
                if (elementRootParts.length > i && elementRootParts[i].equals(fieldName)) continue;
                if (defaultFetchMappings != null) {
                    Object fields = selectionSet.getImmediateFields();
                    for (int j = 0; j < i; ++j) {
                        fields = this.getSelectedField((List<SelectedField>)fields, fieldParts[j]).getSelectionSet().getImmediateFields();
                    }
                    for (DefaultFetchMapping defaultFetchMapping : defaultFetchMappings) {
                        if (!GraphQLEntityViewSupport.matches(defaultFetchMapping, (List<SelectedField>)fields)) continue;
                        if (fetches == null) {
                            fetches = new HashSet<String>();
                        }
                        fetches.add(this.appendPath(fetch, defaultFetchMapping.getAttributeName()));
                    }
                }
                if (META_FIELDS.contains(fieldName)) {
                    for (String metaFieldTypeName : field.getObjectTypeNames()) {
                        ManagedViewType<?> managedViewType = this.typeNameToViewType.get(metaFieldTypeName);
                        if (!(managedViewType instanceof ViewType)) continue;
                        fetch = this.appendPath(fetch, ((ViewType)managedViewType).getIdAttribute().getName());
                        continue block2;
                    }
                    continue;
                }
                GraphQLOutputType fieldType = this.getFieldType(currentType, fieldName);
                if (typeName.charAt(0) == '[') {
                    if (fieldType == null) {
                        GraphQLUnmodifiedType newType = null;
                        for (String subTypeName : field.getObjectTypeNames()) {
                            GraphQLImplementingType subtype = (GraphQLImplementingType)graphQLSchema.getType(subTypeName);
                            GraphQLUnmodifiedType type = GraphQLTypeUtil.unwrapAll((GraphQLType)subtype.getField(fieldName).getType());
                            if (newType == null) {
                                newType = type;
                                String mappedFieldPart = this.typeNameToFieldMapping.get(subTypeName).get(fieldName);
                                fetch = this.appendPath(fetch, mappedFieldPart);
                                continue;
                            }
                            if (newType == type) continue;
                            throw new IllegalArgumentException("Selection " + fqFieldName + " has multiple result types [" + type + "] and [" + newType + "]");
                        }
                        currentType = newType;
                        continue;
                    }
                    fieldMappings = this.typeNameToFieldMapping.get(currentTypeName);
                    currentTypeName = typeName;
                } else {
                    fieldMappings = this.typeNameToFieldMapping.get(typeName);
                }
                if (fieldMappings == null) break;
                String mappedFieldPart = fieldMappings.get(fieldName);
                if (mappedFieldPart == null) continue block0;
                if (!typeName.equals(currentTypeName) && this.typeNameToViewType.get(typeName) != this.typeNameToViewType.get(currentTypeName)) {
                    fieldType = this.getFieldType((GraphQLNamedType)graphQLSchema.getType(typeName), fieldName);
                }
                currentType = GraphQLTypeUtil.unwrapAll((GraphQLType)fieldType);
                currentTypeName = currentType.getName();
                defaultFetchMappings = this.typeNameToDefaultFetchMappings.get(currentTypeName);
                fetch = this.appendPath(fetch, mappedFieldPart);
            }
            if (fetch.isEmpty()) continue;
            if (fetches == null) {
                setting.fetch(fetch);
                this.selectedFieldCache.putIfAbsent(fqFieldName, new String[]{fetch});
                continue;
            }
            fetches.add(fetch);
            for (String f : fetches) {
                setting.fetch(f);
            }
            this.selectedFieldCache.putIfAbsent(fqFieldName, fetches.toArray(new String[0]));
        }
    }

    private SelectedField getSelectedField(List<SelectedField> fields, String qualifiedName) {
        for (SelectedField field : fields) {
            if (!field.getFullyQualifiedName().equals(qualifiedName)) continue;
            return field;
        }
        throw new IllegalArgumentException("No such field: " + qualifiedName + " in " + fields);
    }

    private static boolean matches(DefaultFetchMapping defaultFetchMapping, List<SelectedField> fields) {
        if (defaultFetchMapping.getIfFieldSelected().isEmpty()) {
            return true;
        }
        for (SelectedField field : fields) {
            if (!defaultFetchMapping.getIfFieldSelected().equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    private GraphQLOutputType getFieldType(GraphQLNamedType currentType, String fieldName) {
        if (currentType instanceof GraphQLImplementingType) {
            GraphQLFieldDefinition currentTypeField = ((GraphQLImplementingType)currentType).getField(fieldName);
            return currentTypeField == null ? null : currentTypeField.getType();
        }
        GraphQLUnionType currentUnionType = (GraphQLUnionType)currentType;
        GraphQLOutputType resolvedFieldType = null;
        for (GraphQLNamedOutputType type : currentUnionType.getTypes()) {
            GraphQLOutputType fieldType = this.getFieldType((GraphQLNamedType)type, fieldName);
            if (resolvedFieldType == null) {
                resolvedFieldType = fieldType;
                continue;
            }
            if (fieldType == null || resolvedFieldType == fieldType) continue;
            throw new IllegalArgumentException("GraphQL type [" + currentType.getName() + "] has field [" + fieldName + "] with multiple result types [" + fieldType + "] and [" + resolvedFieldType + "]");
        }
        return resolvedFieldType;
    }

    private String appendPath(String fetch, String field) {
        if (fetch.isEmpty()) {
            return field;
        }
        return fetch + "." + field;
    }

    protected GraphQLCursor deserialize(String beforeCursor) {
        GraphQLCursor graphQLCursor;
        GraphQLCursorObjectInputStream ois = new GraphQLCursorObjectInputStream(Base64.getDecoder().wrap(new ByteArrayInputStream(beforeCursor.getBytes())), this.serializableBasicTypes);
        try {
            int offset = ois.read();
            int pageSize = ois.read();
            Serializable[] tuple = (Serializable[])ois.readObject();
            graphQLCursor = new GraphQLCursor(offset, pageSize, tuple);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't read cursor", e);
            }
        }
        ois.close();
        return graphQLCursor;
    }

    protected byte[] serializeCursor(int offset, int pageSize, Serializable[] tuple) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.write(offset);
            oos.write(pageSize);
            oos.writeObject(tuple);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public Class<?> getEntityViewClass(String typeName) {
        ManagedViewType<?> entityViewClass = this.typeNameToViewType.get(typeName);
        if (entityViewClass == null) {
            throw new IllegalArgumentException("No entity view type is registered for the name: " + typeName);
        }
        return entityViewClass.getJavaType();
    }

    public <T> Connection<T> createRelayConnection(List<T> list) {
        KeysetPage keysetPage;
        boolean hasNextPage;
        boolean hasPreviousPage;
        PagedList data;
        ArrayList<DefaultEdge> edges = new ArrayList<DefaultEdge>(list.size());
        if (list instanceof PagedList) {
            data = (PagedList)list;
            hasPreviousPage = data.getFirstResult() != 0;
            hasNextPage = data.getTotalSize() == -1L || (long)(data.getFirstResult() + data.getMaxResults()) < data.getTotalSize();
            keysetPage = data.getKeysetPage();
        } else {
            hasPreviousPage = true;
            hasNextPage = true;
            keysetPage = null;
        }
        if (keysetPage == null) {
            for (int i = 0; i < list.size(); ++i) {
                edges.add(new DefaultEdge(list.get(i), (ConnectionCursor)new DefaultConnectionCursor(Integer.toString(i + 1))));
            }
        } else {
            data = (PagedList)list;
            List keysets = keysetPage.getKeysets();
            int listSize = list.size();
            if (listSize != 0 && keysets.size() != listSize) {
                int end = listSize - 1;
                edges.add(new DefaultEdge(list.get(0), (ConnectionCursor)new DefaultConnectionCursor(Base64.getEncoder().encodeToString(this.serializeCursor(data.getFirstResult(), data.getMaxResults(), keysetPage.getLowest().getTuple())))));
                for (int i = 1; i < end; ++i) {
                    T node = list.get(i);
                    edges.add(new DefaultEdge(node, (ConnectionCursor)new DefaultConnectionCursor(Integer.toString(i + 1))));
                }
                edges.add(new DefaultEdge(list.get(end), (ConnectionCursor)new DefaultConnectionCursor(Base64.getEncoder().encodeToString(this.serializeCursor(data.getFirstResult(), data.getMaxResults(), keysetPage.getHighest().getTuple())))));
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    T node = list.get(i);
                    edges.add(new DefaultEdge(node, (ConnectionCursor)new DefaultConnectionCursor(Base64.getEncoder().encodeToString(this.serializeCursor(data.getFirstResult(), data.getMaxResults(), ((Keyset)keysets.get(i)).getTuple())))));
                }
            }
        }
        DefaultPageInfo pageInfo = edges.isEmpty() ? new DefaultPageInfo(null, null, hasPreviousPage, hasNextPage) : new DefaultPageInfo(((Edge)edges.get(0)).getCursor(), ((Edge)edges.get(edges.size() - 1)).getCursor(), hasPreviousPage, hasNextPage);
        return new DefaultConnection(edges, (PageInfo)pageInfo);
    }

    private static class TypeRootCacheKey {
        private final GraphQLType baseType;
        private final String root;

        public TypeRootCacheKey(GraphQLType baseType, String root) {
            this.baseType = baseType;
            this.root = root;
        }

        public boolean equals(Object o) {
            if (this.getClass() != o.getClass()) {
                return false;
            }
            TypeRootCacheKey that = (TypeRootCacheKey)o;
            return this.baseType.equals(that.baseType) && this.root.equals(that.root);
        }

        public int hashCode() {
            int result = this.baseType.hashCode();
            result = 31 * result + this.root.hashCode();
            return result;
        }
    }
}

