/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.graphql;

import com.blazebit.persistence.Keyset;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.integration.graphql.GraphQLRelayEdge;
import com.blazebit.persistence.integration.graphql.GraphQLRelayPageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;

public class GraphQLRelayConnection<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<GraphQLRelayEdge<T>> edges;
    private final GraphQLRelayPageInfo pageInfo;
    private final long totalCount;

    public GraphQLRelayConnection() {
        this.edges = Collections.emptyList();
        this.pageInfo = GraphQLRelayPageInfo.EMPTY;
        this.totalCount = 0L;
    }

    public GraphQLRelayConnection(List<T> list) {
        if (list instanceof PagedList) {
            PagedList data = (PagedList)list;
            this.pageInfo = new GraphQLRelayPageInfo(data);
            this.totalCount = data.getTotalSize();
        } else {
            this.pageInfo = GraphQLRelayPageInfo.EMPTY;
            this.totalCount = list.size();
        }
        this.edges = GraphQLRelayConnection.createEdges(list, this.pageInfo);
    }

    public GraphQLRelayConnection(PagedList<T> list) {
        this.pageInfo = new GraphQLRelayPageInfo(list);
        this.totalCount = list.getTotalSize();
        this.edges = GraphQLRelayConnection.createEdges(list, this.pageInfo);
    }

    private static <X> List<GraphQLRelayEdge<X>> createEdges(List<X> list, GraphQLRelayPageInfo pageInfo) {
        ArrayList<GraphQLRelayEdge<Object>> edges;
        List keysets;
        if (list instanceof PagedList && pageInfo != null && ((PagedList)list).getKeysetPage() != null && (keysets = ((PagedList)list).getKeysetPage().getKeysets()).size() == list.size()) {
            PagedList pagedList = (PagedList)list;
            int offset = pagedList.getFirstResult();
            int pageSize = pagedList.getMaxResults();
            edges = new ArrayList(list.size());
            for (int i = 0; i < list.size(); ++i) {
                X node = list.get(i);
                edges.add(new GraphQLRelayEdge<X>(Base64.getEncoder().encodeToString(pageInfo.serialize(offset, pageSize, ((Keyset)keysets.get(i)).getTuple())), node));
            }
        } else {
            edges = new ArrayList<GraphQLRelayEdge<X>>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                X node = list.get(i);
                edges.add(new GraphQLRelayEdge<X>(null, node));
            }
        }
        return edges;
    }

    public List<GraphQLRelayEdge<T>> getEdges() {
        return this.edges;
    }

    public GraphQLRelayPageInfo getPageInfo() {
        return this.pageInfo;
    }

    public long getTotalCount() {
        return this.totalCount;
    }
}

