/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.graphql;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KTypeProjection;

class KotlinSupport {
    private static final KotlinSupportImpl INSTANCE;

    private KotlinSupport() {
    }

    static boolean isKotlinNotNull(Method method) {
        return INSTANCE != null && INSTANCE.isKotlinNotNull(method);
    }

    static boolean isKotlinTypeArgumentNotNull(Method method, int typeArgumentIndex) {
        return INSTANCE != null && INSTANCE.isKotlinTypeArgumentNotNull(method, typeArgumentIndex);
    }

    static {
        KotlinSupportImpl instance;
        try {
            JvmClassMappingKt.getKotlinClass(Integer.class);
            instance = new KotlinSupportImpl();
        }
        catch (Throwable e) {
            instance = null;
        }
        INSTANCE = instance;
    }

    private static class KotlinSupportImpl {
        private KotlinSupportImpl() {
        }

        boolean isKotlinNotNull(Method method) {
            if (method.getDeclaringClass().getAnnotation(Metadata.class) != null) {
                KClass kotlinClass = JvmClassMappingKt.getKotlinClass(method.getDeclaringClass());
                String propertyName = null;
                for (KCallable member : kotlinClass.getMembers()) {
                    if (member instanceof KProperty) {
                        if (propertyName == null) {
                            String methodName = method.getName();
                            propertyName = methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) ? Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3) : (methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) ? Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4) : methodName);
                        }
                        if (!propertyName.equals(member.getName())) continue;
                        return !member.getReturnType().isMarkedNullable();
                    }
                    if (!member.getParameters().isEmpty() || !method.getName().equals(member.getName())) continue;
                    return !member.getReturnType().isMarkedNullable();
                }
            }
            return false;
        }

        boolean isKotlinTypeArgumentNotNull(Method method, int typeArgumentIndex) {
            if (method.getDeclaringClass().getAnnotation(Metadata.class) != null) {
                KClass kotlinClass = JvmClassMappingKt.getKotlinClass(method.getDeclaringClass());
                String propertyName = null;
                for (KCallable member : kotlinClass.getMembers()) {
                    KTypeProjection kTypeProjection;
                    if (member instanceof KProperty) {
                        if (propertyName == null) {
                            String methodName = method.getName();
                            propertyName = methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) ? Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3) : (methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) ? Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4) : methodName);
                        }
                        if (!propertyName.equals(member.getName())) continue;
                        kTypeProjection = (KTypeProjection)member.getReturnType().getArguments().get(typeArgumentIndex);
                        return kTypeProjection.getType() != null && !kTypeProjection.getType().isMarkedNullable();
                    }
                    if (!member.getParameters().isEmpty() || !method.getName().equals(member.getName())) continue;
                    kTypeProjection = (KTypeProjection)member.getReturnType().getArguments().get(typeArgumentIndex);
                    return kTypeProjection.getType() != null && !kTypeProjection.getType().isMarkedNullable();
                }
            }
            return false;
        }
    }
}

