/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.integration.hibernate.Hibernate56LimitHandlingDialect;
import com.blazebit.persistence.integration.hibernate.Hibernate56SessionFactoryInvocationHandler;
import com.blazebit.persistence.integration.hibernate.Hibernate56SessionInvocationHandler;
import com.blazebit.persistence.integration.hibernate.JdbcCoordinatorInvocationHandler;
import com.blazebit.persistence.integration.hibernate.StatementPreparerImpl;
import com.blazebit.persistence.integration.hibernate.base.HibernateAccess;
import com.blazebit.persistence.integration.hibernate.base.HibernateReturningResult;
import com.blazebit.persistence.integration.hibernate.base.ScrollableResultsIterator;
import com.blazebit.persistence.spi.DbmsDialect;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.event.spi.EventSource;
import org.hibernate.hql.internal.ast.ParameterTranslationsImpl;
import org.hibernate.hql.internal.ast.exec.BasicExecutor;
import org.hibernate.hql.internal.ast.exec.StatementExecutor;
import org.hibernate.hql.spi.ParameterTranslations;
import org.hibernate.loader.hql.QueryLoader;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.query.internal.AbstractProducedQuery;
import org.hibernate.query.internal.QueryParameterBindingsImpl;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.type.Type;

public class Hibernate56Access
implements HibernateAccess {
    private static final Method DO_EXECUTE_METHOD;
    private static final Method DO_EXECUTE_METHOD_NEW;
    private static final Constructor<ParameterTranslationsImpl> PARAMETER_TRANSLATIONS_CONSTRUCTOR;

    public SessionImplementor wrapSession(SessionImplementor session, DbmsDialect dbmsDialect, String[][] columns, int[] returningSqlTypes, HibernateReturningResult<?> returningResult) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        Object jdbcCoordinatorProxy = Proxy.newProxyInstance(jdbcCoordinator.getClass().getClassLoader(), new Class[]{JdbcCoordinator.class}, (InvocationHandler)new JdbcCoordinatorInvocationHandler(jdbcCoordinator, new StatementPreparerImpl(jdbcCoordinator, session.getFactory(), dbmsDialect, columns, returningSqlTypes, returningResult)));
        Object sessionProxy = Proxy.newProxyInstance(session.getClass().getClassLoader(), new Class[]{SessionImplementor.class, EventSource.class}, (InvocationHandler)new Hibernate56SessionInvocationHandler(session, jdbcCoordinatorProxy));
        return (SessionImplementor)sessionProxy;
    }

    public SessionFactoryImplementor wrapSessionFactory(SessionFactoryImplementor sessionFactory, DbmsDialect dbmsDialect) {
        Hibernate56LimitHandlingDialect dialectProxy = new Hibernate56LimitHandlingDialect(sessionFactory.getDialect(), dbmsDialect);
        Object sessionFactoryProxy = Proxy.newProxyInstance(sessionFactory.getClass().getClassLoader(), new Class[]{SessionFactoryImplementor.class}, (InvocationHandler)new Hibernate56SessionFactoryInvocationHandler(sessionFactory, (Object)dialectProxy));
        return (SessionFactoryImplementor)sessionFactoryProxy;
    }

    public void checkTransactionSynchStatus(SessionImplementor session) {
        TransactionCoordinator coordinator = session.getTransactionCoordinator();
        coordinator.pulse();
        if (coordinator instanceof JtaTransactionCoordinatorImpl) {
            ((JtaTransactionCoordinatorImpl)coordinator).getSynchronizationCallbackCoordinator().processAnyDelayedAfterCompletion();
        }
    }

    public void afterTransaction(SessionImplementor session, boolean success) {
        TransactionCoordinator coordinator = session.getTransactionCoordinator();
        if (!session.isTransactionInProgress()) {
            session.getJdbcCoordinator().afterTransaction();
        }
        if (coordinator instanceof JtaTransactionCoordinatorImpl) {
            ((JtaTransactionCoordinatorImpl)coordinator).getSynchronizationCallbackCoordinator().processAnyDelayedAfterCompletion();
        }
    }

    public List<Object[]> list(QueryLoader queryLoader, SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        return queryLoader.list((SharedSessionContractImplementor)sessionImplementor, queryParameters);
    }

    public List<Object> performList(HQLQueryPlan queryPlan, SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        return queryPlan.performList(queryParameters, (SharedSessionContractImplementor)sessionImplementor);
    }

    public Stream<Object> performStream(HQLQueryPlan queryPlan, SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        final ScrollableResultsImplementor scrollableResults = queryPlan.performScroll(queryParameters, (SharedSessionContractImplementor)sessionImplementor);
        ScrollableResultsIterator iterator = new ScrollableResultsIterator((ScrollableResults)scrollableResults);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        return (Stream)StreamSupport.stream(spliterator, false).onClose(new Runnable(){

            @Override
            public void run() {
                scrollableResults.close();
            }
        });
    }

    public int performExecuteUpdate(HQLQueryPlan queryPlan, SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        return queryPlan.performExecuteUpdate(queryParameters, (SharedSessionContractImplementor)sessionImplementor);
    }

    public void doExecute(StatementExecutor executor, String delete, QueryParameters parameters, SessionImplementor session, List<ParameterSpecification> parameterSpecifications) {
        try {
            if (DO_EXECUTE_METHOD == null) {
                DO_EXECUTE_METHOD_NEW.invoke((Object)executor, delete, parameters, parameterSpecifications, session);
            } else {
                DO_EXECUTE_METHOD.invoke((Object)executor, parameters, session, delete, parameterSpecifications);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public QueryParameters getQueryParameters(Query hibernateQuery, Map<String, TypedValue> namedParams) {
        return ((AbstractProducedQuery)hibernateQuery).getQueryParameters();
    }

    public Map<String, TypedValue> getNamedParams(Query hibernateQuery) {
        QueryParameterBindingsImpl queryParameterBindings = (QueryParameterBindingsImpl)hibernateQuery.unwrap(QueryParameterBindingsImpl.class);
        return queryParameterBindings.collectNamedParameterBindings();
    }

    public String expandParameterLists(SessionImplementor session, Query hibernateQuery, Map<String, TypedValue> namedParamsCopy) {
        QueryParameterBindingsImpl queryParameterBindings = (QueryParameterBindingsImpl)hibernateQuery.unwrap(QueryParameterBindingsImpl.class);
        SharedSessionContractImplementor producer = (SharedSessionContractImplementor)((QueryImplementor)hibernateQuery).getProducer();
        String query = hibernateQuery.getQueryString();
        query = queryParameterBindings.expandListValuedParameters(query, producer);
        return query;
    }

    private ExceptionConverter getExceptionConverter(EntityManager em) {
        return ((SharedSessionContractImplementor)em.unwrap(SharedSessionContractImplementor.class)).getExceptionConverter();
    }

    public RuntimeException convert(EntityManager em, HibernateException e) {
        return this.getExceptionConverter(em).convert(e);
    }

    public void handlePersistenceException(EntityManager em, PersistenceException e) {
        this.getExceptionConverter(em).convert((RuntimeException)e);
    }

    public void throwPersistenceException(EntityManager em, HibernateException e) {
        this.getExceptionConverter(em).convert(e);
    }

    public QueryParameters createQueryParameters(Type[] positionalParameterTypes, Object[] positionalParameterValues, Map<String, TypedValue> namedParameters, LockOptions lockOptions, RowSelection rowSelection, boolean isReadOnlyInitialized, boolean readOnly, boolean cacheable, String cacheRegion, String comment, List<String> queryHints, Serializable[] collectionKeys) {
        return new QueryParameters(positionalParameterTypes, positionalParameterValues, namedParameters, lockOptions, rowSelection, isReadOnlyInitialized, readOnly, cacheable, cacheRegion, comment, queryHints, collectionKeys, null);
    }

    public ParameterTranslations createParameterTranslations(List<ParameterSpecification> queryParameterSpecifications) {
        try {
            return (ParameterTranslations)PARAMETER_TRANSLATIONS_CONSTRUCTOR.newInstance(queryParameterSpecifications);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method m = null;
        Method mNew = null;
        try {
            m = BasicExecutor.class.getDeclaredMethod("doExecute", QueryParameters.class, SharedSessionContractImplementor.class, String.class, List.class);
            m.setAccessible(true);
        }
        catch (Exception e) {
            try {
                mNew = BasicExecutor.class.getDeclaredMethod("doExecute", String.class, QueryParameters.class, List.class, SharedSessionContractImplementor.class);
                mNew.setAccessible(true);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        DO_EXECUTE_METHOD = m;
        DO_EXECUTE_METHOD_NEW = mNew;
        try {
            Constructor c = ParameterTranslationsImpl.class.getDeclaredConstructor(List.class);
            c.setAccessible(true);
            PARAMETER_TRANSLATIONS_CONSTRUCTOR = c;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

