/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.integration.hibernate.Hibernate5EntityTransactionSynchronizationStrategy;
import com.blazebit.persistence.integration.hibernate.Hibernate5JtaPlatformTransactionSynchronizationStrategy;
import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.TransactionAccessFactory;
import jakarta.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class Hibernate5TransactionAccessFactory
implements TransactionAccessFactory {
    public TransactionAccess createTransactionAccess(EntityManager entityManager) {
        JtaPlatform jtaPlatform = Hibernate5TransactionAccessFactory.getHibernate5JtaPlatformPresent(entityManager);
        if (jtaPlatform == null || NoJtaPlatform.class == jtaPlatform.getClass()) {
            return new Hibernate5EntityTransactionSynchronizationStrategy(entityManager);
        }
        return new Hibernate5JtaPlatformTransactionSynchronizationStrategy(jtaPlatform);
    }

    public int getPriority() {
        return 100;
    }

    private static JtaPlatform getHibernate5JtaPlatformPresent(EntityManager em) {
        Session hibernateSession = (Session)em.unwrap(Session.class);
        SessionFactory hibernateSessionFactory = hibernateSession.getSessionFactory();
        ServiceRegistryImplementor hibernateServiceRegistry = ((SessionFactoryImplementor)hibernateSessionFactory).getServiceRegistry();
        return (JtaPlatform)hibernateServiceRegistry.getService(JtaPlatform.class);
    }
}

