/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base;

import antlr.collections.AST;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.integration.hibernate.base.HibernateAccess;
import com.blazebit.persistence.integration.hibernate.base.HibernateReturningResult;
import com.blazebit.persistence.integration.hibernate.base.QuoteMode;
import com.blazebit.persistence.spi.ConfigurationSource;
import com.blazebit.persistence.spi.CteQueryWrapper;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.ServiceProvider;
import com.blazebit.reflection.ReflectionUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.hql.internal.QueryExecutionRequestException;
import org.hibernate.hql.internal.ast.exec.BasicExecutor;
import org.hibernate.hql.internal.ast.exec.DeleteExecutor;
import org.hibernate.hql.internal.ast.exec.StatementExecutor;
import org.hibernate.hql.internal.ast.tree.AbstractStatement;
import org.hibernate.hql.internal.ast.tree.DotNode;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.InsertStatement;
import org.hibernate.hql.internal.ast.tree.QueryNode;
import org.hibernate.hql.internal.ast.tree.SelectClause;
import org.hibernate.hql.spi.ParameterTranslations;
import org.hibernate.hql.spi.QueryTranslator;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.loader.hql.QueryLoader;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;

public class HibernateExtendedQuerySupport
implements ExtendedQuerySupport {
    private static final Logger LOG = Logger.getLogger(HibernateExtendedQuerySupport.class.getName());
    private static final String[] KNOWN_STATEMENTS = new String[]{"select ", "insert ", "update ", "delete "};
    private final ConcurrentMap<SessionFactoryImplementor, BoundedConcurrentHashMap<QueryPlanCacheKey, QueryPlanCacheValue>> queryPlanCachesCache = new ConcurrentHashMap<SessionFactoryImplementor, BoundedConcurrentHashMap<QueryPlanCacheKey, QueryPlanCacheValue>>();
    private final ConcurrentMap<FieldKey, Field> fieldCache = new ConcurrentHashMap<FieldKey, Field>();
    private final HibernateAccess hibernateAccess;

    public HibernateExtendedQuerySupport() {
        Iterator<HibernateAccess> serviceIter = ServiceLoader.load(HibernateAccess.class).iterator();
        if (!serviceIter.hasNext()) {
            throw new IllegalStateException("Hibernate integration was not found on the class path!");
        }
        this.hibernateAccess = serviceIter.next();
    }

    public boolean supportsAdvancedSql() {
        return true;
    }

    public boolean needsExampleQueryForAdvancedDml() {
        return false;
    }

    public boolean applyFirstResultMaxResults(Query query, int firstResult, int maxResults) {
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return false;
    }

    public String getSql(EntityManager em, Query query) {
        String[] sqls;
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        HQLQueryPlan queryPlan = this.getOriginalQueryPlan(session, query);
        if (queryPlan.getTranslators().length > 1) {
            throw new IllegalArgumentException("No support for multiple translators yet!");
        }
        QueryTranslator queryTranslator = queryPlan.getTranslators()[0];
        if (queryTranslator.isManipulationStatement()) {
            StatementExecutor executor = this.getStatementExecutor(queryTranslator);
            if (!(executor instanceof BasicExecutor)) {
                throw new IllegalArgumentException("Using polymorphic deletes/updates with CTEs is not yet supported");
            }
            sqls = executor.getSqlStatements();
        } else {
            sqls = queryPlan.getSqlStrings();
        }
        for (int i = 0; i < sqls.length; ++i) {
            if (sqls[i] == null) continue;
            return sqls[i];
        }
        return null;
    }

    public boolean getSqlContainsLimit() {
        return false;
    }

    public List<String> getCascadingDeleteSql(EntityManager em, Query query) {
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        HQLQueryPlan queryPlan = this.getOriginalQueryPlan(session, query);
        if (queryPlan.getTranslators().length > 1) {
            throw new IllegalArgumentException("No support for multiple translators yet!");
        }
        QueryTranslator queryTranslator = queryPlan.getTranslators()[0];
        StatementExecutor executor = this.getStatementExecutor(queryTranslator);
        if (executor == null || !(executor instanceof DeleteExecutor)) {
            return Collections.EMPTY_LIST;
        }
        List deletes = (List)this.getField(executor, "deletes");
        if (deletes == null) {
            return Collections.EMPTY_LIST;
        }
        return deletes;
    }

    private HQLQueryPlan getOriginalQueryPlan(SessionImplementor session, Query query) {
        SessionFactoryImplementor sfi = session.getFactory();
        org.hibernate.Query hibernateQuery = (org.hibernate.Query)query.unwrap(org.hibernate.Query.class);
        HashMap<String, TypedValue> namedParams = new HashMap<String, TypedValue>(this.hibernateAccess.getNamedParams(hibernateQuery));
        String queryString = this.hibernateAccess.expandParameterLists(session, hibernateQuery, namedParams);
        return sfi.getQueryPlanCache().getHQLQueryPlan(queryString, false, Collections.EMPTY_MAP);
    }

    public String getSqlAlias(EntityManager em, Query query, String alias, int queryPartNumber) {
        FromElement fromElement = this.getSqlFromElement(em, query, alias, queryPartNumber);
        if (fromElement == null) {
            throw new IllegalArgumentException("The alias " + alias + " could not be found in the query: " + query);
        }
        return fromElement.getTableAlias();
    }

    private FromElement getSqlFromElement(EntityManager em, Query query, String alias, int queryPartNumber) {
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        HQLQueryPlan plan = this.getOriginalQueryPlan(session, query);
        if (plan.getTranslators().length > 1) {
            throw new IllegalArgumentException("No support for multiple translators yet!");
        }
        QueryTranslator translator = plan.getTranslators()[0];
        AbstractStatement statement = (AbstractStatement)this.getField(translator, "sqlAst");
        QueryNode queryNode = statement instanceof QueryNode ? (QueryNode)statement : (statement instanceof InsertStatement ? (QueryNode)((InsertStatement)statement).getIntoClause().getNextSibling() : (QueryNode)statement.getNextSibling());
        return queryNode.getFromClause().getFromElement(alias);
    }

    public ExtendedQuerySupport.SqlFromInfo getSqlFromInfo(EntityManager em, Query query, String alias, int queryPartNumber) {
        FromElement fromElement = this.getSqlFromElement(em, query, alias, queryPartNumber);
        if (fromElement == null) {
            throw new IllegalArgumentException("The alias " + alias + " could not be found in the query: " + query);
        }
        String sql = this.getSql(em, query);
        final String text = fromElement.getText();
        final String tableAlias = fromElement.getTableAlias();
        final int startIndex = sql.indexOf(text);
        return new ExtendedQuerySupport.SqlFromInfo(){

            public String getAlias() {
                return tableAlias;
            }

            public int getFromStartIndex() {
                return startIndex;
            }

            public int getFromEndIndex() {
                return startIndex + text.length();
            }
        };
    }

    public int getSqlSelectAliasPosition(EntityManager em, Query query, String alias) {
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        HQLQueryPlan plan = this.getOriginalQueryPlan(session, query);
        if (plan.getTranslators().length > 1) {
            throw new IllegalArgumentException("No support for multiple translators yet!");
        }
        QueryTranslator translator = plan.getTranslators()[0];
        try {
            QueryNode queryNode = (QueryNode)this.getField(translator, "sqlAst");
            String[] aliases = queryNode.getSelectClause().getQueryReturnAliases();
            for (int i = 0; i < aliases.length; ++i) {
                if (!alias.equals(aliases[i])) continue;
                return i + 1;
            }
            return -1;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    public int getSqlSelectAttributePosition(EntityManager em, Query query, String expression) {
        if (expression.contains(".")) {
            throw new UnsupportedOperationException("Embeddables are not yet supported!");
        }
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        HQLQueryPlan plan = this.getOriginalQueryPlan(session, query);
        if (plan.getTranslators().length > 1) {
            throw new IllegalArgumentException("No support for multiple translators yet!");
        }
        QueryTranslator translator = plan.getTranslators()[0];
        try {
            QueryNode queryNode = (QueryNode)this.getField(translator, "sqlAst");
            SelectClause selectClause = queryNode.getSelectClause();
            Type[] queryReturnTypes = selectClause.getQueryReturnTypes();
            boolean found = false;
            int position = 1;
            for (int i = 0; i < queryReturnTypes.length; ++i) {
                Type t = queryReturnTypes[i];
                if (t instanceof ManyToOneType) {
                    ManyToOneType manyToOneType = (ManyToOneType)t;
                    AbstractEntityPersister persister = (AbstractEntityPersister)session.getFactory().getEntityPersister(manyToOneType.getAssociatedEntityName());
                    int propertyIndex = persister.getPropertyIndex(expression);
                    found = true;
                    for (int j = 0; j < propertyIndex; ++j) {
                        position += persister.getPropertyColumnNames(j).length;
                    }
                    ++position;
                    continue;
                }
                ++position;
            }
            if (found) {
                return position;
            }
            for (AST selectItem = selectClause.getFirstChild(); selectItem != null && (selectItem.getType() == 16 || selectItem.getType() == 4); selectItem = selectItem.getNextSibling()) {
            }
            position = 1;
            for (AST n = selectItem; n != null; n = n.getNextSibling()) {
                DotNode dot;
                if (n instanceof DotNode && expression.equals((dot = (DotNode)n).getPropertyPath())) {
                    if (dot.getText().contains(",")) {
                        throw new IllegalStateException("Can't order by the embeddable: " + expression);
                    }
                    found = true;
                    break;
                }
                ++position;
            }
            if (found) {
                return position;
            }
            return -1;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    public List getResultList(ServiceProvider serviceProvider, List<Query> participatingQueries, Query query, String sqlOverride, boolean queryPlanCacheEnabled) {
        EntityManager em = (EntityManager)serviceProvider.getService(EntityManager.class);
        try {
            return this.list(serviceProvider, em, participatingQueries, query, sqlOverride, queryPlanCacheEnabled);
        }
        catch (QueryExecutionRequestException he) {
            LOG.severe("Could not execute the following SQL query: " + sqlOverride);
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            LOG.severe("Could not execute the following SQL query: " + sqlOverride);
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            LOG.severe("Could not execute the following SQL query: " + sqlOverride);
            throw this.hibernateAccess.convert(em, he);
        }
    }

    public Object getResultStream(ServiceProvider serviceProvider, List<Query> participatingQueries, Query query, String sqlOverride, boolean queryPlanCacheEnabled) {
        EntityManager em = (EntityManager)serviceProvider.getService(EntityManager.class);
        try {
            return this.stream(serviceProvider, em, participatingQueries, query, sqlOverride, queryPlanCacheEnabled);
        }
        catch (QueryExecutionRequestException he) {
            LOG.severe("Could not execute the following SQL query: " + sqlOverride);
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            LOG.severe("Could not execute the following SQL query: " + sqlOverride);
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            LOG.severe("Could not execute the following SQL query: " + sqlOverride);
            throw this.hibernateAccess.convert(em, he);
        }
    }

    public Object getSingleResult(ServiceProvider serviceProvider, List<Query> participatingQueries, Query query, String sqlOverride, boolean queryPlanCacheEnabled) {
        EntityManager em = (EntityManager)serviceProvider.getService(EntityManager.class);
        try {
            List result = this.list(serviceProvider, em, participatingQueries, query, sqlOverride, queryPlanCacheEnabled);
            if (result.size() == 0) {
                NoResultException nre = new NoResultException("No entity found for query");
                this.hibernateAccess.handlePersistenceException(em, (PersistenceException)nre);
                throw nre;
            }
            if (result.size() > 1) {
                HashSet uniqueResult = new HashSet(result);
                if (uniqueResult.size() > 1) {
                    NonUniqueResultException nure = new NonUniqueResultException("result returns more than one element");
                    this.hibernateAccess.handlePersistenceException(em, (PersistenceException)nure);
                    throw nure;
                }
                return uniqueResult.iterator().next();
            }
            return result.get(0);
        }
        catch (QueryExecutionRequestException he) {
            LOG.severe("Could not execute the following SQL query: " + sqlOverride);
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            LOG.severe("Could not execute the following SQL query: " + sqlOverride);
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            LOG.severe("Could not execute the following SQL query: " + sqlOverride);
            throw this.hibernateAccess.convert(em, he);
        }
    }

    private List list(ServiceProvider serviceProvider, EntityManager em, List<Query> participatingQueries, Query query, String finalSql, boolean queryPlanCacheEnabled) {
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        SessionFactoryImplementor sfi = session.getFactory();
        if (session.isClosed()) {
            throw new PersistenceException("Entity manager is closed!");
        }
        ArrayList<String> queryStrings = new ArrayList<String>(participatingQueries.size());
        HashSet<String> querySpaces = new HashSet<String>();
        QueryParamEntry queryParametersEntry = this.createQueryParameters(em, query, participatingQueries, queryStrings, querySpaces);
        QueryParameters queryParameters = queryParametersEntry.queryParameters;
        QueryPlanCacheKey cacheKey = queryPlanCacheEnabled ? this.createCacheKey(finalSql, participatingQueries, queryStrings) : null;
        CacheEntry<QueryPlanCacheValue> queryPlanEntry = this.getQueryPlan(sfi, query, cacheKey);
        QueryPlanCacheValue queryPlanCacheValue = queryPlanEntry.getValue();
        HQLQueryPlan queryPlan = queryPlanCacheValue.getQueryPlan();
        if (!queryPlanEntry.isFromCache()) {
            this.prepareQueryPlan(queryPlan, queryParametersEntry.specifications, finalSql, session, null, false, (DbmsDialect)serviceProvider.getService(DbmsDialect.class));
            if (queryPlanCacheEnabled) {
                this.putQueryPlanIfAbsent(sfi, cacheKey, queryPlanCacheValue);
            }
        }
        this.autoFlush(querySpaces, session);
        return this.hibernateAccess.performList(queryPlan, session, queryParameters);
    }

    private Object stream(ServiceProvider serviceProvider, EntityManager em, List<Query> participatingQueries, Query query, String finalSql, boolean queryPlanCacheEnabled) {
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        SessionFactoryImplementor sfi = session.getFactory();
        if (session.isClosed()) {
            throw new PersistenceException("Entity manager is closed!");
        }
        ArrayList<String> queryStrings = new ArrayList<String>(participatingQueries.size());
        HashSet<String> querySpaces = new HashSet<String>();
        QueryParamEntry queryParametersEntry = this.createQueryParameters(em, query, participatingQueries, queryStrings, querySpaces);
        QueryParameters queryParameters = queryParametersEntry.queryParameters;
        QueryPlanCacheKey cacheKey = queryPlanCacheEnabled ? this.createCacheKey(finalSql, participatingQueries, queryStrings) : null;
        CacheEntry<QueryPlanCacheValue> queryPlanEntry = this.getQueryPlan(sfi, query, cacheKey);
        QueryPlanCacheValue queryPlanCacheValue = queryPlanEntry.getValue();
        HQLQueryPlan queryPlan = queryPlanCacheValue.getQueryPlan();
        if (!queryPlanEntry.isFromCache()) {
            this.prepareQueryPlan(queryPlan, queryParametersEntry.specifications, finalSql, session, null, false, (DbmsDialect)serviceProvider.getService(DbmsDialect.class));
            if (queryPlanCacheEnabled) {
                this.putQueryPlanIfAbsent(sfi, cacheKey, queryPlanCacheValue);
            }
        }
        this.autoFlush(querySpaces, session);
        return this.hibernateAccess.performStream(queryPlan, session, queryParameters);
    }

    public int executeUpdate(ServiceProvider serviceProvider, List<Query> participatingQueries, Query baseQuery, Query query, String finalSql, boolean queryPlanCacheEnabled) {
        int[] returningColumnTypes;
        String[][] returningColumns;
        DbmsDialect dbmsDialect = (DbmsDialect)serviceProvider.getService(DbmsDialect.class);
        EntityManager em = (EntityManager)serviceProvider.getService(EntityManager.class);
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        SessionFactoryImplementor sfi = session.getFactory();
        if (session.isClosed()) {
            throw new PersistenceException("Entity manager is closed!");
        }
        Integer firstResult = null;
        Integer maxResults = null;
        if (query.getFirstResult() > 0) {
            firstResult = query.getFirstResult();
        }
        if (query.getMaxResults() != Integer.MAX_VALUE) {
            maxResults = query.getMaxResults();
        }
        ArrayList<String> queryStrings = new ArrayList<String>(participatingQueries.size());
        HashSet<String> querySpaces = new HashSet<String>();
        QueryParamEntry queryParametersEntry = this.createQueryParameters(em, baseQuery, participatingQueries, queryStrings, querySpaces);
        QueryParameters queryParameters = queryParametersEntry.queryParameters;
        QueryPlanCacheKey cacheKey = queryPlanCacheEnabled ? this.createCacheKey(finalSql, participatingQueries, queryStrings, firstResult, maxResults) : null;
        CacheEntry<QueryPlanCacheValue> queryPlanEntry = this.getQueryPlan(sfi, query, cacheKey);
        QueryPlanCacheValue queryPlanCacheValue = queryPlanEntry.getValue();
        HQLQueryPlan queryPlan = queryPlanCacheValue.getQueryPlan();
        if (queryPlan.getReturnMetadata() == null) {
            returningColumns = null;
            returningColumnTypes = null;
        } else if (queryPlanEntry.isFromCache()) {
            returningColumns = queryPlanCacheValue.getReturningColumns();
            returningColumnTypes = queryPlanCacheValue.getReturningColumnTypes();
        } else {
            String exampleQuerySql = queryPlanCacheValue.getQueryPlan().getSqlStrings()[0];
            boolean caseInsensitive = Boolean.valueOf(((ConfigurationSource)serviceProvider.getService(ConfigurationSource.class)).getProperty("com.blazebit.persistence.returning_clause_case_sensitive")) == false;
            returningColumns = HibernateExtendedQuerySupport.getReturningColumns(caseInsensitive, exampleQuerySql);
            int[] nArray = returningColumnTypes = dbmsDialect.needsReturningSqlTypes() ? HibernateExtendedQuerySupport.getReturningColumnTypes(queryPlan, sfi) : null;
        }
        if (!queryPlanEntry.isFromCache()) {
            this.prepareQueryPlan(queryPlan, queryParametersEntry.specifications, finalSql, session, baseQuery, true, dbmsDialect);
            if (queryPlanCacheEnabled) {
                this.putQueryPlanIfAbsent(sfi, cacheKey, new QueryPlanCacheValue(queryPlan, returningColumns, returningColumnTypes));
            }
        }
        this.autoFlush(querySpaces, session);
        if (queryPlan.getReturnMetadata() == null) {
            return this.hibernateAccess.performExecuteUpdate(queryPlan, session, queryParameters);
        }
        try {
            List<Object> results = this.hibernateAccess.performList(queryPlan, this.wrapSession(session, dbmsDialect, returningColumns, returningColumnTypes, null), queryParameters);
            if (results.size() != 1) {
                throw new IllegalArgumentException("Expected size 1 but was: " + results.size());
            }
            Number count = (Number)results.get(0);
            return count.intValue();
        }
        catch (QueryExecutionRequestException he) {
            LOG.severe("Could not execute the following SQL query: " + finalSql);
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            LOG.severe("Could not execute the following SQL query: " + finalSql);
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            LOG.severe("Could not execute the following SQL query: " + finalSql);
            this.hibernateAccess.throwPersistenceException(em, he);
            return 0;
        }
    }

    public ReturningResult<Object[]> executeReturning(ServiceProvider serviceProvider, List<Query> participatingQueries, Query modificationBaseQuery, Query exampleQuery, String sqlOverride, boolean queryPlanCacheEnabled) {
        int[] returningColumnTypes;
        String[][] returningColumns;
        DbmsDialect dbmsDialect = (DbmsDialect)serviceProvider.getService(DbmsDialect.class);
        EntityManager em = (EntityManager)serviceProvider.getService(EntityManager.class);
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        SessionFactoryImplementor sfi = session.getFactory();
        if (session.isClosed()) {
            throw new PersistenceException("Entity manager is closed!");
        }
        ArrayList<String> queryStrings = new ArrayList<String>(participatingQueries.size());
        HashSet<String> querySpaces = new HashSet<String>();
        QueryParamEntry queryParametersEntry = this.createQueryParameters(em, modificationBaseQuery, participatingQueries, queryStrings, querySpaces);
        QueryParameters queryParameters = queryParametersEntry.queryParameters;
        QueryPlanCacheKey cacheKey = queryPlanCacheEnabled ? this.createCacheKey(sqlOverride, participatingQueries, queryStrings) : null;
        CacheEntry<QueryPlanCacheValue> queryPlanEntry = this.getQueryPlan(sfi, exampleQuery, cacheKey);
        QueryPlanCacheValue queryPlanCacheValue = queryPlanEntry.getValue();
        HQLQueryPlan queryPlan = queryPlanCacheValue.getQueryPlan();
        if (queryPlanEntry.isFromCache()) {
            returningColumns = queryPlanCacheValue.getReturningColumns();
            returningColumnTypes = queryPlanCacheValue.getReturningColumnTypes();
        } else {
            String exampleQuerySql = queryPlan.getSqlStrings()[0];
            boolean caseInsensitive = Boolean.valueOf(((ConfigurationSource)serviceProvider.getService(ConfigurationSource.class)).getProperty("com.blazebit.persistence.returning_clause_case_sensitive")) == false;
            returningColumns = HibernateExtendedQuerySupport.getReturningColumns(caseInsensitive, exampleQuerySql);
            returningColumnTypes = dbmsDialect.needsReturningSqlTypes() ? HibernateExtendedQuerySupport.getReturningColumnTypes(queryPlan, sfi) : null;
        }
        StringBuilder sqlSb = new StringBuilder(sqlOverride.length() + 100);
        sqlSb.append(sqlOverride);
        String finalSql = sqlSb.toString();
        try {
            HibernateReturningResult<Object[]> returningResult = new HibernateReturningResult<Object[]>();
            if (!queryPlanEntry.isFromCache()) {
                this.prepareQueryPlan(queryPlan, queryParametersEntry.specifications, finalSql, session, modificationBaseQuery, true, dbmsDialect);
                if (queryPlanCacheEnabled) {
                    this.putQueryPlanIfAbsent(sfi, cacheKey, new QueryPlanCacheValue(queryPlan, returningColumns, returningColumnTypes));
                }
            }
            if (queryPlan.getTranslators().length > 1) {
                throw new IllegalArgumentException("No support for multiple translators yet!");
            }
            QueryTranslator queryTranslator = queryPlan.getTranslators()[0];
            StatementExecutor executor = this.getExecutor(queryTranslator, session, modificationBaseQuery);
            List originalDeletes = Collections.emptyList();
            if (executor != null && executor instanceof DeleteExecutor) {
                originalDeletes = (List)this.getField(executor, "deletes");
            }
            QueryLoader queryLoader = (QueryLoader)this.getField(queryTranslator, "queryLoader");
            this.hibernateAccess.checkTransactionSynchStatus(session);
            queryParameters.validateParameters();
            this.autoFlush(querySpaces, session);
            List<Object[]> results = Collections.EMPTY_LIST;
            boolean success = false;
            try {
                for (String delete : originalDeletes) {
                    this.hibernateAccess.doExecute(executor, delete, queryParameters, session, queryParametersEntry.specifications);
                }
                results = this.hibernateAccess.list(queryLoader, this.wrapSession(session, dbmsDialect, returningColumns, returningColumnTypes, returningResult), queryParameters);
                success = true;
            }
            catch (QueryExecutionRequestException he) {
                LOG.severe("Could not execute the following SQL query: " + finalSql);
                throw new IllegalStateException(he);
            }
            catch (TypeMismatchException e) {
                LOG.severe("Could not execute the following SQL query: " + finalSql);
                throw new IllegalArgumentException(e);
            }
            catch (HibernateException he) {
                LOG.severe("Could not execute the following SQL query: " + finalSql);
                throw this.hibernateAccess.convert(em, he);
            }
            finally {
                this.hibernateAccess.afterTransaction(session, success);
            }
            returningResult.setResultList(results);
            return returningResult;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    public void autoFlush(Set<String> querySpaces, SessionImplementor sessionImplementor) {
        AutoFlushEvent event = new AutoFlushEvent(querySpaces, (EventSource)sessionImplementor);
        for (AutoFlushEventListener listener : ((EventListenerRegistry)sessionImplementor.getFactory().getServiceRegistry().getService(EventListenerRegistry.class)).getEventListenerGroup(EventType.AUTO_FLUSH).listeners()) {
            listener.onAutoFlush(event);
        }
    }

    private static String[][] getReturningColumns(boolean caseInsensitive, String exampleQuerySql) {
        int fromIndex = exampleQuerySql.indexOf("from");
        int selectIndex = exampleQuerySql.indexOf("select");
        String[] selectItems = HibernateExtendedQuerySupport.splitSelectItems(exampleQuerySql.subSequence(selectIndex + "select".length() + 1, fromIndex));
        String[][] returningColumns = new String[selectItems.length][2];
        for (int i = 0; i < selectItems.length; ++i) {
            String selectItemWithAlias = selectItems[i].substring(selectItems[i].lastIndexOf(46) + 1);
            returningColumns[i][0] = caseInsensitive ? selectItemWithAlias.substring(0, selectItemWithAlias.indexOf(32)).toLowerCase() : selectItemWithAlias.substring(0, selectItemWithAlias.indexOf(32));
            returningColumns[i][1] = selectItemWithAlias.substring(selectItemWithAlias.lastIndexOf(32) + 1);
        }
        return returningColumns;
    }

    private static int[] getReturningColumnTypes(HQLQueryPlan queryPlan, SessionFactoryImplementor sfi) {
        ArrayList<Integer> sqlTypes = new ArrayList<Integer>();
        Type[] types = queryPlan.getReturnMetadata().getReturnTypes();
        for (int i = 0; i < types.length; ++i) {
            int[] sqlTypeArray = types[i].sqlTypes((Mapping)sfi);
            for (int j = 0; j < sqlTypeArray.length; ++j) {
                sqlTypes.add(sqlTypeArray[j]);
            }
        }
        int[] returningColumnTypes = new int[sqlTypes.size()];
        for (int i = 0; i < sqlTypes.size(); ++i) {
            returningColumnTypes[i] = (Integer)sqlTypes.get(i);
        }
        return returningColumnTypes;
    }

    private static String[] splitSelectItems(CharSequence itemsString) {
        ArrayList<String> selectItems = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int parenthesis = 0;
        boolean text = false;
        int i = 0;
        int length = itemsString.length();
        while (i < length) {
            char c = itemsString.charAt(i);
            if (text) {
                if (c == '(') {
                    ++parenthesis;
                } else if (c == ')') {
                    --parenthesis;
                } else if (parenthesis == 0 && c == ',') {
                    selectItems.add(HibernateExtendedQuerySupport.trim(sb));
                    sb.setLength(0);
                    text = false;
                    ++i;
                    continue;
                }
                sb.append(c);
            } else if (!Character.isWhitespace(c)) {
                sb.append(c);
                text = true;
            }
            ++i;
        }
        if (text) {
            selectItems.add(HibernateExtendedQuerySupport.trim(sb));
        }
        return selectItems.toArray(new String[selectItems.size()]);
    }

    private static String trim(StringBuilder sb) {
        int i;
        for (i = sb.length() - 1; i >= 0 && Character.isWhitespace(sb.charAt(i)); --i) {
        }
        return sb.substring(0, i + 1);
    }

    private QueryParamEntry createQueryParameters(EntityManager em, Query query, List<Query> participatingQueries, List<String> queryStrings, Set<String> querySpaces) {
        Serializable[] serializableArray;
        org.hibernate.Query hibernateQuery = (org.hibernate.Query)query.unwrap(org.hibernate.Query.class);
        ArrayList<ParameterSpecification> parameterSpecifications = new ArrayList<ParameterSpecification>();
        ArrayList types = new ArrayList();
        ArrayList values = new ArrayList();
        LinkedHashMap<String, TypedValue> namedParams = new LinkedHashMap<String, TypedValue>();
        Object collectionKey = null;
        LockOptions lockOptions = new LockOptions();
        RowSelection originalRowSelection = this.hibernateAccess.getQueryParameters((org.hibernate.Query)query.unwrap(org.hibernate.Query.class), this.hibernateAccess.getNamedParams(hibernateQuery)).getRowSelection();
        RowSelection rowSelection = new RowSelection();
        rowSelection.setTimeout(originalRowSelection.getTimeout());
        rowSelection.setFetchSize(originalRowSelection.getFetchSize());
        if (originalRowSelection.getFirstRow() != null && originalRowSelection.getFirstRow() != 0) {
            rowSelection.setFirstRow(originalRowSelection.getFirstRow());
        }
        if (originalRowSelection.getMaxRows() != null && originalRowSelection.getMaxRows() != Integer.MAX_VALUE) {
            rowSelection.setMaxRows(originalRowSelection.getMaxRows());
        }
        boolean readOnly = false;
        boolean cacheable = false;
        String cacheRegion = null;
        String comment = null;
        List<String> queryHints = null;
        for (Query participatingQuery : participatingQueries) {
            org.hibernate.Query hibernateParticipatingQuery = (org.hibernate.Query)participatingQuery.unwrap(org.hibernate.Query.class);
            readOnly = readOnly || hibernateParticipatingQuery.isReadOnly();
            cacheable = cacheable || this.hibernateAccess.getQueryParameters(hibernateParticipatingQuery, namedParams).isCacheable();
            comment = comment != null ? comment : this.hibernateAccess.getQueryParameters(hibernateParticipatingQuery, namedParams).getComment();
        }
        for (QueryParamEntry queryParamEntry : this.getQueryParamEntries(em, participatingQueries, querySpaces)) {
            queryStrings.add(queryParamEntry.queryString);
            QueryParameters participatingQueryParameters = queryParamEntry.queryParameters;
            Collections.addAll(types, participatingQueryParameters.getPositionalParameterTypes());
            Collections.addAll(values, participatingQueryParameters.getPositionalParameterValues());
            namedParams.putAll(participatingQueryParameters.getNamedParameters());
            parameterSpecifications.addAll(queryParamEntry.specifications);
            LockOptions originalLockOptions = participatingQueryParameters.getLockOptions();
            if (originalLockOptions.getScope()) {
                lockOptions.setScope(true);
            }
            if (originalLockOptions.getLockMode() != LockMode.NONE) {
                if (lockOptions.getLockMode() != LockMode.NONE && lockOptions.getLockMode() != originalLockOptions.getLockMode()) {
                    throw new IllegalStateException("Multiple different lock modes!");
                }
                lockOptions.setLockMode(originalLockOptions.getLockMode());
            }
            if (originalLockOptions.getTimeOut() != -1) {
                if (lockOptions.getTimeOut() != -1 && lockOptions.getTimeOut() != originalLockOptions.getTimeOut()) {
                    throw new IllegalStateException("Multiple different lock timeouts!");
                }
                lockOptions.setTimeOut(originalLockOptions.getTimeOut());
            }
            Iterator aliasLockIter = participatingQueryParameters.getLockOptions().getAliasLockIterator();
            while (aliasLockIter.hasNext()) {
                Map.Entry entry = (Map.Entry)aliasLockIter.next();
                lockOptions.setAliasSpecificLockMode((String)entry.getKey(), (LockMode)entry.getValue());
            }
        }
        Object[] objectArray = values.toArray(new Object[values.size()]);
        if (collectionKey == null) {
            serializableArray = null;
        } else {
            Serializable[] serializableArray2 = new Serializable[1];
            serializableArray = serializableArray2;
            serializableArray2[0] = collectionKey;
        }
        QueryParameters queryParameters = this.hibernateAccess.createQueryParameters(types.toArray(new Type[types.size()]), objectArray, namedParams, lockOptions, rowSelection, true, readOnly, cacheable, cacheRegion, comment, queryHints, serializableArray);
        return new QueryParamEntry(null, queryParameters, parameterSpecifications);
    }

    private SessionImplementor wrapSession(SessionImplementor session, DbmsDialect dbmsDialect, String[][] columns, int[] returningSqlTypes, HibernateReturningResult<?> returningResult) {
        return this.hibernateAccess.wrapSession(session, dbmsDialect, columns, returningSqlTypes, returningResult);
    }

    private List<QueryParamEntry> getQueryParamEntries(EntityManager em, List<Query> queries, Set<String> querySpaces) {
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        SessionFactoryImplementor sfi = session.getFactory();
        ArrayList<QueryParamEntry> result = new ArrayList<QueryParamEntry>(queries.size());
        LinkedList<Query> queryQueue = new LinkedList<Query>(queries);
        while (queryQueue.size() > 0) {
            List specifications;
            QueryParameters queryParameters;
            Query q = (Query)queryQueue.remove();
            if (q instanceof CteQueryWrapper) {
                List participatingQueries = ((CteQueryWrapper)q).getParticipatingQueries();
                for (int i = participatingQueries.size() - 1; i > -1; --i) {
                    queryQueue.addFirst((Query)participatingQueries.get(i));
                }
                continue;
            }
            org.hibernate.Query hibernateQuery = (org.hibernate.Query)q.unwrap(org.hibernate.Query.class);
            HashMap<String, TypedValue> namedParams = new HashMap<String, TypedValue>(this.hibernateAccess.getNamedParams(hibernateQuery));
            String queryString = this.hibernateAccess.expandParameterLists(session, hibernateQuery, namedParams);
            HQLQueryPlan queryPlan = sfi.getQueryPlanCache().getHQLQueryPlan(queryString, false, Collections.EMPTY_MAP);
            if (queryPlan.getTranslators().length > 1) {
                throw new IllegalArgumentException("No support for multiple translators yet!");
            }
            querySpaces.addAll(queryPlan.getQuerySpaces());
            QueryTranslator queryTranslator = queryPlan.getTranslators()[0];
            try {
                queryParameters = this.hibernateAccess.getQueryParameters(hibernateQuery, namedParams);
                specifications = (List)this.getField(queryTranslator, "collectedParameterSpecifications");
                if (specifications == null) {
                    StatementExecutor executor = this.getStatementExecutor(queryTranslator);
                    if (!(executor instanceof BasicExecutor)) {
                        throw new IllegalArgumentException("Using polymorphic deletes/updates with CTEs is not yet supported");
                    }
                    specifications = (List)this.getField(executor, "parameterSpecifications");
                }
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            result.add(new QueryParamEntry(queryString, queryParameters, specifications));
        }
        return result;
    }

    private StatementExecutor getStatementExecutor(QueryTranslator queryTranslator) {
        return (StatementExecutor)this.getField(queryTranslator, "statementExecutor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareQueryPlan(HQLQueryPlan queryPlan, List<ParameterSpecification> queryParameterSpecifications, String finalSql, SessionImplementor session, Query modificationBaseQuery, boolean isModification, DbmsDialect dbmsDialect) {
        try {
            if (queryPlan.getTranslators().length > 1) {
                throw new IllegalArgumentException("No support for multiple translators yet!");
            }
            QueryTranslator queryTranslator = queryPlan.getTranslators()[0];
            this.setField(queryTranslator, "sql", finalSql);
            QueryLoader queryLoader = (QueryLoader)this.getField(queryTranslator, "queryLoader");
            if (queryLoader != null) {
                this.setField(queryLoader, "factory", this.hibernateAccess.wrapSessionFactory(queryLoader.getFactory(), dbmsDialect));
            }
            StatementExecutor executor = null;
            Field statementExecutor = null;
            boolean madeAccessible = false;
            try {
                statementExecutor = ReflectionUtils.getField(queryTranslator.getClass(), (String)"statementExecutor");
                boolean bl = madeAccessible = !statementExecutor.isAccessible();
                if (madeAccessible) {
                    statementExecutor.setAccessible(true);
                }
                if ((executor = (StatementExecutor)statementExecutor.get(queryTranslator)) == null && isModification) {
                    HashMap<String, TypedValue> namedParams;
                    org.hibernate.Query lastHibernateQuery = (org.hibernate.Query)modificationBaseQuery.unwrap(org.hibernate.Query.class);
                    String queryString = this.hibernateAccess.expandParameterLists(session, lastHibernateQuery, namedParams = new HashMap<String, TypedValue>(this.hibernateAccess.getNamedParams(lastHibernateQuery)));
                    HQLQueryPlan lastQueryPlan = new HQLQueryPlan(queryString, false, Collections.EMPTY_MAP, session.getFactory());
                    if (lastQueryPlan.getTranslators().length > 1) {
                        throw new IllegalArgumentException("No support for multiple translators yet!");
                    }
                    QueryTranslator lastQueryTranslator = lastQueryPlan.getTranslators()[0];
                    executor = (StatementExecutor)statementExecutor.get(lastQueryTranslator);
                    statementExecutor.set(queryTranslator, executor);
                }
            }
            finally {
                if (madeAccessible) {
                    statementExecutor.setAccessible(false);
                }
            }
            if (executor != null) {
                this.setField(executor, "sql", finalSql);
                this.setField(executor, BasicExecutor.class, "parameterSpecifications", queryParameterSpecifications);
                if (executor instanceof DeleteExecutor) {
                    if (dbmsDialect.supportsModificationQueryInWithClause()) {
                        this.setField(executor, "deletes", new ArrayList());
                    } else {
                        int withIndex = finalSql.indexOf("with ");
                        if (withIndex != -1) {
                            int end = this.getCTEEnd(finalSql, withIndex);
                            List originalDeletes = (List)this.getField(executor, "deletes");
                            int maxLength = 0;
                            for (String s : originalDeletes) {
                                maxLength = Math.max(maxLength, s.length());
                            }
                            ArrayList<String> deletes = new ArrayList<String>(originalDeletes.size());
                            StringBuilder newSb = new StringBuilder(end + maxLength);
                            StringBuilder withClauseSb = new StringBuilder(end - withIndex);
                            withClauseSb.append(finalSql, withIndex, end);
                            for (String s : originalDeletes) {
                                newSb.append(s);
                                dbmsDialect.appendExtendedSql(newSb, DbmsStatementType.DELETE, false, false, withClauseSb, null, null, null, null, null);
                                deletes.add(newSb.toString());
                                newSb.setLength(0);
                            }
                            this.setField(executor, "deletes", deletes);
                        }
                    }
                }
            }
            ParameterTranslations translations = this.hibernateAccess.createParameterTranslations(queryParameterSpecifications);
            this.setField(queryTranslator, "paramTranslations", translations);
            this.setField(queryTranslator, "collectedParameterSpecifications", queryParameterSpecifications);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private StatementExecutor getExecutor(QueryTranslator queryTranslator, SessionImplementor session, Query lastQuery) {
        StatementExecutor executor = null;
        Field statementExectuor = null;
        boolean madeAccessible = false;
        try {
            statementExectuor = ReflectionUtils.getField(queryTranslator.getClass(), (String)"statementExecutor");
            boolean bl = madeAccessible = !statementExectuor.isAccessible();
            if (madeAccessible) {
                statementExectuor.setAccessible(true);
            }
            if ((executor = (StatementExecutor)statementExectuor.get(queryTranslator)) == null) {
                org.hibernate.Query lastHibernateQuery = (org.hibernate.Query)lastQuery.unwrap(org.hibernate.Query.class);
                HashMap<String, TypedValue> namedParams = new HashMap<String, TypedValue>(this.hibernateAccess.getNamedParams(lastHibernateQuery));
                String queryString = this.hibernateAccess.expandParameterLists(session, lastHibernateQuery, namedParams);
                HQLQueryPlan lastQueryPlan = session.getFactory().getQueryPlanCache().getHQLQueryPlan(queryString, false, Collections.EMPTY_MAP);
                if (lastQueryPlan.getTranslators().length > 1) {
                    throw new IllegalArgumentException("No support for multiple translators yet!");
                }
                QueryTranslator lastQueryTranslator = lastQueryPlan.getTranslators()[0];
                executor = (StatementExecutor)statementExectuor.get(lastQueryTranslator);
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        finally {
            if (madeAccessible) {
                statementExectuor.setAccessible(false);
            }
        }
        return executor;
    }

    private int getCTEEnd(String sql, int start) {
        int i;
        int parenthesis = 0;
        QuoteMode mode = QuoteMode.NONE;
        boolean started = false;
        int end = sql.length();
        block0: for (i = start; i < end; ++i) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                started = true;
                ++parenthesis;
                continue;
            }
            if (c == ')') {
                --parenthesis;
                continue;
            }
            if (!started || parenthesis != 0 || c == ',' || Character.isWhitespace(c)) continue;
            for (String statementType : KNOWN_STATEMENTS) {
                if (sql.regionMatches(true, i, statementType, 0, statementType.length())) break block0;
            }
        }
        return i;
    }

    private CacheEntry<QueryPlanCacheValue> getQueryPlan(SessionFactoryImplementor sfi, Query query, QueryPlanCacheKey cacheKey) {
        QueryPlanCacheValue queryPlan;
        boolean fromCache;
        if (cacheKey == null) {
            fromCache = false;
            queryPlan = this.createQueryPlan(sfi, query);
        } else {
            BoundedConcurrentHashMap<QueryPlanCacheKey, QueryPlanCacheValue> queryPlanCache = this.getQueryPlanCache(sfi);
            queryPlan = (QueryPlanCacheValue)queryPlanCache.get((Object)cacheKey);
            if (queryPlan == null) {
                fromCache = false;
                queryPlan = this.createQueryPlan(sfi, query);
            } else {
                fromCache = true;
            }
        }
        return new CacheEntry<QueryPlanCacheValue>(queryPlan, fromCache);
    }

    private QueryPlanCacheValue putQueryPlanIfAbsent(SessionFactoryImplementor sfi, QueryPlanCacheKey cacheKey, QueryPlanCacheValue queryPlan) {
        BoundedConcurrentHashMap<QueryPlanCacheKey, QueryPlanCacheValue> queryPlanCache = this.getQueryPlanCache(sfi);
        return (QueryPlanCacheValue)queryPlanCache.putIfAbsent((Object)cacheKey, (Object)queryPlan);
    }

    private QueryPlanCacheValue createQueryPlan(SessionFactoryImplementor sfi, Query query) {
        org.hibernate.Query hibernateQuery = (org.hibernate.Query)query.unwrap(org.hibernate.Query.class);
        String queryString = hibernateQuery.getQueryString();
        return new QueryPlanCacheValue(new HQLQueryPlan(queryString, false, Collections.EMPTY_MAP, sfi), null, null);
    }

    private BoundedConcurrentHashMap<QueryPlanCacheKey, QueryPlanCacheValue> getQueryPlanCache(SessionFactoryImplementor sfi) {
        BoundedConcurrentHashMap<QueryPlanCacheKey, QueryPlanCacheValue> oldQueryPlanCache;
        BoundedConcurrentHashMap<QueryPlanCacheKey, QueryPlanCacheValue> queryPlanCache = (BoundedConcurrentHashMap<QueryPlanCacheKey, QueryPlanCacheValue>)this.queryPlanCachesCache.get(sfi);
        if (queryPlanCache == null && (oldQueryPlanCache = this.queryPlanCachesCache.putIfAbsent(sfi, queryPlanCache = new BoundedConcurrentHashMap(2048, 20, BoundedConcurrentHashMap.Eviction.LIRS))) != null) {
            queryPlanCache = oldQueryPlanCache;
        }
        return queryPlanCache;
    }

    private QueryPlanCacheKey createCacheKey(String sql, List<Query> queries, List<String> queryStrings) {
        return this.createCacheKey(sql, queries, queryStrings, null, null);
    }

    private QueryPlanCacheKey createCacheKey(String sql, List<Query> queries, List<String> queryStrings, Integer firstResult, Integer maxResults) {
        ArrayList<QueryPlanCacheKeyComponent> cacheKeyComponents = new ArrayList<QueryPlanCacheKeyComponent>(queries.size());
        for (int i = 0; i < queries.size(); ++i) {
            Query query = queries.get(i);
            String queryString = queryStrings.get(i);
            cacheKeyComponents.add(new QueryPlanCacheKeyComponent(queryString, query.getFirstResult(), query.getMaxResults()));
        }
        return new QueryPlanCacheKey(sql, cacheKeyComponents, firstResult, maxResults);
    }

    private void addAll(List<Query> queries, List<String> parts) {
        for (int i = 0; i < queries.size(); ++i) {
            Query query = queries.get(i);
            if (query instanceof CteQueryWrapper) {
                this.addAll(((CteQueryWrapper)query).getParticipatingQueries(), parts);
                continue;
            }
            parts.add(((org.hibernate.Query)query.unwrap(org.hibernate.Query.class)).getQueryString());
        }
    }

    private <T> T getField(Object object, String field) {
        FieldKey key = new FieldKey(object.getClass(), object.getClass(), field);
        Field f = (Field)this.fieldCache.get(key);
        try {
            if (f == null) {
                f = ReflectionUtils.getField(object.getClass(), (String)field);
                f.setAccessible(true);
                this.fieldCache.put(key, f);
            }
            return (T)f.get(object);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private void setField(Object object, String field, Object value) {
        this.setField(object, object.getClass(), field, value);
    }

    private void setField(Object object, Class<?> clazz, String field, Object value) {
        FieldKey key = new FieldKey(object.getClass(), clazz, field);
        Field f = (Field)this.fieldCache.get(key);
        try {
            if (f == null) {
                f = ReflectionUtils.getField(clazz, (String)field);
                if (f == null) {
                    f = ReflectionUtils.getField(object.getClass(), (String)field);
                }
                f.setAccessible(true);
                this.fieldCache.put(key, f);
            }
            f.set(object, value);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private static class QueryParamEntry {
        final String queryString;
        final QueryParameters queryParameters;
        final List<ParameterSpecification> specifications;

        public QueryParamEntry(String queryString, QueryParameters queryParameters, List<ParameterSpecification> specifications) {
            this.queryString = queryString;
            this.queryParameters = queryParameters;
            this.specifications = specifications;
        }
    }

    private static class QueryPlanCacheKey {
        final String sql;
        final List<QueryPlanCacheKeyComponent> cacheKeyComponents;
        final Integer firstResult;
        final Integer maxResults;

        public QueryPlanCacheKey(String sql, List<QueryPlanCacheKeyComponent> cacheKeyComponents) {
            this.sql = sql;
            this.cacheKeyComponents = cacheKeyComponents;
            this.firstResult = null;
            this.maxResults = null;
        }

        public QueryPlanCacheKey(String sql, List<QueryPlanCacheKeyComponent> cacheKeyComponents, Integer firstResult, Integer maxResults) {
            this.sql = sql;
            this.cacheKeyComponents = cacheKeyComponents;
            this.firstResult = firstResult;
            this.maxResults = maxResults;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryPlanCacheKey that = (QueryPlanCacheKey)o;
            return Objects.equals(this.sql, that.sql) && this.cacheKeyComponents.equals(that.cacheKeyComponents) && Objects.equals(this.firstResult, that.firstResult) && Objects.equals(this.maxResults, that.maxResults);
        }

        public int hashCode() {
            return Objects.hash(this.sql, this.cacheKeyComponents, this.firstResult, this.maxResults);
        }
    }

    private static class CacheEntry<T> {
        private final T value;
        private final boolean fromCache;

        public CacheEntry(T value, boolean fromCache) {
            this.value = value;
            this.fromCache = fromCache;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isFromCache() {
            return this.fromCache;
        }
    }

    private static class QueryPlanCacheValue {
        private final HQLQueryPlan queryPlan;
        private final String[][] returningColumns;
        private final int[] returningColumnTypes;

        private QueryPlanCacheValue(HQLQueryPlan queryPlan, String[][] returningColumns, int[] returningColumnTypes) {
            this.queryPlan = queryPlan;
            this.returningColumns = returningColumns;
            this.returningColumnTypes = returningColumnTypes;
        }

        public HQLQueryPlan getQueryPlan() {
            return this.queryPlan;
        }

        public String[][] getReturningColumns() {
            return this.returningColumns;
        }

        public int[] getReturningColumnTypes() {
            return this.returningColumnTypes;
        }
    }

    private static class QueryPlanCacheKeyComponent {
        final String query;
        final Integer firstResult;
        final Integer maxResults;

        public QueryPlanCacheKeyComponent(String query) {
            this.query = query;
            this.firstResult = null;
            this.maxResults = null;
        }

        public QueryPlanCacheKeyComponent(String query, Integer firstResult, Integer maxResults) {
            this.query = query;
            this.firstResult = firstResult;
            this.maxResults = maxResults;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QueryPlanCacheKeyComponent)) {
                return false;
            }
            QueryPlanCacheKeyComponent that = (QueryPlanCacheKeyComponent)o;
            if (!this.query.equals(that.query)) {
                return false;
            }
            if (this.firstResult != null ? !this.firstResult.equals(that.firstResult) : that.firstResult != null) {
                return false;
            }
            return this.maxResults != null ? this.maxResults.equals(that.maxResults) : that.maxResults == null;
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + (this.firstResult != null ? this.firstResult.hashCode() : 0);
            result = 31 * result + (this.maxResults != null ? this.maxResults.hashCode() : 0);
            return result;
        }
    }

    private static class FieldKey {
        private final Class<?> clazz;
        private final Class<?> expectClazz;
        private final String fieldName;

        public FieldKey(Class<?> clazz, Class<?> expectClazz, String fieldName) {
            this.clazz = clazz;
            this.expectClazz = expectClazz;
            this.fieldName = fieldName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FieldKey)) {
                return false;
            }
            FieldKey fieldKey = (FieldKey)o;
            return this.clazz.equals(fieldKey.clazz) && this.expectClazz.equals(fieldKey.expectClazz) && this.fieldName.equals(fieldKey.fieldName);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.expectClazz.hashCode();
            result = 31 * result + this.fieldName.hashCode();
            return result;
        }
    }
}

