/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base;

import com.blazebit.persistence.integration.hibernate.base.HibernateJpaProvider;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.metamodel.ManagedType;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

public class HibernateJpa21Provider
extends HibernateJpaProvider {
    private static final Method HAS_ORPHAN_DELETE_METHOD;
    private static final Method DO_CASCADE_METHOD;
    private static final CascadingAction DELETE_CASCADE;

    public HibernateJpa21Provider(PersistenceUnitUtil persistenceUnitUtil, String dbms, Map<String, EntityPersister> entityPersisters, Map<String, CollectionPersister> collectionPersisters, int major, int minor, int fix, String type) {
        super(persistenceUnitUtil, dbms, entityPersisters, collectionPersisters, major, minor, fix, type);
    }

    @Override
    public boolean isOrphanRemoval(ManagedType<?> ownerType, String attributeName) {
        EntityMetamodel entityMetamodel;
        Integer index;
        AbstractEntityPersister entityPersister = this.getEntityPersister(ownerType);
        if (entityPersister != null && (index = (entityMetamodel = entityPersister.getEntityMetamodel()).getPropertyIndexOrNull(attributeName)) != null) {
            try {
                return (Boolean)HAS_ORPHAN_DELETE_METHOD.invoke((Object)entityMetamodel.getCascadeStyles()[index], new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not access orphan removal information. Please report your version of hibernate so we can provide support for it!", ex);
            }
        }
        return false;
    }

    @Override
    public boolean isOrphanRemoval(ManagedType<?> ownerType, String elementCollectionPath, String attributeName) {
        int propertyIndex;
        Type elementType = this.getCollectionPersister(ownerType, elementCollectionPath).getElementType();
        if (!(elementType instanceof ComponentType)) {
            return false;
        }
        ComponentType componentType = (ComponentType)elementType;
        String subAttribute = attributeName.substring(elementCollectionPath.length() + 1);
        String[] propertyParts = subAttribute.split("\\.");
        for (propertyIndex = 0; propertyIndex < propertyParts.length - 1; ++propertyIndex) {
            int index = componentType.getPropertyIndex(propertyParts[propertyIndex]);
            Type propertyType = componentType.getSubtypes()[index];
            if (!(propertyType instanceof ComponentType)) break;
            componentType = (ComponentType)propertyType;
        }
        try {
            int leafPropertyIndex = componentType.getPropertyIndex(propertyParts[propertyIndex]);
            return (Boolean)HAS_ORPHAN_DELETE_METHOD.invoke((Object)componentType.getCascadeStyle(leafPropertyIndex), new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not access orphan removal information. Please report your version of hibernate so we can provide support for it!", ex);
        }
    }

    @Override
    public boolean isDeleteCascaded(ManagedType<?> ownerType, String attributeName) {
        EntityMetamodel entityMetamodel;
        Integer index;
        AbstractEntityPersister entityPersister = this.getEntityPersister(ownerType);
        if (entityPersister != null && (index = (entityMetamodel = entityPersister.getEntityMetamodel()).getPropertyIndexOrNull(attributeName)) != null) {
            try {
                return (Boolean)DO_CASCADE_METHOD.invoke((Object)entityMetamodel.getCascadeStyles()[index], DELETE_CASCADE);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not access orphan removal information. Please report your version of hibernate so we can provide support for it!", ex);
            }
        }
        return false;
    }

    @Override
    public boolean isDeleteCascaded(ManagedType<?> ownerType, String elementCollectionPath, String attributeName) {
        int propertyIndex;
        Type elementType = this.getCollectionPersister(ownerType, elementCollectionPath).getElementType();
        if (!(elementType instanceof ComponentType)) {
            return false;
        }
        ComponentType componentType = (ComponentType)elementType;
        String subAttribute = attributeName.substring(elementCollectionPath.length() + 1);
        String[] propertyParts = subAttribute.split("\\.");
        for (propertyIndex = 0; propertyIndex < propertyParts.length - 1; ++propertyIndex) {
            int index = componentType.getPropertyIndex(propertyParts[propertyIndex]);
            Type propertyType = componentType.getSubtypes()[index];
            if (!(propertyType instanceof ComponentType)) break;
            componentType = (ComponentType)propertyType;
        }
        try {
            int leafPropertyIndex = componentType.getPropertyIndex(propertyParts[propertyIndex]);
            return (Boolean)DO_CASCADE_METHOD.invoke((Object)componentType.getCascadeStyle(leafPropertyIndex), DELETE_CASCADE);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not access orphan removal information. Please report your version of hibernate so we can provide support for it!", ex);
        }
    }

    @Override
    public boolean supportsJpa21() {
        return true;
    }

    @Override
    public String getOnClause() {
        return "ON";
    }

    @Override
    public boolean supportsTreatJoin() {
        return true;
    }

    static {
        try {
            Class<?> cascadeStyleClass = Class.forName("org.hibernate.engine.spi.CascadeStyle");
            HAS_ORPHAN_DELETE_METHOD = cascadeStyleClass.getMethod("hasOrphanDelete", new Class[0]);
            DO_CASCADE_METHOD = cascadeStyleClass.getMethod("doCascade", CascadingAction.class);
            DELETE_CASCADE = (CascadingAction)Class.forName("org.hibernate.engine.spi.CascadingActions").getField("DELETE").get(null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not access cascading information. Please report your version of hibernate so we can provide support for it!", ex);
        }
    }
}

