/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.base.query;

import com.blazebit.persistence.spring.data.base.query.JpaParameters;
import jakarta.persistence.Query;
import java.util.Date;
import java.util.Iterator;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.util.Assert;

public abstract class ParameterBinder {
    private final JpaParameters parameters;
    private final ParameterAccessor accessor;
    private final Object[] values;

    public ParameterBinder(JpaParameters parameters, Object[] values) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.isTrue((parameters.getNumberOfParameters() == values.length ? 1 : 0) != 0, (String)"Invalid number of parameters given!");
        this.parameters = parameters;
        this.values = (Object[])values.clone();
        this.accessor = new ParametersParameterAccessor((Parameters)parameters, this.values);
    }

    ParameterBinder(JpaParameters parameters) {
        this(parameters, new Object[0]);
    }

    public Pageable getPageable() {
        return this.accessor.getPageable();
    }

    public Sort getSort() {
        return this.accessor.getSort();
    }

    public <T extends Query> T bind(T query) {
        int bindableParameterIndex = 0;
        int queryParameterPosition = 1;
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            JpaParameters.JpaParameter parameter = (JpaParameters.JpaParameter)((Object)iterator.next());
            if (!this.canBindParameter(parameter)) continue;
            Object value = this.accessor.getBindableValue(bindableParameterIndex);
            this.bind(query, parameter, value, queryParameterPosition++);
            ++bindableParameterIndex;
        }
        return query;
    }

    protected boolean canBindParameter(Parameter parameter) {
        return parameter.isBindable();
    }

    protected void bind(Query query, JpaParameters.JpaParameter parameter, Object value, int position) {
        if (parameter.isTemporalParameter()) {
            if (this.hasNamedParameter(query) && parameter.isNamedParameter()) {
                query.setParameter(parameter.getParameterName(), (Date)value, parameter.getTemporalType());
            } else {
                query.setParameter(position, (Date)value, parameter.getTemporalType());
            }
            return;
        }
        if (this.hasNamedParameter(query) && parameter.isNamedParameter()) {
            query.setParameter(parameter.getParameterName(), value);
        } else {
            query.setParameter(position, value);
        }
    }

    public Query bindAndPrepare(Query query) {
        return this.bindAndPrepare(query, this.parameters);
    }

    boolean hasNamedParameter(Query query) {
        return QueryUtils.hasNamedParameter((Query)query);
    }

    private Query bindAndPrepare(Query query, Parameters<?, ?> parameters) {
        Pageable pageable;
        Query result = this.bind(query);
        if (!parameters.hasPageableParameter() || (pageable = this.getPageable()).isUnpaged()) {
            return result;
        }
        result.setFirstResult(this.getOffset());
        result.setMaxResults(pageable.getPageSize());
        return result;
    }

    protected abstract int getOffset();

    JpaParameters getParameters() {
        return this.parameters;
    }

    protected Object[] getValues() {
        return this.values;
    }
}

