/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.base.repository;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.criteria.BlazeCriteria;
import com.blazebit.persistence.criteria.BlazeCriteriaBuilder;
import com.blazebit.persistence.criteria.BlazeCriteriaDelete;
import com.blazebit.persistence.criteria.BlazeCriteriaQuery;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spring.data.base.EntityViewSortUtil;
import com.blazebit.persistence.spring.data.base.query.KeysetAwarePageImpl;
import com.blazebit.persistence.spring.data.base.repository.EntityViewAwareCrudMethodMetadata;
import com.blazebit.persistence.spring.data.base.repository.FetchableFluentQueryBySpecification;
import com.blazebit.persistence.spring.data.base.repository.FluentQuerySupport;
import com.blazebit.persistence.spring.data.repository.KeysetPageable;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.convert.QueryByExamplePredicateBuilder;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.KeysetScrollSpecification;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional(readOnly=true)
public abstract class AbstractEntityViewAwareRepository<V, E, ID extends Serializable> {
    private static final String ID_MUST_NOT_BE_NULL = "The given id must not be null!";
    private static final String DELETE_ALL_QUERY_STRING = "delete from %s x";
    private static final String DELETE_ALL_QUERY_BY_ID_STRING = "delete from %s x where %s in :ids";
    private static final String[] EMPTY = new String[0];
    private static final EscapeCharacter DEFAULT = EscapeCharacter.of((char)'\\');
    protected EscapeCharacter escapeCharacter = DEFAULT;
    private final JpaEntityInformation<E, ?> entityInformation;
    private final EntityManager entityManager;
    private final CriteriaBuilderFactory cbf;
    private final EntityViewManager evm;
    private final Class<V> entityViewClass;
    private final String idAttributeName;
    private EntityViewAwareCrudMethodMetadata metadata;

    public AbstractEntityViewAwareRepository(JpaEntityInformation<E, ?> entityInformation, EntityManager entityManager, CriteriaBuilderFactory cbf, EntityViewManager evm, Class<V> entityViewClass) {
        this.entityInformation = entityInformation;
        this.entityManager = entityManager;
        this.cbf = cbf;
        this.evm = evm;
        this.entityViewClass = entityViewClass;
        this.idAttributeName = this.getIdAttribute(this.getDomainClass());
    }

    public void setRepositoryMethodMetadata(EntityViewAwareCrudMethodMetadata crudMethodMetadata) {
        this.metadata = crudMethodMetadata;
    }

    public void setEscapeCharacter(EscapeCharacter escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    protected EntityViewAwareCrudMethodMetadata getRepositoryMethodMetadata() {
        return this.metadata;
    }

    protected Class<E> getDomainClass() {
        return this.entityInformation.getJavaType();
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected abstract Map<String, Object> tryGetFetchGraphHints(EntityManager var1, JpaEntityGraph var2, Class<?> var3);

    protected Map<String, Object> getQueryHints(boolean applyFetchGraph) {
        if (this.metadata == null) {
            return Collections.emptyMap();
        }
        if (this.metadata.getEntityGraph() == null || !applyFetchGraph) {
            return this.metadata.getQueryHints();
        }
        HashMap<String, Object> hints = new HashMap<String, Object>();
        hints.putAll(this.metadata.getQueryHints());
        hints.putAll(this.tryGetFetchGraphHints(this.entityManager, this.getEntityGraph(), this.getDomainClass()));
        return hints;
    }

    private JpaEntityGraph getEntityGraph() {
        String fallbackName = this.entityInformation.getEntityName() + "." + this.metadata.getMethod().getName();
        return new JpaEntityGraph(this.metadata.getEntityGraph(), fallbackName);
    }

    @Transactional
    public <S extends E> S save(S entity) {
        if (entity instanceof EntityViewProxy) {
            this.evm.save(this.entityManager, entity);
            return entity;
        }
        if (this.entityInformation.isNew(entity)) {
            this.entityManager.persist(entity);
            return entity;
        }
        return (S)this.entityManager.merge(entity);
    }

    @Transactional
    public <S extends E> List<S> saveAll(Iterable<S> entities) {
        return this.save(entities);
    }

    @Transactional
    public <S extends E> List<S> saveAllAndFlush(Iterable<S> entities) {
        List<S> result = this.saveAll(entities);
        this.flush();
        return result;
    }

    @Transactional
    public <S extends E> List<S> save(Iterable<S> entities) {
        ArrayList<S> result = new ArrayList<S>();
        if (entities == null) {
            return result;
        }
        for (S entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    @Transactional
    public void flush() {
        this.entityManager.flush();
    }

    @Transactional
    public <S extends E> S saveAndFlush(S entity) {
        S result = this.save(entity);
        this.flush();
        return result;
    }

    @Transactional
    public void deleteById(ID id) {
        this.delete((E)id);
    }

    @Transactional
    public void delete(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        V entity = this.findOne(id);
        if (entity == null) {
            throw new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.entityInformation.getJavaType(), id), 1);
        }
        this.delete((E)entity);
    }

    @Transactional
    public void delete(E entity) {
        Assert.notNull(entity, (String)"The entity must not be null!");
        if (entity instanceof EntityViewProxy) {
            this.evm.remove(this.entityManager, entity);
        } else {
            this.entityManager.remove(this.entityManager.contains(entity) ? entity : this.entityManager.merge(entity));
        }
    }

    @Transactional
    public void delete(Iterable<? extends E> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        for (E entity : entities) {
            this.delete(entity);
        }
    }

    @Transactional
    public void deleteAll() {
        for (Object element : this.findAll()) {
            this.delete((E)element);
        }
    }

    @Transactional
    public void deleteAll(Iterable<? extends E> entities) {
        this.delete(entities);
    }

    @Transactional
    public void deleteInBatch(Iterable<E> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        if (!entities.iterator().hasNext()) {
            return;
        }
        QueryUtils.applyAndBind((String)QueryUtils.getQueryString((String)DELETE_ALL_QUERY_STRING, (String)this.entityInformation.getEntityName()), entities, (EntityManager)this.entityManager).executeUpdate();
    }

    @Transactional
    public void deleteAllInBatch(Iterable<E> entities) {
        this.deleteInBatch(entities);
    }

    @Transactional
    public void deleteAllById(Iterable<? extends ID> ids) {
        this.deleteAllByIdInBatch(ids);
    }

    @Transactional
    public void deleteAllByIdInBatch(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        if (!ids.iterator().hasNext()) {
            return;
        }
        String queryTemplate = DELETE_ALL_QUERY_BY_ID_STRING;
        String queryString = String.format(queryTemplate, this.entityInformation.getEntityName(), this.entityInformation.getIdAttribute().getName());
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("ids", ids);
        query.executeUpdate();
    }

    @Transactional
    public void deleteAllInBatch() {
        this.entityManager.createQuery(QueryUtils.getQueryString((String)DELETE_ALL_QUERY_STRING, (String)this.entityInformation.getEntityName())).executeUpdate();
    }

    @Transactional
    public long delete(Specification<E> spec) {
        return this.getModificationQuery(spec, this.getDomainClass()).executeUpdate();
    }

    public E getOne(ID id) {
        return (E)this.getReference(id);
    }

    public E getById(ID id) {
        return (E)this.getReference(id);
    }

    public E getReferenceById(ID id) {
        return (E)this.getReference(id);
    }

    public <S extends E> long count(Example<S> example) {
        return AbstractEntityViewAwareRepository.executeCountQuery(this.getCountQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType()));
    }

    public <S extends E> boolean exists(Example<S> example) {
        return !this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType(), (Sort)null).getResultList().isEmpty();
    }

    public boolean exists(Specification<E> spec) {
        return !this.getQuery(spec, this.getDomainClass(), (Sort)null).getResultList().isEmpty();
    }

    public <S extends E> List<S> findAll(Example<S> example) {
        return this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType(), (Sort)null).getResultList();
    }

    public <S extends E> List<S> findAll(Example<S> example, Sort sort) {
        return this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType(), sort).getResultList();
    }

    public <S extends E> Page<S> findAll(Example<S> example, Pageable pageable) {
        Class probeType = example.getProbeType();
        TypedQuery<S> query = this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), probeType, pageable);
        return pageable == null || pageable.isUnpaged() ? new KeysetAwarePageImpl(query.getResultList()) : new KeysetAwarePageImpl((PagedList)query.getResultList(), pageable);
    }

    public List<E> findAll(Sort sort) {
        return this.getQuery(null, sort).getResultList();
    }

    public Page<E> findAll(Pageable pageable) {
        if (pageable == null || pageable.isUnpaged()) {
            return new PageImpl(this.findAll());
        }
        return this.findAll((Specification)null, pageable);
    }

    public V findOne(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        CriteriaBuilder cb = (CriteriaBuilder)this.cbf.create(this.entityManager, this.getDomainClass()).where(this.idAttributeName).eq(id);
        String[] fetches = EMPTY;
        if (this.metadata != null && this.metadata.getEntityGraph() != null && (fetches = this.metadata.getEntityGraph().attributePaths()).length != 0) {
            cb.fetch(fetches);
        }
        Class<V> entityViewClass = this.metadata == null || this.metadata.getEntityViewClass() == null ? this.entityViewClass : this.metadata.getEntityViewClass();
        TypedQuery findOneQuery = entityViewClass == null ? cb.getQuery() : ((CriteriaBuilder)this.evm.applySetting(EntityViewSetting.create(entityViewClass), cb)).getQuery();
        this.applyQueryHints((Query)findOneQuery, fetches.length == 0);
        try {
            return (V)findOneQuery.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public <S extends E, R> R findBy(Specification<E> spec, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        return this.doFindBy(spec, this.getDomainClass(), queryFunction);
    }

    private <S extends E, R> R doFindBy(Specification<E> spec, Class<E> domainClass, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(spec, (String)"Specification must not be null");
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        FluentQuerySupport.ScrollQueryFactory scrollFunction = (sort, scrollPosition) -> {
            Specification specToUse = spec;
            if (scrollPosition instanceof KeysetScrollPosition) {
                KeysetScrollSpecification keysetSpec = new KeysetScrollSpecification((KeysetScrollPosition)scrollPosition, sort, this.entityInformation);
                sort = keysetSpec.sort();
                specToUse = specToUse.and((Specification)keysetSpec);
            }
            TypedQuery query = this.getQuery(specToUse, domainClass, sort);
            if (scrollPosition instanceof OffsetScrollPosition) {
                query.setFirstResult(Math.toIntExact(((OffsetScrollPosition)scrollPosition).getOffset()));
            }
            return query;
        };
        Function finder = sort -> this.getQuery((Specification)spec, (Class)domainClass, (Sort)sort);
        FetchableFluentQueryBySpecification.SpecificationScrollDelegate<E> scrollDelegate = new FetchableFluentQueryBySpecification.SpecificationScrollDelegate<E>(scrollFunction, this.entityInformation);
        FetchableFluentQueryBySpecification fluentQuery = new FetchableFluentQueryBySpecification(spec, domainClass, finder, scrollDelegate, this::count, this::exists, this.getEntityManager());
        return queryFunction.apply(fluentQuery);
    }

    public <S extends E, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Assert.notNull(queryFunction, (String)"Query function must not be null!");
        ExampleSpecification<S> spec = new ExampleSpecification<S>(example, this.escapeCharacter);
        Class probeType = example.getProbeType();
        return this.doFindBy(spec, probeType, queryFunction);
    }

    public V getReference(ID id) {
        Class<V> entityViewClass;
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        Class<Object> clazz = entityViewClass = this.metadata == null || this.metadata.getEntityViewClass() == null ? this.entityViewClass : this.metadata.getEntityViewClass();
        if (entityViewClass == null) {
            return (V)this.entityManager.getReference(this.getDomainClass(), id);
        }
        return (V)this.evm.getReference(entityViewClass, id);
    }

    public long count() {
        TypedQuery<Long> countQuery = this.getCountQuery(null, this.getDomainClass());
        return ((Number)countQuery.getSingleResult()).longValue();
    }

    public boolean existsById(ID id) {
        return this.exists(id);
    }

    public boolean exists(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        TypedQuery existsQuery = ((CriteriaBuilder)((CriteriaBuilder)((CriteriaBuilder)((CriteriaBuilder)this.cbf.create(this.entityManager, Object.class).from(this.getDomainClass())).select("''")).where(this.idAttributeName).eq(id)).setMaxResults(1)).getQuery();
        this.applyRepositoryMethodMetadata(existsQuery, true);
        try {
            return !existsQuery.getResultList().isEmpty();
        }
        catch (NoResultException e) {
            return false;
        }
    }

    public List<V> findAll() {
        return this.getQuery(null, this.getDomainClass(), null, null).getResultList();
    }

    public List<V> findAllById(Iterable<ID> idIterable) {
        return this.findAll(idIterable);
    }

    public List<V> findAll(Iterable<ID> idIterable) {
        Assert.notNull(idIterable, (String)ID_MUST_NOT_BE_NULL);
        ArrayList<Serializable> idList = new ArrayList<Serializable>();
        for (Serializable id : idIterable) {
            idList.add(id);
        }
        CriteriaBuilder cb = (CriteriaBuilder)this.cbf.create(this.entityManager, this.getDomainClass()).where(this.idAttributeName).in(idList);
        String[] fetches = EMPTY;
        if (this.metadata != null && this.metadata.getEntityGraph() != null && (fetches = this.metadata.getEntityGraph().attributePaths()).length != 0) {
            cb.fetch(fetches);
        }
        Class<V> entityViewClass = this.metadata == null || this.metadata.getEntityViewClass() == null ? this.entityViewClass : this.metadata.getEntityViewClass();
        TypedQuery findAllByIdsQuery = entityViewClass == null ? cb.getQuery() : ((CriteriaBuilder)this.evm.applySetting(EntityViewSetting.create(entityViewClass), cb)).getQuery();
        this.applyRepositoryMethodMetadata(findAllByIdsQuery, fetches.length == 0);
        return findAllByIdsQuery.getResultList();
    }

    private String getIdAttribute(Class<?> entityClass) {
        return ((ExtendedManagedType)((EntityMetamodel)this.cbf.getService(EntityMetamodel.class)).getManagedType(ExtendedManagedType.class, entityClass)).getIdAttribute().getName();
    }

    public List<V> findAll(Specification<E> spec) {
        return this.getQuery(spec, (Sort)null).getResultList();
    }

    public Page<V> findAll(Specification<E> spec, Pageable pageable) {
        TypedQuery<V> query = this.getQuery(spec, pageable);
        if (pageable == null || pageable.isUnpaged()) {
            return new KeysetAwarePageImpl(query.getResultList());
        }
        PagedList resultList = (PagedList)query.getResultList();
        Long total = resultList.getTotalSize();
        if (total.equals(0L)) {
            return new KeysetAwarePageImpl(Collections.emptyList(), total, null, pageable);
        }
        return new KeysetAwarePageImpl(resultList, pageable);
    }

    public List<V> findAll(Specification<E> spec, Sort sort) {
        return this.getQuery(spec, sort).getResultList();
    }

    public long count(Specification<E> spec) {
        return AbstractEntityViewAwareRepository.executeCountQuery(this.getCountQuery(spec, this.getDomainClass()));
    }

    protected TypedQuery<V> getQuery(Specification<E> spec, Pageable pageable) {
        Sort sort = pageable == null ? null : pageable.getSort();
        return this.getQuery(spec, this.getDomainClass(), pageable, sort);
    }

    protected <S extends E> TypedQuery<S> getQuery(Specification<S> spec, Class<S> domainClass, Pageable pageable) {
        Sort sort = pageable == null ? null : pageable.getSort();
        return this.getQuery(spec, domainClass, pageable, sort);
    }

    protected TypedQuery<E> getQuery(Specification<E> spec, Sort sort) {
        return this.getQuery(spec, this.getDomainClass(), null, sort);
    }

    protected <S extends E> TypedQuery<S> getQuery(Specification<S> spec, Class<S> domainClass, Sort sort) {
        return this.getQuery(spec, domainClass, null, sort);
    }

    protected <S extends E> TypedQuery<V> getQuery(Specification<S> spec, Class<S> domainClass, Pageable pageable, Sort sort) {
        TypedQuery query;
        Class<V> entityViewClass;
        BlazeCriteriaQuery cq = BlazeCriteria.get((CriteriaBuilderFactory)this.cbf, domainClass);
        Root<S> root = this.applySpecificationToCriteria(spec, domainClass, (CriteriaQuery<?>)cq);
        Class<Object> clazz = entityViewClass = this.metadata == null || this.metadata.getEntityViewClass() == null ? this.entityViewClass : this.metadata.getEntityViewClass();
        if (sort != null && entityViewClass == null) {
            cq.orderBy(QueryUtils.toOrders((Sort)sort, root, (jakarta.persistence.criteria.CriteriaBuilder)BlazeCriteria.get((CriteriaBuilderFactory)this.cbf)));
        }
        CriteriaBuilder cb = cq.createCriteriaBuilder(this.entityManager);
        String[] fetches = EMPTY;
        if (this.metadata != null && this.metadata.getEntityGraph() != null && (fetches = this.metadata.getEntityGraph().attributePaths()).length != 0) {
            cb.fetch(fetches);
        }
        boolean withCountQuery = true;
        boolean withKeysetExtraction = false;
        boolean withExtractAllKeysets = false;
        if (entityViewClass == null) {
            if (pageable == null || pageable.isUnpaged()) {
                query = cb.getQuery();
            } else {
                PaginatedCriteriaBuilder paginatedCriteriaBuilder;
                if (pageable instanceof KeysetPageable) {
                    KeysetPageable keysetPageable = (KeysetPageable)pageable;
                    paginatedCriteriaBuilder = cb.page(keysetPageable.getKeysetPage(), this.getOffset(pageable), pageable.getPageSize());
                    withCountQuery = keysetPageable.isWithCountQuery();
                    withKeysetExtraction = true;
                    withExtractAllKeysets = keysetPageable.isWithExtractAllKeysets();
                } else {
                    paginatedCriteriaBuilder = cb.page(this.getOffset(pageable), pageable.getPageSize());
                }
                if (withKeysetExtraction) {
                    paginatedCriteriaBuilder.withKeysetExtraction(true);
                    paginatedCriteriaBuilder.withExtractAllKeysets(withExtractAllKeysets);
                }
                paginatedCriteriaBuilder.withCountQuery(withCountQuery);
                query = paginatedCriteriaBuilder.getQuery();
            }
        } else if (pageable == null || pageable.isUnpaged()) {
            EntityViewSetting setting = EntityViewSetting.create(entityViewClass);
            CriteriaBuilder fqb = (CriteriaBuilder)this.evm.applySetting(setting, cb);
            if (sort != null) {
                EntityViewSortUtil.applySort(this.evm, entityViewClass, fqb, sort);
            }
            query = fqb.getQuery();
        } else {
            EntityViewSetting setting = EntityViewSetting.create(entityViewClass, (int)this.getOffset(pageable), (int)pageable.getPageSize());
            if (pageable instanceof KeysetPageable) {
                KeysetPageable keysetPageable = (KeysetPageable)pageable;
                setting.withKeysetPage(keysetPageable.getKeysetPage());
                withCountQuery = keysetPageable.isWithCountQuery();
                withKeysetExtraction = true;
                withExtractAllKeysets = keysetPageable.isWithExtractAllKeysets();
            }
            PaginatedCriteriaBuilder paginatedCriteriaBuilder = (PaginatedCriteriaBuilder)this.evm.applySetting(setting, cb);
            if (withKeysetExtraction) {
                paginatedCriteriaBuilder.withKeysetExtraction(true);
                paginatedCriteriaBuilder.withExtractAllKeysets(withExtractAllKeysets);
            }
            paginatedCriteriaBuilder.withCountQuery(withCountQuery);
            if (sort != null || (sort = pageable.getSort()) != null) {
                EntityViewSortUtil.applySort(this.evm, entityViewClass, paginatedCriteriaBuilder, sort);
            }
            query = paginatedCriteriaBuilder.getQuery();
        }
        return this.applyRepositoryMethodMetadata(query, fetches.length == 0);
    }

    protected Query getModificationQuery(Specification<E> spec, Class<E> domainClass) {
        Predicate predicate;
        BlazeCriteriaBuilder cb = BlazeCriteria.get((CriteriaBuilderFactory)this.cbf);
        BlazeCriteriaDelete query = cb.createCriteriaDelete(this.getDomainClass());
        if (spec != null && (predicate = spec.toPredicate((Root)query.from(domainClass), null, (jakarta.persistence.criteria.CriteriaBuilder)cb)) != null) {
            query.where((Expression)predicate);
        }
        return query.createCriteriaBuilder(this.entityManager).getQuery();
    }

    protected abstract int getOffset(Pageable var1);

    protected <S extends E> TypedQuery<Long> getCountQuery(Specification<S> spec, Class<S> domainClass) {
        BlazeCriteriaBuilder builder = BlazeCriteria.get((CriteriaBuilderFactory)this.cbf);
        BlazeCriteriaQuery query = builder.createQuery(Long.class);
        Root<S> root = this.applySpecificationToCriteria(spec, domainClass, (CriteriaQuery<?>)query);
        if (query.isDistinct()) {
            query.select((Selection)builder.countDistinct(root));
        } else {
            query.select((Selection)builder.count(root));
        }
        query.orderBy(Collections.emptyList());
        return this.applyRepositoryMethodMetadata(query.createCriteriaBuilder(this.entityManager).getQuery(), true);
    }

    private <S extends E> Root<S> applySpecificationToCriteria(Specification<S> spec, Class<S> domainClass, CriteriaQuery<?> query) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        Assert.notNull(query, (String)"CriteriaQuery must not be null!");
        Root root = query.from(domainClass);
        if (spec == null) {
            return root;
        }
        Predicate predicate = spec.toPredicate(root, query, (jakarta.persistence.criteria.CriteriaBuilder)((BlazeCriteriaQuery)query).getCriteriaBuilder());
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        return root;
    }

    private <S> TypedQuery<S> applyRepositoryMethodMetadata(TypedQuery<S> query, boolean applyFetchGraph) {
        if (this.metadata == null) {
            return query;
        }
        LockModeType type = this.metadata.getLockModeType();
        TypedQuery toReturn = type == null ? query : query.setLockMode(type);
        this.applyQueryHints((Query)toReturn, applyFetchGraph);
        return toReturn;
    }

    private void applyQueryHints(Query query, boolean applyFetchGraph) {
        for (Map.Entry<String, Object> hint : this.getQueryHints(applyFetchGraph).entrySet()) {
            query.setHint(hint.getKey(), hint.getValue());
        }
    }

    private static Long executeCountQuery(TypedQuery<Long> query) {
        Assert.notNull(query, (String)"TypedQuery must not be null!");
        List totals = query.getResultList();
        Long total = 0L;
        for (Long element : totals) {
            total = total + (element == null ? 0L : element);
        }
        return total;
    }

    protected static class ExampleSpecification<T>
    implements Specification<T> {
        private static final Method GET_PREDICATE_NEW;
        private final Example<T> example;
        private final EscapeCharacter escapeCharacter;

        public ExampleSpecification(Example<T> example, EscapeCharacter escapeCharacter) {
            Assert.notNull(example, (String)"Example must not be null!");
            Assert.notNull((Object)escapeCharacter, (String)"EscapeCharacter must not be null!");
            this.example = example;
            this.escapeCharacter = escapeCharacter;
        }

        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, jakarta.persistence.criteria.CriteriaBuilder cb) {
            if (GET_PREDICATE_NEW != null) {
                try {
                    return (Predicate)GET_PREDICATE_NEW.invoke(null, cb, this.example, this.escapeCharacter);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return QueryByExamplePredicateBuilder.getPredicate(root, (jakarta.persistence.criteria.CriteriaBuilder)cb, this.example);
        }

        static {
            Method getPredicate = null;
            try {
                getPredicate = QueryByExamplePredicateBuilder.class.getMethod("getPredicate", Root.class, jakarta.persistence.criteria.CriteriaBuilder.class, Example.class, EscapeCharacter.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            GET_PREDICATE_NEW = getPredicate;
        }
    }
}

